// Straight-up (single numbers)
const STRAIGHT = Array.from({ length: 36 }, (_, i) => i); // 0..36

// Splits (pairs)
const SPLIT = [
  [1, 2],
  [1, 4],
  [10, 11],
  [10, 13],
  [11, 12],
  [11, 14],
  [12, 15],
  [13, 14],
  [13, 16],
  [14, 15],
  [14, 17],
  [15, 18],
  [16, 17],
  [16, 19],
  [17, 18],
  [17, 20],
  [18, 21],
  [19, 20],
  [19, 22],
  [2, 3],
  [2, 5],
  [20, 23],
  [21, 22],
  [21, 24],
  [22, 23],
  [22, 25],
  [23, 26],
  [24, 25],
  [24, 27],
  [25, 26],
  [25, 28],
  [26, 29],
  [27, 28],
  [27, 30],
  [28, 29],
  [28, 31],
  [29, 32],
  [3, 6],
  [30, 31],
  [30, 33],
  [31, 32],
  [31, 34],
  [32, 33],
  [32, 35],
  [33, 34],
  [33, 36],
  [34, 35],
  [35, 36],
  [4, 5],
  [4, 7],
  [5, 6],
  [5, 8],
  [6, 9],
  [7, 8],
  [7, 10],
  [8, 9],
  [8, 11],
  [9, 12]
];

// Streets (rows of three)
const STREET = [
  [1, 2, 3],
  [4, 5, 6],
  [7, 8, 9],
  [10, 11, 12],
  [13, 14, 15],
  [16, 17, 18],
  [19, 20, 21],
  [22, 23, 24],
  [25, 26, 27],
  [28, 29, 30],
  [31, 32, 33],
  [34, 35, 36]
];

// Zero trios
const TRIO_ZERO = [
  [0, 1, 2],
  [0, 2, 3]
];

// Corners (squares of four)
const CORNER = [
  [1, 2, 4, 5],
  [10, 11, 13, 14],
  [11, 12, 14, 15],
  [13, 14, 16, 17],
  [14, 15, 17, 18],
  [16, 17, 19, 20],
  [17, 18, 20, 21],
  [19, 20, 22, 23],
  [2, 3, 5, 6],
  [20, 21, 23, 24],
  [22, 23, 25, 26],
  [23, 24, 26, 27],
  [25, 26, 28, 29],
  [26, 27, 29, 30],
  [28, 29, 31, 32],
  [29, 30, 32, 33],
  [3, 4, 6, 7],
  [30, 31, 33, 34],
  [31, 32, 34, 35],
  [33, 34, 35, 36], // normalized from 33,34,36,35
  [4, 5, 7, 8],
  [5, 6, 8, 9]
];

// First four (0-1-2-3)
const FIRST_FOUR = [
  [0, 1, 2, 3]
];

// Double streets (six lines)
const DOUBLE_STREET = [
  [1, 2, 3, 4, 5, 6],
  [4, 5, 6, 7, 8, 9],
  [7, 8, 9, 10, 11, 12],
  [10, 11, 12, 13, 14, 15],
  [13, 14, 15, 16, 17, 18],
  [16, 17, 18, 19, 20, 21],
  [19, 20, 21, 22, 23, 24],
  [22, 23, 24, 25, 26, 27],
  [25, 26, 27, 28, 29, 30],
  [28, 29, 30, 31, 32, 33],
  [31, 32, 33, 34, 35, 36]
];

// Columns (2 to 1)
const COLUMN_2TO1 = [
  [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34], // bottom row (row1)
  [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35], // middle row (row2)
  [3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36]  // top row (row3)
];

// Dozens
const DOZEN = [
  [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
  [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24],
  [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36]
];

// Lows / Highs / Even / Odd / Red / Black
const LOW   = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18];
const HIGH  = [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36];
const EVEN  = [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36];
const ODD   = [1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35];
const RED   = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
const BLACK = [2, 4, 6, 8, 10, 11, 13, 15, 17, 20, 22, 24, 26, 28, 29, 31, 33, 35];

// Optional: a single grouped export (handy if you want to import one object)
const ROULETTE_GROUPS = {
  straight: STRAIGHT,
  split: SPLIT,
  street: STREET,
  trio_zero: TRIO_ZERO,
  corner: CORNER,
  first_four: FIRST_FOUR,
  double_street: DOUBLE_STREET,
  column_2to1: COLUMN_2TO1,
  dozen: DOZEN,
  low: LOW,
  high: HIGH,
  even: EVEN,
  odd: ODD,
  red: RED,
  black: BLACK
};
