

// Help window popups when clicking on the ?



document.addEventListener('mousemove', function (e) {
	const cursorMessage = document.getElementById('cursorMessage');
    if(cursorMessage){
        cursorMessage.style.left = e.pageX + 10 + 'px';
        cursorMessage.style.top = e.pageY + 10 + 'px';
    }
});


function createCursorMessageElement() {
	const cursorMessage = document.createElement('div');
	cursorMessage.id = 'cursorMessage';
	cursorMessage.style.position = 'absolute';
	cursorMessage.style.display = 'none';
	cursorMessage.style.zIndex = '1000';
	cursorMessage.style.background = '#f8f9fa';
	cursorMessage.style.border = '1px solid #ccc';
	cursorMessage.style.padding = '5px';
	cursorMessage.style.borderRadius = '5px';
	cursorMessage.style.fontSize = '12px';
	cursorMessage.style.pointerEvents = 'none';
	cursorMessage.style.transition = 'opacity 0.5s ease';
    return cursorMessage;
	
}

//document.addEventListener('DOMContentLoaded', createCursorMessageElement);

function showMessageAtCursor(message) {
	const cursorMessage = document.getElementById('cursorMessage');
	cursorMessage.textContent = message;
	cursorMessage.style.display = 'block';


	setTimeout(function () {
		cursorMessage.style.display = 'none';
	}, 2000);
}

// Help message Box

function createHelpBox(msg) {
    var helpIconContainer = document.createElement('div');
    
    var helpIcon = document.createElement('div');
    helpIcon.textContent = '?';
    helpIcon.style.cursor = 'pointer'; 
    helpIcon.id = 'help-div';
    
    var helpWindow = document.createElement('div');
    helpWindow.innerHTML = msg;
    helpWindow.className = 'help-window'; 
    helpWindow.style.display = 'none'; 

    helpIcon.onmousemove = function(e) {
        cursorMessage.style.left = e.pageX + 10 + 'px';
        cursorMessage.style.top = e.pageY + 10 + 'px';
    };

    function toggleHelpWindow(event) {
        if (helpWindow.style.display === 'block') {
            helpWindow.style.display = 'none';
        } else {
            helpWindow.style.display = 'block';
        }
        if (event) event.stopPropagation(); 
    }

    helpIcon.onclick = function(event) {
        toggleHelpWindow(event);
    };


    document.addEventListener('click', function() {
        if (helpWindow.style.display === 'block') {
            helpWindow.style.display = 'none';
        }
    });


    helpWindow.onclick = function(event) {
        event.stopPropagation();
    };

    helpIconContainer.appendChild(helpIcon);
    helpIconContainer.appendChild(helpWindow);

    return helpIconContainer;
}


function createTitleWithHelp(title, helpMessage) {
    var container = document.createElement('div');
	container.id = 'title-with-help-div';
    container.className = 'title-with-help-container';

    var evensNmumbersTitle = document.createElement('h4');
    evensNmumbersTitle.innerText = title;
    evensNmumbersTitle.className = 'title-with-help-title';

    var help = createHelpBox(helpMessage);

	container.appendChild(help);
    container.appendChild(evensNmumbersTitle);


    return container;
}