<?php
header('Content-Type: application/json');

/*
$servername = "localhost";
$username = "wes";
$password = "12345";
$dbname = "triggers";
*/

$servername = "localhost";
$username = "u950110925_triggers";
$password = "[o2VJeI2";
$dbname = "u950110925_triggers";

$response = ['success' => false, 'data' => [], 'error' => ''];

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    $response['error'] = "Connection failed: " . $conn->connect_error;
    echo json_encode($response);
    exit();
}

// Retrieve data from POST body
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['id']) && isset($data['misses'])) {
    $id = $conn->real_escape_string($data['id']);
    $misses = $conn->real_escape_string($data['misses']);

    $sql = "UPDATE miss SET misses = ? WHERE id = ?";
    
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("ii", $misses, $id);
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                $response['success'] = true;
                $response['data']['message'] = "Misses updated successfully.";
            } else {
                $response['error'] = "No rows updated. It's possible the ID does not exist or the new value is the same as the old value.";
            }
        } else {
            $response['error'] = "Failed to execute update query.";
        }
        $stmt->close();
    } else {
        $response['error'] = "Failed to prepare the statement.";
    }
} else {
    $response['error'] = "Invalid or incomplete data provided.";
}

echo json_encode($response);
$conn->close();
?>
