

function buildStatsPage()
{

    // ---------------------------------------------------
    // Create Buttons
    // ---------------------------------------------------
    // Evens Button
    var headerData_evens = ['Bet Type','Misses in Row', 'Hits in Row', 'Hits', '% Hit'];
    var height = '300px';
    var width = '600px';
    var id = 'id_stats_table_evens';
    var tableTitle = 'Evens';
    var buttonLabel = 'Evens';
	let evenButton = createButtonWithPopup(id, tableTitle, headerData_evens, width, height, buttonLabel);

    // Dozens Button
    var headerData_evens = ['Bet Type','Misses in Row', 'Hits in Row', 'Hits', '% Hit'];
    var height = '300px';
    var width = '600px';
    var id = 'id_stats_table_dozens';
    var tableTitle = 'Dozens';
    var buttonLabel = 'Dozens';
    let dozenButton = createButtonWithPopup(id, tableTitle, headerData_evens, width, height, buttonLabel);

    // Combo Button
    var headerData_evens = ['Bet Type','Misses in Row', 'Hits in Row', 'Hits', '% Hit'];
    var height = '365px';
    var width = '600px';
    var id = 'id_stats_table_combo';
    var tableTitle = 'Combo';
    var buttonLabel = 'Combo';
    let comboButton = createButtonWithPopup(id, tableTitle, headerData_evens, width, height, buttonLabel);

    // Histogram
    var height = '365px';
    var width = '600px';
    var id = 'id_stats_table_histogram';
    var tableTitle = 'Histogram';
    var buttonLabel = 'Histogram';
    let histogramButton = createButtonWithPopupNoTable(id, tableTitle, width, height, buttonLabel, buildHistogramChart)
                      


    // ---------------------------------------------------
    // Attach onclick to Update buttons
    // ---------------------------------------------------
    var updateButtonEvens = document.getElementById('update_button_id_stats_table_evens');
    if (updateButtonEvens) { updateButtonEvens.onclick = calc_Evens; }

    var updateButtonDozens = document.getElementById('update_button_id_stats_table_dozens');
    if (updateButtonDozens) { updateButtonDozens.onclick = calc_Dozens; }

    var updateButtonCombo = document.getElementById('update_button_id_stats_table_combo');
    if (updateButtonCombo) { updateButtonCombo.onclick = calc_Combo; }

    var updateButtonHistogram = document.getElementById('update_button_id_stats_table_histogram');
    if (updateButtonHistogram) { updateButtonHistogram.onclick = updateHistogramChart; }

    var biasWheelContainer = document.createElement('div');
    biasWheelContainer.id = 'biasWheelContainer';

    //panelStats.appendChild(evenButton);
    // ---------------------------------------------------
    // Add to Panel
    // ---------------------------------------------------
    // Container
    let formContainer = getContainer();

   // formContainer.appendChild(evenLookBackInput);
    formContainer.appendChild(evenButton);
    formContainer.appendChild(dozenButton);
    formContainer.appendChild(document.createElement('br'))
    formContainer.appendChild(comboButton);
    formContainer.appendChild(histogramButton);

    return formContainer;

	//panelStats.appendChild(document.createElement('br')); 

}


function getContainer()
{
    const formContainer = document.createElement('div');
    formContainer.style.maxWidth = '450px';
    formContainer.style.margin = '0 auto';
    formContainer.style.marginLeft = '50px';
    formContainer.style.marginTop = '25px';
    formContainer.style.padding = '20px';
    formContainer.style.borderRadius = '8px';
    formContainer.style.backgroundColor = '#324C6C';
    formContainer.style.boxShadow = '0 4px 6px rgba(0, 0, 0, 0.1)';
    //formContainer.style.display = 'flex';
   // formContainer.style.flexDirection = 'row';
    formContainer.style.gap = '10px';

    return formContainer;
}


function createLookBackSpinInputBox(id)
{


    return textBox;
}

function createButtonWithPopup(id, title, headerData, w, h, buttonLabel) {

    var statButton = document.createElement('button');
    statButton.textContent = buttonLabel;
    statButton.style.padding = '8px 10px';
    statButton.style.fontSize = '14px';
    statButton.style.margin = '5px';
    statButton.style.width = '100px';




    var myTable = createStyledTable(id, title, headerData);
    var div = document.createElement('div');
    div.appendChild(myTable);

    // Create draggable and resizable div
    var draggableDiv = document.createElement('div');
    draggableDiv.id = 'draggable_div_'+id;
    draggableDiv.style.display = 'none';
    draggableDiv.style.width = w;
    draggableDiv.style.height = h;
    draggableDiv.style.background = '#ebf6f7';
    draggableDiv.style.position = 'absolute';
    draggableDiv.style.padding = '10px';
    draggableDiv.style.boxSizing = 'border-box';
    draggableDiv.style.border = '1px solid #ddd';
    draggableDiv.style.borderRadius = '5px';
    draggableDiv.style.cursor = 'move';
    draggableDiv.style.zIndex = '1000';
    

    draggableDiv.appendChild(div);
    document.body.appendChild(draggableDiv);

    var closeButton = document.createElement('div');
    closeButton.textContent = 'X';
    closeButton.style.cursor = 'pointer';
    closeButton.style.position = 'absolute';
    closeButton.style.top = '5px';
    closeButton.style.right = '5px';
    closeButton.style.fontWeight = 'bold';
    draggableDiv.appendChild(closeButton);

    statButton.addEventListener('click', function(event) {
        draggableDiv.style.display = 'block';
        var mouseX = event.clientX;
        var mouseY = event.clientY;
        draggableDiv.style.left = mouseX + 'px';
        draggableDiv.style.top = mouseY + 'px';

    });

    closeButton.addEventListener('click', function() {
        draggableDiv.style.display = 'none';
    });

    var isResizing = false;
    var isDragging = false; // Ensure isDragging is defined within the function scope

    var resizer = document.createElement('div');
    resizer.style.width = '10px';
    resizer.style.height = '10px';
    resizer.style.background = 'red';
    resizer.style.position = 'absolute';
    resizer.style.right = '0';
    resizer.style.bottom = '0';
    resizer.style.cursor = 'se-resize';
    draggableDiv.appendChild(resizer);

    resizer.addEventListener('mousedown', function(e) {
        e.stopPropagation(); // Prevent triggering drag functionality
        isResizing = true;
        var startX = e.clientX;
        var startY = e.clientY;
        var startWidth = parseInt(window.getComputedStyle(draggableDiv).width, 10);
        var startHeight = parseInt(window.getComputedStyle(draggableDiv).height, 10);

        function mouseMoveHandler(e) {
            if (isResizing) {
                draggableDiv.style.width = startWidth + e.clientX - startX + 'px';
                draggableDiv.style.height = startHeight + e.clientY - startY + 'px';
            }
        }

        function mouseUpHandler() {
            isResizing = false;
            window.removeEventListener('mousemove', mouseMoveHandler);
            window.removeEventListener('mouseup', mouseUpHandler);
        }

        window.addEventListener('mousemove', mouseMoveHandler);
        window.addEventListener('mouseup', mouseUpHandler);
        e.preventDefault(); // Prevent selection start
    });

    // Draggable functionality
    draggableDiv.addEventListener('mousedown', function(e) {
        // Skip if the mousedown event is on the resizer
        if (e.target === resizer) return;

        isDragging = true;
        var rect = draggableDiv.getBoundingClientRect();
        var offsetX = e.clientX - rect.left;
        var offsetY = e.clientY - rect.top;

        function mouseMoveHandler(e) {
            if (isDragging) {
                var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                var scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;

                draggableDiv.style.top = (e.clientY - offsetY + scrollTop) + 'px';
                draggableDiv.style.left = (e.clientX - offsetX + scrollLeft) + 'px';
            }
        }

        function mouseUpHandler() {
            isDragging = false;
            window.removeEventListener('mousemove', mouseMoveHandler);
            window.removeEventListener('mouseup', mouseUpHandler);
        }

        window.addEventListener('mousemove', mouseMoveHandler);
        window.addEventListener('mouseup', mouseUpHandler);

         // Mouse move event on the document
         //document.addEventListener('mousemove', onMouseMove);

        // Re-enable dragging when clicking outside the text box
        document.addEventListener('mousedown', function(event) {
            isDragging = true;
        });
   

    }); 
    return statButton;
}

function createButtonWithPopupNoTable(id, title, w, h, buttonLabel, functionCall) {

    var statButton = document.createElement('button');
    statButton.textContent = buttonLabel;
    statButton.style.padding = '8px 10px';
    statButton.style.fontSize = '14px';
    statButton.style.margin = '5px';
    statButton.style.width = '100px';

    var contents = functionCall();
    var div = document.createElement('div');
    div.appendChild(contents);

    // Create draggable and resizable div
    var draggableDiv = document.createElement('div');
    draggableDiv.id = 'draggable_div_'+id;
    draggableDiv.style.display = 'none';
    draggableDiv.style.width = w;
    draggableDiv.style.height = h;
    draggableDiv.style.background = '#ebf6f7';
    draggableDiv.style.position = 'absolute';
    draggableDiv.style.padding = '10px';
    draggableDiv.style.boxSizing = 'border-box';
    draggableDiv.style.border = '1px solid #ddd';
    draggableDiv.style.borderRadius = '5px';
    draggableDiv.style.cursor = 'move';
    draggableDiv.style.zIndex = '1000';
    

    draggableDiv.appendChild(div);
    document.body.appendChild(draggableDiv);

    var closeButton = document.createElement('div');
    closeButton.textContent = 'X';
    closeButton.style.cursor = 'pointer';
    closeButton.style.position = 'absolute';
    closeButton.style.top = '5px';
    closeButton.style.right = '5px';
    closeButton.style.fontWeight = 'bold';
    draggableDiv.appendChild(closeButton);

    statButton.addEventListener('click', function(event) {
        draggableDiv.style.display = 'block';
        var mouseX = event.clientX;
        var mouseY = event.clientY;
        draggableDiv.style.left = mouseX + 'px';
        draggableDiv.style.top = mouseY + 'px';

    });

    closeButton.addEventListener('click', function() {
        draggableDiv.style.display = 'none';
    });

    var isResizing = false;
    var isDragging = false; // Ensure isDragging is defined within the function scope

    var resizer = document.createElement('div');
    resizer.style.width = '10px';
    resizer.style.height = '10px';
    resizer.style.background = 'red';
    resizer.style.position = 'absolute';
    resizer.style.right = '0';
    resizer.style.bottom = '0';
    resizer.style.cursor = 'se-resize';
    draggableDiv.appendChild(resizer);

    resizer.addEventListener('mousedown', function(e) {
        e.stopPropagation(); // Prevent triggering drag functionality
        isResizing = false;
        var startX = e.clientX;
        var startY = e.clientY;
        var startWidth = parseInt(window.getComputedStyle(draggableDiv).width, 10);
        var startHeight = parseInt(window.getComputedStyle(draggableDiv).height, 10);

        function mouseMoveHandler(e) {
            if (isResizing) {
                draggableDiv.style.width = startWidth + e.clientX - startX + 'px';
                draggableDiv.style.height = startHeight + e.clientY - startY + 'px';
            }
        }

        function mouseUpHandler() {
            isResizing = false;
            window.removeEventListener('mousemove', mouseMoveHandler);
            window.removeEventListener('mouseup', mouseUpHandler);
        }

        window.addEventListener('mousemove', mouseMoveHandler);
        window.addEventListener('mouseup', mouseUpHandler);
        e.preventDefault(); // Prevent selection start
    });

    // Draggable functionality
    draggableDiv.addEventListener('mousedown', function(e) {
        // Skip if the mousedown event is on the resizer
        if (e.target === resizer) return;

        isDragging = true;
        var rect = draggableDiv.getBoundingClientRect();
        var offsetX = e.clientX - rect.left;
        var offsetY = e.clientY - rect.top;

        function mouseMoveHandler(e) {
            if (isDragging) {
                var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                var scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;

                draggableDiv.style.top = (e.clientY - offsetY + scrollTop) + 'px';
                draggableDiv.style.left = (e.clientX - offsetX + scrollLeft) + 'px';
            }
        }

        function mouseUpHandler() {
            isDragging = false;
            window.removeEventListener('mousemove', mouseMoveHandler);
            window.removeEventListener('mouseup', mouseUpHandler);
        }

        window.addEventListener('mousemove', mouseMoveHandler);
        window.addEventListener('mouseup', mouseUpHandler);

         // Mouse move event on the document
         //document.addEventListener('mousemove', onMouseMove);

        // Re-enable dragging when clicking outside the text box
        document.addEventListener('mousedown', function(event) {
            isDragging = true;
        });
   

    }); 
    return statButton;
}



function createStyledTable(id, title, headerData, pHolder = 'Look back spins') {

    var container = document.createElement('div');

    var sectionTitle = document.createElement('h2');
    sectionTitle.style.marginTop = "-5px"; 
    sectionTitle.style.marginBottom = "-5px"; 
    sectionTitle.style.marginLeft = "10px"; 
	sectionTitle.innerHTML = title;

    container.appendChild(sectionTitle);

    const textBox = document.createElement('input');
    textBox.setAttribute('type', 'text');
    textBox.setAttribute('placeholder', pHolder);
    textBox.style.padding = '10px';
    textBox.style.marginLeft = '10px';
    textBox.style.borderRadius = '4px';
    textBox.style.border = '1px solid #ccc';
    textBox.style.width = '100px';
    textBox.id = 'look_back_'+id;
    container.appendChild(textBox);


    var statButton = document.createElement('button');
    statButton.textContent = 'Update';
    statButton.style.padding = '8px 10px';
    statButton.style.fontSize = '14px';
    statButton.style.margin = '5px';
    statButton.style.width = '100px';
    statButton.id = 'update_button_'+id;
    container.appendChild(statButton);

    var overSpins = document.createElement('span');
    overSpins.id = 'over_spins_text_'+id;
	overSpins.innerHTML = '';
    container.appendChild(overSpins);

    // Create table
    var table = document.createElement('table');
    table.className = "table-alert";
    table.style.width = '95%'; 
    table.style.maxWidth = '95%'; 
    table.style.borderCollapse = 'collapse';
    table.style.marginLeft = '10px';
    table.style.marginRight = '10px';
    table.style.marginBottom = '10px';


    table.id = id;
    
    // Sample headers
    var headers = headerData;
    var headerRow = document.createElement('tr');
    
    headers.forEach(function(headerText) {
        var header = document.createElement('th');
        header.textContent = headerText;
        header.style.padding = '8px';
        header.style.border = '1px solid #ddd';
        header.style.backgroundColor = '#ed9542';
        headerRow.appendChild(header);
    });
    
    table.appendChild(headerRow);
    
    // Sample data
    var data = [
    ];
    
    // Create and append data rows
    data.forEach(function(rowData) {
        var row = document.createElement('tr');
        
        rowData.forEach(function(cellData) {
            var cell = document.createElement('td');
            cell.textContent = cellData;
            cell.style.padding = '8px';
            cell.style.border = '1px solid #ddd';
            row.appendChild(cell);
        });
        
        table.appendChild(row);
    });
    container.appendChild(table);
    return container;
}


function updateTableData(id, newData) {


    var table = document.getElementById(id); 

    if (!table) {
        return;
    }

    // Delete existing table rows
    if (table && table.rows) {
        while (table.rows.length > 1) {
            table.deleteRow(1);
        }
    }

    newData.forEach(function(rowData) {
        var row = table.insertRow(-1); 
        rowData.forEach(function(cellData) {
            var cell = row.insertCell(-1); 
            cell.textContent = cellData;
        });
    });
}






  






  



