
let auto_play_ddd = false;
let progression_play_ddd = [];
let progression_play_ddd_index = 0;
let ddd_bet_ind_waiting = true;
let ddd_bet_ind_placed = false;
let myBets_ddd = new Map();
let play_single_digit_ddd = true;
let play_double_digit_ddd = false;
let display_bet_only_ddd = false;

const style_ddd = document.createElement('style');
style_ddd.textContent = `
.form-container_ddd {
    display: block;
    width: 600px;
    margin-left: 20px; /* Align to the left */
    padding: 20px;
    border: 1px solid #ccc;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  }

  .form-group_ddd {
    margin-bottom: 15px;
  }

  label_ddd {
    font-weight: bold;
    margin-bottom: 5px;
    display: block;
  }

  input[type="text"].input_ddd {
    width: 100%;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
  }

  button.button_ddd {
    padding: 10px 15px;
    background-color: #4CAF50;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-weight: bold;
  }

  button.button_ddd:hover {
    background-color: #45a049;
  }
`;
document.head.appendChild(style_ddd);

// Function to populate 'button-bar-content'
function ddd() {
    let buttonBarContent = document.getElementById('container-simulations');
    if(buttonBarContent)
    {
        auto_play_ddd = false;
        progression_play_ddd = [];
        let container = document.createElement('div');
        container.id = 'simulation-ddd';
        container.style.marginLeft = '25px';
        container.style.marginBottom = '15px';



        // Simulations Button
        const simButton = document.createElement('button');
        simButton.id = 'sim-buttom-ddd';
        simButton.textContent = "Back to simulations";
        simButton.style.padding = '5px';
        simButton.style.marginTop = '15px';
        simButton.style.marginRight = '5px';
        simButton.onclick = function() {
            buttonBarContent.innerHTML = '';
            let content = simulation_options();
            buttonBarContent.appendChild(content);
        };
        container.appendChild(simButton);

        // Color Changer
        let savedColor = localStorage.getItem(container.id+'-containerIdbackgroundColor');
        if (savedColor) {
            container.style.backgroundColor = savedColor;
        }
        let colorChangerQuickSpin = colorChanger(container.id);
        container.append(colorChangerQuickSpin);

        let title = document.createElement('h2');
        title.innerText = '(DDD) Double Digit Destruction';
        title.style.marginBottom = '10px';
        title.style.color = '#333';
        

        /*******************************************************************
         * START: Help Div
         ******************************************************************/

        // Create the help button
        const button = document.createElement('button');
        button.id = 'help-button-ddd';
        button.textContent = "How to";
        button.style.padding = '5px';
        button.style.marginRight = '5px';
        button.style.marginButton= '5px';
        button.style.marginTop= '10px';
        button.onclick = function() {
            const helpDiv = document.getElementById('help-div-ddd');
            helpDiv.style.display = helpDiv.style.display === 'none' ? 'block' : 'none';
            
        };

        // Create the help div
        const helpDiv = document.createElement('div');
        helpDiv.id = 'help-div-ddd';
        helpDiv.style.display = 'none'; // Initially hidden
        helpDiv.style.position = 'relative';
        helpDiv.style.width = '550px';
        helpDiv.style.padding = '15px';
        helpDiv.style.border = '1px solid #ccc';
        helpDiv.style.borderRadius = '8px';
        helpDiv.style.backgroundColor = '#f9f9f9';
        helpDiv.style.boxShadow = '0px 4px 8px rgba(0, 0, 0, 0.1)';
        helpDiv.style.marginTop = '5px';


        const helpParagraph = document.createElement('p');
        helpParagraph.innerHTML = `
        <h3>Double Digit Destruction</h3>
          After 3 single digits numbers come up in a row, then bet dozen 2 and dozen 3
          using a triple martingale progression. Optionally, if 3 triple digits come up in a row,
          then play dozen 1 and dozen 2.<br> <br><center><b>Single digits (1-9): 24.32%<br>
Double digits (10-36): 72.97%<br>
Zero: 2.70%</b><br><br>

The odds favor the highs<br> Gamble responsibly.<br><br>
<b>Welcome to your new highs n lows</b></center>`;

        helpParagraph.style.fontSize = '24px';
        helpParagraph.style.color = '#555';
        helpParagraph.style.lineHeight = '1.5';

        // Append elements
        
    
        helpDiv.appendChild(helpParagraph);
        container.appendChild(button);
        container.appendChild(helpDiv);

        container.appendChild(title);
        
        let formContent = user_form_ddd();
        container.appendChild(formContent);

        /*******************************************************************
         * END: Help Div
         ******************************************************************/
        buttonBarContent.innerHTML = '';
        buttonBarContent.appendChild(container); 
        }

    
}

function user_form_ddd() {


  // Form Container
  const container = document.createElement('div');
  container.className = 'form-container_ddd';


  // Cache Saved Variables
  const savedZeroType = localStorage.getItem('zeroType_ddd') || 'Zero';
  const savedProgression = localStorage.getItem('progression_ddd') || '1,3,9,27';
  const savedSpins = localStorage.getItem('spins_ddd') || '100';
  const savedSingleDigitWait = localStorage.getItem('single_digit_wait_ddd') || '3';
  const savedDoubleDigitWait = localStorage.getItem('double_digit_wait_ddd') || '3';

  // Container 
  const zeroGroup = document.createElement('div');
  zeroGroup.className = 'form-group_ddd';

  // Label for 0 and 00 radio buttons
  const zeroLabel = document.createElement('label');
  zeroLabel.className = 'label_ddd';
  zeroLabel.textContent = 'Choose Type: ';

  // 0 Radio Button
  const zeroRadio = document.createElement('input');
  zeroRadio.type = 'radio';
  zeroRadio.id = 'zero_ddd';
  zeroRadio.name = 'zero_type_ddd';
  zeroRadio.value = 'Zero';
  zeroRadio.checked = savedZeroType === 'Zero'; 
  const zeroRadioLabel = document.createElement('label');
  zeroRadioLabel.setAttribute('for', 'zero_ddd');
  zeroRadioLabel.textContent = ' Zero ';

  // 00 Radio Button
  const doubleZeroRadio = document.createElement('input');
  doubleZeroRadio.type = 'radio';
  doubleZeroRadio.id = 'doubleZero_ddd';
  doubleZeroRadio.name = 'zero_type_ddd';
  doubleZeroRadio.value = 'Double Zero';
  doubleZeroRadio.checked = savedZeroType === 'Double Zero';
  const doubleZeroRadioLabel = document.createElement('label');
  doubleZeroRadioLabel.setAttribute('for', 'doubleZero_ddd');
  doubleZeroRadioLabel.textContent = ' Double Zero ';

  // 0 and 00 group
  zeroGroup.appendChild(zeroLabel);
  zeroGroup.appendChild(zeroRadio);
  zeroGroup.appendChild(zeroRadioLabel);
  zeroGroup.appendChild(doubleZeroRadio);
  zeroGroup.appendChild(doubleZeroRadioLabel);


  // Form to select single and double digit
    const singleDigitGroup = document.createElement('div');
    singleDigitGroup.className = 'form-group_ddd';
  
  // Single Digit Radio Button
    const singleDigitRadio = document.createElement('input');
    singleDigitRadio.type = 'radio';
    singleDigitRadio.id = 'singleDigit_ddd';
    singleDigitRadio.name = 'digitGroup'; // Group name for radio buttons
    singleDigitRadio.checked = true; // Default selection
    singleDigitRadio.onchange = function () { 
        play_single_digit_ddd = singleDigitRadio.checked; 
        play_double_digit_ddd = false; // Ensure the other option is false
    };

    // Single Digit Label
    const singleDigitLabel = document.createElement('label');
    singleDigitLabel.textContent = ' After ';

    // Single Digit Input
    const singleDigitInput = document.createElement('input');
    singleDigitInput.type = 'number';
    singleDigitInput.id = 'singleDigitInput_ddd';
    singleDigitInput.className = 'input_ddd';
    singleDigitInput.value = savedSingleDigitWait;
    singleDigitInput.addEventListener('blur', saveFormValues_ddd);
  
    // Single Digit Label
    const singleDigitText = document.createElement('span');
    singleDigitText.textContent = ' single digit numbers in a row, bet dozen 2 and dozen 3';
  
    // Single Digit Group Line
    singleDigitGroup.appendChild(singleDigitRadio);
    singleDigitGroup.appendChild(singleDigitLabel);
    singleDigitGroup.appendChild(singleDigitInput);
    singleDigitGroup.appendChild(singleDigitText);
  
    
    // Line for double-digit condition
    const doubleDigitGroup = document.createElement('div');
    doubleDigitGroup.className = 'form-group_ddd';
  
    /*
    const doubleDigitCheckbox = document.createElement('input');
    doubleDigitCheckbox.type = 'checkbox';
    doubleDigitCheckbox.id = 'doubleDigit_ddd';
    doubleDigitCheckbox.checked = play_double_digit_ddd;
    doubleDigitCheckbox.onchange = function () { play_double_digit_ddd = doubleDigitCheckbox.checked;};
  */

    
    const doubleDigitRadio = document.createElement('input');
    doubleDigitRadio.type = 'radio';
    doubleDigitRadio.id = 'doubleDigit_ddd';
    doubleDigitRadio.name = 'digitGroup'; // Same group name
    doubleDigitRadio.checked = false; // Not selected by default
    doubleDigitRadio.onchange = function () { 
        play_double_digit_ddd = doubleDigitRadio.checked; 
        play_single_digit_ddd = false; // Ensure the other option is false
    };


    const doubleDigitLabel = document.createElement('label');
    doubleDigitLabel.textContent = ' After ';
  
    const doubleDigitInput = document.createElement('input');
    doubleDigitInput.type = 'number';
    doubleDigitInput.id = 'doubleDigitInput_ddd';
    doubleDigitInput.className = 'input_ddd';
    doubleDigitInput.value = savedDoubleDigitWait;
    doubleDigitInput.addEventListener('blur', saveFormValues_ddd);
    
    

    const doubleDigitText = document.createElement('span');
    doubleDigitText.textContent = ' double digit numbers in a row, bet dozen 1 and dozen 2';
  
    doubleDigitGroup.appendChild(doubleDigitRadio);
    doubleDigitGroup.appendChild(doubleDigitLabel);
    doubleDigitGroup.appendChild(doubleDigitInput);
    doubleDigitGroup.appendChild(doubleDigitText);
  
   


  // Progression input group
  const progressionGroup = document.createElement('div');
  progressionGroup.className = 'form-group_ddd';

  const progressionLabel = document.createElement('label');
  progressionLabel.className = 'label_ddd';
  progressionLabel.setAttribute('for', 'progression_ddd');
  progressionLabel.textContent = 'Progression (Separate by a comma ,)';

  const progressionInput = document.createElement('input');
  progressionInput.type = 'text';
  progressionInput.id = 'progression_ddd';
  progressionInput.className = 'input_ddd';
  progressionInput.placeholder = '1,3,9,27';
  progressionInput.value = savedProgression; // Set saved progression value
  progressionInput.addEventListener('blur', saveFormValues_ddd);

  progressionGroup.appendChild(progressionLabel);
  progressionGroup.appendChild(progressionInput);

  // Spins input group
  const spinsGroup = document.createElement('div');
  spinsGroup.className = 'form-group_ddd';

  const spinsLabel = document.createElement('label');
  spinsLabel.className = 'label_ddd';
  spinsLabel.setAttribute('for', 'spins_ddd');
  spinsLabel.textContent = 'Spins';


  const spinsInput = document.createElement('input');
  spinsInput.type = 'text';
  spinsInput.id = 'spins_ddd';
  spinsInput.className = 'input_ddd';
  spinsInput.placeholder = '100';
  spinsInput.value = savedSpins; // Set saved spins value
  spinsInput.addEventListener('blur', saveFormValues_ddd);

  spinsGroup.appendChild(spinsLabel);
  spinsGroup.appendChild(spinsInput);

  // Run Tests button
  const runTestsButton = document.createElement('button');
  runTestsButton.className = 'button_ddd';
  runTestsButton.textContent = 'Run Tests';
  runTestsButton.onclick = function () {
    run_tests_ddd();
      saveFormValues_ddd(); // Save form values to local storage when the button is clicked
      
  };

  const displayForm = document.createElement('div');
  displayForm.className = 'display_form_ddd';

  const display_bet_only = document.createElement('input');
  display_bet_only.type = 'checkbox';
  display_bet_only.id = 'display_bet_only_ddd';
  display_bet_only.style.marginLeft = '10px';
  display_bet_only.onchange = function () {
    display_bet_only_ddd = display_bet_only.checked;  
  };

  const display_bet_only_label = document.createElement('label');
  display_bet_only_label.setAttribute('for', 'display_bet_only_ddd');
  display_bet_only_label.textContent = ' Display bets only ';


  displayForm.appendChild(runTestsButton);
  displayForm.appendChild(display_bet_only);
  displayForm.appendChild(display_bet_only_label);

    //************************************************************ */
  // Create the Auto Play checkbox group
  //************************************************************ */
  const autoPlayGroup = document.createElement('div');
  autoPlayGroup.className = 'form-group_ddd';

  const autoPlayCheckbox = document.createElement('input');
  autoPlayCheckbox.type = 'checkbox';
  autoPlayCheckbox.id = 'autoPlay_ddd';
  autoPlayCheckbox.className = 'checkbox_ddd';
  autoPlayCheckbox.onchange = function () {
      // Set or reset the global variable based on the checkbox state
      auto_play_ddd = autoPlayCheckbox.checked;
      
      if(auto_play_ddd)
      {
        progression_play_ddd = get_progression_ddd();
      }
      else
    {
      auto_play_ddd == false;
      progression_play_ddd = [];
    }
  };

  const autoPlayLabel = document.createElement('label');
  autoPlayLabel.setAttribute('for', 'autoPlay_ddd');
  autoPlayLabel.textContent = ' Auto Play';

// Append checkbox and label to the group and then to the container
  autoPlayGroup.appendChild(autoPlayCheckbox);
  autoPlayGroup.appendChild(autoPlayLabel);
//************************************************************ */

  //************************************************************ */
  // Div for table results.
  //************************************************************ */
  let content = document.createElement('div');
  content.id = 'content-_ddd';
//************************************************************ */

  // Append all elements to the container
  container.appendChild(autoPlayGroup);
  container.appendChild(zeroGroup);
  container.appendChild(singleDigitGroup);
  container.appendChild(doubleDigitGroup);
  container.appendChild(progressionGroup);
  container.appendChild(spinsGroup);
  container.appendChild(displayForm);
  




  container.appendChild(content);

  // Save form values to local storage
  function saveFormValues_ddd() {
    const selectedZeroType = document.querySelector('input[name="zero_type_ddd"]:checked').value;
    localStorage.setItem('zeroType_ddd', selectedZeroType);
    localStorage.setItem('progression_ddd', progressionInput.value);

    localStorage.setItem('spins_ddd', spinsInput.value);
    localStorage.setItem('single_digit_wait_ddd', singleDigitInput.value);
    localStorage.setItem('double_digit_wait_ddd', doubleDigitInput.value);

    // Set global variables

  }

  return container;
}

function get_progression_ddd()
{
  let progressionRaw = document.getElementById('progression_ddd').value;
  if (isNaN(progressionRaw))
  {

    document.getElementById('progression_ddd').value = progressionRaw;
  }

  var cleanedProgressionRaw = progressionRaw.replace(/\s+/g, "").replace(/\./g, ",").replace(/[^0-9,]/g, "");
        
  let progression = cleanedProgressionRaw.split(',')
                  .map(number => parseInt(number, 10))
                  .filter(number => !isNaN(number));
                   
  return progression;
}

function get_spins_ddd()
{
  const spinsInput = document.getElementById('spins_ddd').value;

  let spins = parseInt(spinsInput, 10);
  
  if (isNaN(spins) || spins === 0) {
      spins = 100; // Default value
      document.getElementById('spins_ddd').value = spins;
  }
  if (spins > 20000) spins=20000;
  return spins;
}



function run_tests_ddd() {
  
  //****** Get Form Values
  const progression = get_progression_ddd();
  const spins = get_spins_ddd();
  const zeroType = document.querySelector('input[name="zero_type_ddd"]:checked').value;
 
  
  //***************************************************************************
  // Run Test
  //***************************************************************************

  let random_number = [];
  const range = zeroType === 'Zero' ? 37 : 38;
  
  for (let i = 0; i < spins; i++) {
      // Generate a random number between 1 and the specified range
      const randomNum = Math.floor(Math.random() * range) + 1;
      random_number.push(randomNum);
  }



  generate_chart_ddd(progression, random_number)
}

function generate_chart_ddd(progression, random_number) {
  // Create table
  const container = document.createElement('div');
  container.id = 'chart-zero-high_ddd';
  container.className = 'chart-container';

  const table = document.createElement('table');
  table.className = 'chart-table';

  // Create table header
  const headerRow = document.createElement('tr');
  const headers = ["Spin", "Number", "Bet", "Win/Loss", "Profit"];
  headers.forEach(headerText => {
      const th = document.createElement('th');
      th.textContent = headerText;
      headerRow.appendChild(th);
  });
  table.appendChild(headerRow);

  // Call the simulation function
  runSimulation_ddd(progression, random_number, table);

  container.appendChild(table);

  let content = document.getElementById('content-_ddd');
  content.innerHTML = '';
  content.appendChild(container);
}

function runSimulation_ddd(progression, random_number, table) {


  // Simulation Variables
  let lastSpin = null;
  let profit = 0;
  let betting = false;
  let display_bet = true;
  if(display_bet_only_ddd) display_bet = false;

  let progressionIndex = 0;
  let currentBet = 0;


  // Get Single Digit wait
  let single_digit_wait = document.getElementById('singleDigitInput_ddd');
  single_digit_wait = parseInt(single_digit_wait.value, 10);

  if (isNaN(single_digit_wait)) {
    single_digit_wait = 3;
  }


  // Get Double Digit Wait
  let double_digit_wait = document.getElementById('doubleDigitInput_ddd');

  double_digit_wait = parseInt(double_digit_wait.value, 10);

  if (isNaN(double_digit_wait)) {
    double_digit_wait = 3;
  }

  // *******  Play Single Digit  ***************************************
  if (play_single_digit_ddd && !play_double_digit_ddd) {
    let show_bet_line = false;
    random_number.forEach((spin, index) => {
      if (!betting && random_number.length > single_digit_wait) {
        if(check_last_x_numbers_are_single_digit(random_number, index-1, single_digit_wait))
          {
            betting = true;
            show_bet_line = true;
            display_bet = true;
            progressionIndex = 0; // Reset progression when betting starts
          }
      }

      lastSpin = spin;

      // Initialize bet and win/loss
      let bet = 0;
      let winLoss = 0;

      // Bet 2nd and 3rd dozen
      if (betting) {
        
          currentBet = progression[progressionIndex];
          bet = currentBet;

          // Chec
          if (spin >12 && spin<37) {
              winLoss = bet*2-bet; // Win
              profit += winLoss;
              betting = false; // Stop betting on win
              progressionIndex = 0; // Reset progression
          } else {
              winLoss = -bet*2; // Loss
              profit += winLoss;
              //progressionIndex = (progressionIndex + 1) % progression.length; // Move to next progression
              progressionIndex = progressionIndex + 1;
              if(progressionIndex>progression.length-1)
              {
                progressionIndex = 0;
                betting = false;
              }

          }
      }
      if(display_bet_only_ddd)
        {
          
          display_bet = show_bet_line;
        }
        else
        {
          display_bet = true;
        }
      // Display bets in grid.
      if (display_bet) {
          const row = document.createElement('tr');

          // Populate row data
          const rowData = [
              index + 1,                    // Spin Number
              spin === 37 ? "0" : spin === 38 ? "00" : spin, // Number
              bet > 0 ? bet : "-",          // Bet
              winLoss > 0 ? `+${winLoss}` : winLoss < 0 ? `${winLoss}` : "-", // Win/Loss
              profit                        // Profit
          ];

          rowData.forEach(data => {
              const td = document.createElement('td');
              td.textContent = data;
              row.appendChild(td);
          });

          table.appendChild(row);
      }

      // Only display bets lines unless the 'display only bets' checkbox is unchecked, the display all rows.
      show_bet_line = betting;
      
    });
  }

  // *******  Play Double Digit  ***************************************
  if (play_double_digit_ddd && !play_single_digit_ddd) {

    random_number.forEach((spin, index) => {
      let show_bet_line = false;
      if (!betting && random_number.length > double_digit_wait) {
        if(check_last_x_numbers_are_double_digit(random_number, index-1, double_digit_wait))
          {
            betting = true;
            display_bet = true;
            show_bet_line = true;
            progressionIndex = 0; // Reset progression when betting starts
          }
      }

      lastSpin = spin;

      // Initialize bet and win/loss
      let bet = 0;
      let winLoss = 0;

      // Bet 
      if (betting) {
        
          currentBet = progression[progressionIndex];
          bet = currentBet;

          // Chec
          if (spin >0 && spin<25) {
              winLoss = bet*2-bet; // Win
              profit += winLoss;
              betting = false; // Stop betting on win
              progressionIndex = 0; // Reset progression
          } else {
              winLoss = -bet*2; // Loss
              profit += winLoss;
              progressionIndex = progressionIndex + 1;
              if(progressionIndex>progression.length-1)
              {
                progressionIndex = 0;
                betting = false;
              }
          }
      }

      if(display_bet_only_ddd)
        {
          
          display_bet = show_bet_line;
        }
        else
        {
          display_bet = true;
        }

      // Display bets in grid.
      if (display_bet) {
          const row = document.createElement('tr');

          // Populate row data
          const rowData = [
              index + 1,                    // Spin Number
              spin === 37 ? "0" : spin === 38 ? "00" : spin, // Number
              bet > 0 ? bet : "-",          // Bet
              winLoss > 0 ? `+${winLoss}` : winLoss < 0 ? `${winLoss}` : "-", // Win/Loss
              profit                        // Profit
          ];

          rowData.forEach(data => {
              const td = document.createElement('td');
              td.textContent = data;
              row.appendChild(td);
          });

          table.appendChild(row);
      }

      show_bet_line = betting;
      
    });
  }

}




function check_last_x_numbers_are_single_digit(random_number, index, n) {
  if (index < n - 1) {
      // Not enough numbers to check
      return false;
  }

  for (let i = 0; i < n; i++) {
      let num = random_number[index - i];
      if (num>=10 && num<=37 ) {
          return false; // One of the numbers does not meet the condition
      }
  }

  return true; // All numbers meet the condition
}

function check_last_x_numbers_are_double_digit(random_number, index, n) {
  if (index < n - 1) {
      // Not enough numbers to check
      return false;
  }

  for (let i = 0; i < n; i++) {
      let num = random_number[index - i];
      if (num<10 || num>36 ) {
          return false; // One of the numbers does not meet the condition
      }
  }

  return true; // All numbers meet the condition
}



function undo_sim_ddd()
{
  if(auto_play_ddd && play_single_digit_ddd) undo_single_digit_ddd();
  if(auto_play_ddd && play_double_digit_ddd) undo_double_digit_ddd();

}

function undo_single_digit_ddd()
{
  progression_play_ddd_index -= 1;
  if(progression_play_ddd_index<0)
    {
      progression_play_ddd_index = -1;
      ddd_bet_ind_waiting = true;
    } 
    else{
      myBets_ddd = new Map();
      place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
      place_bet_dozen3(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    }
}

function undo_double_digit_ddd()
{
  progression_play_ddd_index -= 1;
  if(progression_play_ddd_index<0)
    {
      progression_play_ddd_index = -1;
      ddd_bet_ind_waiting = true;
    } 
    else{
      myBets_ddd = new Map();
      place_bet_dozen1(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
      place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    }
}


function spin_sim_ddd()
{
  if(auto_play_ddd && play_single_digit_ddd) spin_single_digit_ddd();
  if(auto_play_ddd && play_double_digit_ddd) spin_double_digit_ddd();

}

function spin_single_digit_ddd(){

 
  // Get Single Digit wait
  let single_digit_wait = document.getElementById('singleDigitInput_ddd');
  single_digit_wait = parseInt(single_digit_wait.value, 10);

  if (isNaN(single_digit_wait)) {
    single_digit_wait = 3;
  }

  // ***************************************************
  // Determine when to place a bet
  // ***************************************************
  if(ddd_bet_ind_waiting)
  {
      if (numbers.length >= single_digit_wait) {
        
              if(check_last_x_numbers_are_single_digit(numbers, numbers.length-1, single_digit_wait))
                {
                  ddd_bet_ind_waiting = false;
                  
                }
            }

  }


  // ***************************************************
  // BETS SET DOWN
  // ***************************************************

  // Check if won/loss and place bet or reset
  if(!ddd_bet_ind_waiting && ddd_bet_ind_placed)
  {

    // won - reset
      if(simulation_win_loss)
      {
        
        ddd_bet_ind_placed = false;
        simulation_win_loss = false;
        ddd_bet_ind_placed = false;
        ddd_bet_ind_waiting = true;
        progression_play_ddd_index = 0;
      }else // LOST
      {

          progression_play_ddd_index += 1;

          if(progression_play_ddd_index > progression_play_ddd.length-1)
          {
            
            ddd_bet_ind_placed = false;
            simulation_win_loss = false;
            ddd_bet_ind_placed = false;
            ddd_bet_ind_waiting = true;
            progression_play_ddd_index = 0;
            myBets_ddd = new Map();


          }
          else{
            // Place Bet

            place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
            place_bet_dozen3(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
          }
      }
  }

  // Place first bet
  if(!ddd_bet_ind_waiting && !ddd_bet_ind_placed)
  {

    place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    place_bet_dozen3(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    ddd_bet_ind_placed = true;

  }

}

function spin_double_digit_ddd(){


  let double_digit_wait = document.getElementById('doubleDigitInput_ddd');

  double_digit_wait = parseInt(double_digit_wait.value, 10);

  if (isNaN(double_digit_wait)) {
    double_digit_wait = 3;
  }

  // ***************************************************
  // Determine when to place a bet
  // ***************************************************
  if(ddd_bet_ind_waiting)
  {
      if (numbers.length >= double_digit_wait) {

              if(check_last_x_numbers_are_double_digit(numbers, numbers.length-1, double_digit_wait))
                {
                  ddd_bet_ind_waiting = false;

                }
            }

  }


  // ***************************************************
  // BETS SET DOWN
  // ***************************************************

  // Check if won/loss and place bet or reset
  if(!ddd_bet_ind_waiting && ddd_bet_ind_placed)
  {

    // won - reset
      if(simulation_win_loss)
      {
        
        ddd_bet_ind_placed = false;
        simulation_win_loss = false;
        ddd_bet_ind_placed = false;
        ddd_bet_ind_waiting = true;
        progression_play_ddd_index = 0;
      }else // LOST
      {

          progression_play_ddd_index += 1;

          if(progression_play_ddd_index > progression_play_ddd.length-1)
          {
            
            ddd_bet_ind_placed = false;
            simulation_win_loss = false;
            ddd_bet_ind_placed = false;
            ddd_bet_ind_waiting = true;
            progression_play_ddd_index = 0;
            myBets_ddd = new Map();


          }
          else{
            // Place Bet

            place_bet_dozen1(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
            place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
          }
      }
  }

  // Place first bet
  if(!ddd_bet_ind_waiting && !ddd_bet_ind_placed)
  {

    place_bet_dozen1(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    place_bet_dozen2(myBets_ddd, progression_play_ddd[progression_play_ddd_index]);
    ddd_bet_ind_placed = true;

  }

}