
function _form_container(sim_id, component_id, className = '') {
    const form = document.createElement('div');
    form.className = className;
    form.id = component_id + sim_id;
    return form;
}

function _checkbox(sim_id, component_id, className = '') {
    let checkbox = document.createElement('input');
    checkbox.type = 'checkbox';
    checkbox.className = className;
    checkbox.id = component_id + sim_id;
    return checkbox;
}

function _label(labelForId, text, className = '') {
    let label = document.createElement('label');
    label.setAttribute('for', labelForId);
    label.className = className;
    label.textContent = text;
    return label;
}

function _button(sim_id, component_id, text, className = '') {
    let button = document.createElement('button');
    button.id = component_id + sim_id;
    button.className = className;
    button.textContent = text;
    return button;
}

function _inputBox(sim_id, component_id, placeHolder, value, className = '') {
    let inputBox = document.createElement('input');
    inputBox.type = 'text';
    inputBox.id = component_id + sim_id;
    inputBox.className = className;
    inputBox.placeholder = placeHolder;
    inputBox.value = value; 
    return inputBox;
}