function buildNumberHistory() {
	let historyContainer = document.createElement('div');
	historyContainer.setAttribute('id', 'historyContainer');

let numberUpDisplay = document.createElement('span');
numberUpDisplay.setAttribute('id', 'trigger-results-numberUp-container');


	let historyBoard = document.createElement('div');
	historyBoard.setAttribute('id', 'history');

	
	let button = document.createElement('button');
	button.id = 'undoButton';
	button.className = 'button-55';
	button.setAttribute('role', 'button');
	button.innerText = 'Undo';
	button.onclick = undo;

	let label = document.createElement('label');
	label.id = 'spins';
	label.htmlFor = 'undoButton'; 
	label.innerText = numbers.length;


	let clearSpinsButton = document.createElement('button');
	clearSpinsButton.id = 'clearSpinsButton';
	clearSpinsButton.className = 'button-55';
	clearSpinsButton.setAttribute('role', 'button');
	clearSpinsButton.innerText = 'Clear';
	clearSpinsButton.style.position = "relative";
	clearSpinsButton.style.left = '145px';
	clearSpinsButton.style.marginTop = '5px';


	


 	let labelClearSpinButton = document.createElement('label');
	 labelClearSpinButton.id = 'clearSpinsButton_label';
	label.htmlFor = 'clearSpinsButton'; 
	label.innerText = numbers.length;


	var copyButton = document.createElement('button');
	copyButton.innerText = 'Copy';
	copyButton.classList.add('bulk-button');
	copyButton.setAttribute('id', 'copy-history-button');

	copyButton.addEventListener('click', function () {
		let data = numbers.join(", ");
		navigator.clipboard.writeText(data)
			.then(() => {
				// Success message
				showMessageAtCursor("Copied to clipboard.");
			})
			.catch(err => {
				
				console.error('Failed to copy: ', err);
			});

	});
	historyContainer.appendChild(copyButton);

	historyContainer.appendChild(label);
	historyContainer.appendChild(button); 
	
	historyContainer.appendChild(historyBoard);
	
	historyContainer.appendChild(clearSpinsButton);
	
	
	historyContainer.appendChild(numberUpDisplay);



	clearSpinsButton.addEventListener('click', function () {

		numberHistory = [];
		numbers = [];
	
		showNumberUp("x");
		popHistory();
		showHistoryBoard();
	
		document.getElementById('spins').innerText = "0";
	
		end_of_undo_tasks();
		everyBetClick();
	});

	return historyContainer;
}

function pushHistory_beforeCache() {

	profitHistory.push(bankValue-orginalBankValue);
	historyBankValue.push(bankValue);
	historyCurrentBet.push(currentBet);
	historyWager.push(wager);
	historyLastWager.push(lastWager);
	historBet.push(bet);
	historyNumbersBet.push(numbersBet);
	historyPreviousNumbers.push(previousNumbers);

	showHistoryBoard();
}

function popHistory_beforeCache() {
	if (historyBankValue.length > 0) {
		profitHistory.pop();
		historyBankValue.pop();
		historyCurrentBet.pop();
		historyWager.pop();
		historyLastWager.pop();
		historBet.pop();
		historyNumbersBet.pop();
		historyPreviousNumbers.pop();

		bankValue = historyBankValue[historyBankValue.length - 1];
		
		currentBet = historyCurrentBet[historyCurrentBet.length - 1];

		if (isNaN(bankValue)) bankValue = 1000;
		if (isNaN(currentBet)) currentBet = 0;

		document.getElementById('bankSpan').innerText = '' + bankValue.toLocaleString("en-GB") + '';
		document.getElementById('betSpan').innerText = '' + currentBet.toLocaleString("en-GB") + '';


	}



}
function pushHistory() {
	profitHistory.push(bankValue - orginalBankValue);
	historyBankValue.push(bankValue);
	historyCurrentBet.push(currentBet);
	historyWager.push(wager);
	historyLastWager.push(lastWager);
	historBet.push(bet);
	historyNumbersBet.push(numbersBet);
	historyPreviousNumbers.push(previousNumbers);

	// Save to localStorage
	localStorage.setItem("numberHistoryNumberBoard", JSON.stringify(numbers));
	localStorage.setItem("profitHistory", JSON.stringify(profitHistory));
	localStorage.setItem("historyBankValue", JSON.stringify(historyBankValue));
	localStorage.setItem("historyCurrentBet", JSON.stringify(historyCurrentBet));
	localStorage.setItem("historyWager", JSON.stringify(historyWager));
	localStorage.setItem("historyLastWager", JSON.stringify(historyLastWager));
	localStorage.setItem("historBet", JSON.stringify(historBet));
	localStorage.setItem("historyNumbersBet", JSON.stringify(historyNumbersBet));
	localStorage.setItem("historyPreviousNumbers", JSON.stringify(historyPreviousNumbers));
	localStorage.setItem("sessionProfit", JSON.stringify(session_user_amount_array));
	localStorage.setItem("sessionProfitBoxValue", JSON.stringify(session_user_amount));

	showHistoryBoard();
}
function popHistory() {
	if (historyBankValue.length > 0) {
		profitHistory.pop();
		historyBankValue.pop();
		historyCurrentBet.pop();
		historyWager.pop();
		historyLastWager.pop();
		historBet.pop();
		historyNumbersBet.pop();
		historyPreviousNumbers.pop();

		// Save updated arrays back to localStorage
		localStorage.setItem("numberHistoryNumberBoard", JSON.stringify(numbers));
		localStorage.setItem("profitHistory", JSON.stringify(profitHistory));
		localStorage.setItem("historyBankValue", JSON.stringify(historyBankValue));
		localStorage.setItem("historyCurrentBet", JSON.stringify(historyCurrentBet));
		localStorage.setItem("historyWager", JSON.stringify(historyWager));
		localStorage.setItem("historyLastWager", JSON.stringify(historyLastWager));
		localStorage.setItem("historBet", JSON.stringify(historBet));
		localStorage.setItem("historyNumbersBet", JSON.stringify(historyNumbersBet));
		localStorage.setItem("historyPreviousNumbers", JSON.stringify(historyPreviousNumbers));
		localStorage.setItem("sessionProfitBoxValue", JSON.stringify(session_user_amount));

		// Restore latest state or fallback
		bankValue = historyBankValue[historyBankValue.length - 1] || 1000;
		

		document.getElementById('bankSpan').innerText = bankValue.toLocaleString("en-GB");


		showHistoryBoard();
	}
}


function loadHistoryFromStorage() {
	profitHistory = JSON.parse(localStorage.getItem("profitHistory")) || [];
	historyBankValue = JSON.parse(localStorage.getItem("historyBankValue")) || [];
	historyCurrentBet = JSON.parse(localStorage.getItem("historyCurrentBet")) || [];
	historyWager = JSON.parse(localStorage.getItem("historyWager")) || [];
	historyLastWager = JSON.parse(localStorage.getItem("historyLastWager")) || [];
	historBet = JSON.parse(localStorage.getItem("historBet")) || [];
	historyNumbersBet = JSON.parse(localStorage.getItem("historyNumbersBet")) || [];
	historyPreviousNumbers = JSON.parse(localStorage.getItem("historyPreviousNumbers")) || [];
	numbers = JSON.parse(localStorage.getItem("numberHistoryNumberBoard")) || [];
	session_user_amount_array = JSON.parse(localStorage.getItem("sessionProfit")) || [];
	session_user_amount = JSON.parse(localStorage.getItem("sessionProfitBoxValue")) || 0;
	// Optionally restore current state
	if (historyBankValue.length > 0) {
		bankValue = historyBankValue[historyBankValue.length - 1];
		//currentBet = historyCurrentBet[historyCurrentBet.length - 1];

		document.getElementById('bankSpan').innerText = bankValue.toLocaleString("en-GB");
		//document.getElementById('betSpan').innerText = currentBet.toLocaleString("en-GB");
	}
	let user_session_profit = document.getElementById('session-profit-box');
if(user_session_profit)
{
	user_session_profit.value = session_user_amount;
}


	numberHistory = [...numbers];
	showHistoryBoard();
}
function resetHistoryCache() {
	// Remove from localStorage
	localStorage.removeItem("profitHistory");
	localStorage.removeItem("historyBankValue");
	localStorage.removeItem("historyCurrentBet");
	localStorage.removeItem("historyWager");
	localStorage.removeItem("historyLastWager");
	localStorage.removeItem("historBet");
	localStorage.removeItem("historyNumbersBet");
	localStorage.removeItem("historyPreviousNumbers");
	localStorage.removeItem("numberHistoryNumberBoard");
	localStorage.removeItem("sessionProfit");
	localStorage.removeItem("sessionProfitBoxValue");

	// Reset in-memory variables
	profitHistory = [];
	historyBankValue = [];
	historyCurrentBet = [];
	historyWager = [];
	historyLastWager = [];
	historBet = [];
	historyNumbersBet = [];
	historyPreviousNumbers = [];
	numbers = [];
	session_user_amount_array = [];
	session_user_amount = 77;  // reset to default
	bankValue = 1000;          // reset default
	currentBet = 0;

	// Update UI if applicable
	const bankSpan = document.getElementById('bankSpan');
	if (bankSpan) {
		bankSpan.innerText = bankValue.toLocaleString("en-GB");
	}

	const user_session_profit = document.getElementById('session-profit-box');
	if (user_session_profit) {
		user_session_profit.value = session_user_amount;
	}

	const betSpan = document.getElementById('betSpan');
	if (betSpan) {
		betSpan.innerText = currentBet.toLocaleString("en-GB");
	}

	// Clear board if needed
	if (typeof clearBoard === 'function') {
		clearBoard(); // Optional: if you have a function to clear UI board
	}

	showHistoryBoard(); // Optional: refresh with cleared data
}

function showHistoryBoard() {

	let historyContainer = document.getElementById('history');
	historyContainer.innerText = '';
	for (var x = 0; x < numberHistory.length; x++) {
		let item = document.createElement('div');
		var colourClass = (numRed.includes(numberHistory[x])) ? ' historyRed' : ' historyBlack';
		if (numberHistory[x] == 0) colourClass = ' historyGreen';

		item.setAttribute('class', 'nbnHistory' + colourClass);
		item.innerText = numberHistory[x];

		historyContainer.append(item);
	}

	historyContainer.scrollTop = historyContainer.scrollHeight;


}

function showNumberUp(number) {

	// clear number display
	if(number == "x")
	{
		const container = document.getElementById('trigger-results-numberUp-container');
		container.innerHTML = '';
		return;
	}
    // Select the container
    const container = document.getElementById('trigger-results-numberUp-container');
    container.innerHTML = '';
    // Create an h2 element
    const h2 = document.createElement('h1');
    
    // Create a span element
    const span = document.createElement('span');
    
    // Set the text of the span to the number value
    span.textContent = number;

	var colourClass = (numRed.includes(number)) ? ' historyRed' : ' historyBlack';
	if (number == 0) colourClass = ' historyGreen'
	span.setAttribute('class', 'nbnHistory' + colourClass);
	span.style.backgroundColor = 'white';
	span.style.padding = '5px';
	span.style.width = '25px';
	span.style.display = 'inline-block';

    
    // Append the span to the h2
    h2.appendChild(span);
    
    // Append the h2 to the container
    container.appendChild(h2);
}
