// Top Message
let expDiv = document.createElement('div');
let expDivP = document.createElement('p');
expDivP.textContent = zoom_message || "Zoom message"; // Ensure zoom_message is defined
expDiv.appendChild(expDivP);
document.body.appendChild(expDiv);

let itemDiv = document.createElement('div');
let paragraph = document.createElement('p');
paragraph.textContent = double_zero_message || "Double zero message"; // Ensure double_zero_message is defined
itemDiv.appendChild(paragraph);
document.body.appendChild(itemDiv);

//**************************************************************************************************** */
//************************************************************************************************* */


// Create the main container
let betHistory = document.createElement('div');
betHistory.style.display = "flex";
betHistory.style.flexDirection = "row";
betHistory.style.alignItems = "center"; // Aligns items vertically
betHistory.style.gap = "20px"; // Adds space between sections
betHistory.style.position = "fixed"; // Ensure it stays fixed in place, on top
betHistory.style.zIndex = '999999'; // Very high zIndex to ensure it stays on top
betHistory.style.top = "20px"; // Adjust top positioning
betHistory.style.left = "20px"; // Adjust left positioning
betHistory.style.paddingRight = "15px";
betHistory.style.paddingBottom = "15px";
betHistory.style.backgroundColor = "lightblue"; // Set background color
betHistory.classList.add('hidden'); 

// Create a container for betList and its buttons, with background color
let betListContainer = document.createElement('div');
betListContainer.style.display = "flex";
betListContainer.style.flexDirection = "column";
betListContainer.style.gap = "10px"; // Space between elements

betListContainer.style.padding = "10px"; // Add padding for visual space

// Title for betList
let sessionBetsTitle = document.createElement('h3');
sessionBetsTitle.textContent = "Session Bets";
betListContainer.appendChild(sessionBetsTitle);

// betList
let betList = document.createElement('select');
betList.id = "betList";
betList.size = 10; // Show 10 items
betList.style.overflowY = "scroll"; // Allow vertical scrolling if needed
betList.style.width = "200px"; // Adjust width if needed
betList.addEventListener('change', selectOldBet);
betList.addEventListener('click', selectOldBet);
betListContainer.appendChild(betList);


let renameBtn = document.createElement('button');
renameBtn.textContent = "Rename Item";
renameBtn.addEventListener('click', renameSelectedBet);
betListContainer.appendChild(renameBtn);

let removeBetBtn = document.createElement('button');
removeBetBtn.textContent = "Remove Item";
removeBetBtn.addEventListener('click', removeSelectedBet);
betListContainer.appendChild(removeBetBtn);

// Buttons under betList
let clearListBtn = document.createElement('button');
clearListBtn.textContent = "Clear List";
clearListBtn.addEventListener('click', clearList);
betListContainer.appendChild(clearListBtn);





betHistory.appendChild(betListContainer);

// Create a container for the buttons between betList and betCache
let middleButtonsContainer = document.createElement('div');
middleButtonsContainer.style.display = "flex";
middleButtonsContainer.style.flexDirection = "column";
middleButtonsContainer.style.gap = "10px"; // Space between buttons vertically

let button = document.createElement('button');
button.className = 'button-55';
button.setAttribute('role', 'button');
button.setAttribute('id', 'cach-bet-spin-button');
button.innerText = 'Quick Spin';
middleButtonsContainer.appendChild(button);

// "Close Popup" button
let closePopupBtn = document.createElement('button');
closePopupBtn.textContent = "Close Popup";
closePopupBtn.style.backgroundColor = "#e62c1e"; // Set background color
closePopupBtn.addEventListener('click', function() {
    betHistory.classList.add('hidden'); // Hide the betListContainer
});
middleButtonsContainer.appendChild(closePopupBtn);

// "Save to Cache" button
let saveToCacheBtn = document.createElement('button');
saveToCacheBtn.textContent = "Save to Cache";
saveToCacheBtn.addEventListener('click', saveToCache);
middleButtonsContainer.appendChild(saveToCacheBtn);

// Add the text with <br> tags after the button
let infoText = document.createElement('p');
infoText.innerHTML = "<center><b>Place chips on table<br>Press quick spin<br>To save bets here</b></center>";
middleButtonsContainer.appendChild(infoText);

// Add middle buttons container to betHistory
betHistory.appendChild(middleButtonsContainer);

// Create a container for betCache and its buttons
let betCacheContainer = document.createElement('div');
betCacheContainer.style.display = "flex";
betCacheContainer.style.flexDirection = "column";
betCacheContainer.style.gap = "10px"; // Space between elements

// Title for betCache
let cacheBetsTitle = document.createElement('h3');
cacheBetsTitle.textContent = "Cache Bets";
betCacheContainer.appendChild(cacheBetsTitle);

// betCache
let betCache = document.createElement('select');
betCache.id = "betCache";
betCache.size = 10; // Show 10 items
betCache.style.overflowY = "scroll"; // Allow vertical scrolling if needed
betCache.style.width = "200px"; // Adjust width if needed
betCache.addEventListener('change', selectOldBetCache);
betCache.addEventListener('click', selectOldBetCache);
betCacheContainer.appendChild(betCache);

let renameCacheBtn = document.createElement('button');
renameCacheBtn.textContent = "Rename Item";
renameCacheBtn.addEventListener('click', renameSelectedBetCached);
betCacheContainer.appendChild(renameCacheBtn);

let removeCacheBtn = document.createElement('button');
removeCacheBtn.textContent = "Remove Item";
removeCacheBtn.addEventListener('click', removeSelectedCacheBet);
betCacheContainer.appendChild(removeCacheBtn);

let clearCacheBtn = document.createElement('button');
clearCacheBtn.textContent = "Clear Cache";
clearCacheBtn.addEventListener('click', clearBetCache);
betCacheContainer.appendChild(clearCacheBtn);





betHistory.appendChild(betCacheContainer);

// Make the betHistory draggable and add it to the document
makeElementDraggableNoToggle(betHistory);
document.body.appendChild(betHistory);



//******************************************************************************************************* */
//******************************************************************************************************* */

// Create the statPanelDiv container
let statPanelDiv = document.createElement('div');
statPanelDiv.id = 'stat-panel-top';

// Buttons For Stats
let statButtons_panel = document.createElement('div');
statButtons_panel.className = 'statistics-buttons';
statPanelDiv.appendChild(statButtons_panel);

// Outside Stats
let outsideStats_Panel = document.createElement('div');
outsideStats_Panel.id = 'stats';
outsideStats_Panel.className = 'statistics';
statPanelDiv.appendChild(outsideStats_Panel);

// Append statPanelDiv to the body
document.body.appendChild(statPanelDiv);

// Numbers up Panel
let numbersUp_Panel = document.createElement('div');
numbersUp_Panel.style.paddingTop = "5px";
numbersUp_Panel.style.paddingBottom = "5px";
numbersUp_Panel.setAttribute('id', 'numbersUp-panel');

document.body.appendChild(numbersUp_Panel);

// Create the button bar
let buttonBar_top = document.createElement('div');
buttonBar_top.className = 'button-bar-top';
buttonBar_top.style.marginLeft ="25px";
document.body.appendChild(buttonBar_top); // Place the button bar before the statPanelDiv

let toggleNumbersUpPanelButton = document.createElement('button');
toggleNumbersUpPanelButton.textContent = 'Recent Panel';
buttonBar_top.appendChild(toggleNumbersUpPanelButton);

// Create buttons for showing/hiding the panels
let toggleStatPanelDivButton = document.createElement('button');
toggleStatPanelDivButton.textContent = 'Stats Panel';
buttonBar_top.appendChild(toggleStatPanelDivButton);



// Function to toggle visibility of a div
function toggleVisibility(panel) {
    if (panel.style.display === 'none' || panel.style.display === '') {
        panel.style.display = 'block';
    } else {
        panel.style.display = 'none';
    }
}

// Add event listeners to the buttons
toggleStatPanelDivButton.addEventListener('click', () => {
    toggleVisibility(statPanelDiv);
});

toggleNumbersUpPanelButton.addEventListener('click', () => {
    toggleVisibility(numbersUp_Panel);
});

// Optionally, hide the panels initially
statPanelDiv.style.display = 'none';
numbersUp_Panel.style.display = 'none';



// Alerts Box
let alertsbox = document.createElement('div');
alertsbox.style.display = 'flex';
alertsbox.style.gap = '5px';
alertsbox.style.marginLeft = '25px';
alertsbox.style.padding = '3px';

document.body.appendChild(alertsbox);



// Roulette Board
let rouletteBoard = document.createElement('div');
rouletteBoard.setAttribute('id', 'roulette-board');
document.body.appendChild(rouletteBoard);

// Button Bar
let buttonBar = document.createElement('div');
buttonBar.id = 'button-bar';
buttonBar.style.display = 'flex';
buttonBar.style.justifyContent = 'flex-start';
buttonBar.style.padding = '3px';
buttonBar.style.backgroundColor = 'lightgrey';
buttonBar.style.marginLeft = '25px';
document.body.appendChild(buttonBar);

// Button Bar Click Content
let buttonBarContent = document.createElement('div');
buttonBarContent.style.backgroundColor = '#e8faf3';
buttonBarContent.id = 'button-bar-content';
buttonBarContent.style.marginLeft = '25px';
document.body.appendChild(buttonBarContent);

// Bottom Container
let bottomContainer = document.createElement('div');
bottomContainer.id = 'bottom-container';
bottomContainer.style.display = 'flex';
bottomContainer.style.justifyContent = 'flex-start';
document.body.appendChild(bottomContainer);

// Bottom Container 1
let bottomContainer1 = document.createElement('div');
bottomContainer1.id = 'bottom-container-1';
bottomContainer1.style.marginLeft = '25px';
bottomContainer1.style.marginRight = '10px';
bottomContainer.appendChild(bottomContainer1);

// Bottom Container 2
let bottomContainer2 = document.createElement('div');
bottomContainer2.id = 'bottom-container-2';
bottomContainer.appendChild(bottomContainer2);

// Bottom Container 3
let bottomContainer3 = document.createElement('div');
bottomContainer3.id = 'bottom-container-3';

let dragButtonContainer = document.createElement('div');
dragButtonContainer.id = 'drag-button-container';
dragButtonContainer.style.display = 'flex';
dragButtonContainer.style.flexDirection = 'row'; 
dragButtonContainer.style.alignItems = 'flex-start';
dragButtonContainer.style.justifyContent = 'flex-start';
bottomContainer3.appendChild(dragButtonContainer);

let panelAlertContainer = document.createElement('div');
panelAlertContainer.id = 'panel-alert-container-display';
bottomContainer3.appendChild(panelAlertContainer);

let panelWatchContainer = document.createElement('div');
panelWatchContainer.id = 'panel-watch-container-display';
bottomContainer3.appendChild(panelWatchContainer);

bottomContainer.appendChild(bottomContainer3);

let footerContainer = document.createElement('div');
document.body.appendChild(footerContainer);

function updateBorderVisibility() {
    if (outsideStats_Panel.textContent.trim() === '') {
        outsideStats_Panel.classList.add('hidden-border');
    } else {
        outsideStats_Panel.classList.remove('hidden-border');
    }
}



