let isPopupOpen_Street_LR = false;
let popupContainer_Street_LR = null;

let statLookBack_streetsLR = numbers.length;
let statsLookBackAll_streetsLR = true;

function street_LR_popup() {
    
    if(statsLookBackAll_streetsLR)
    {
        statLookBack_streetsLR = numbers.length; 
       
    }
    var buttonLabel = 'Streets L/R';
    var statButton = document.createElement('button');
    statButton.textContent = buttonLabel;
    statButton.className = "large-button";

    statButton.addEventListener('click', function(event) {
        // Remove any existing popup to ensure a fresh start
        if (popupContainer_Street_LR) {
            popupContainer_Street_LR.remove();
            isPopupOpen_Street_LR = false;
        }

        // Always rebuild the popup from scratch
        build_stats_Street_LR(event.clientX, event.clientY);

        
    });

    return statButton;
}


function build_stats_Street_LR(mouseX, mouseY) {
    isPopupOpen_Street_LR = true;

    // Create the table with header and title
    var headerData_evens = ['Miss', 'Hit', 'Street L', 'Street R', 'Hit', 'Miss'];
    var id = 'id_stats_table_street_lr';
    var tableTitle = 'LR Streets';

    var myTable = create_styled_table_Street_LR(id, tableTitle, headerData_evens);

    popupContainer_Street_LR = document.createElement('div');
    popupContainer_Street_LR.style.display = 'inline-block'; 
    popupContainer_Street_LR.style.border = '1px solid #ddd';
    popupContainer_Street_LR.style.backgroundColor = '#ebf6f7';
    popupContainer_Street_LR.style.padding = '10px';
    popupContainer_Street_LR.style.position = 'absolute';
    popupContainer_Street_LR.style.left = mouseX + 'px';
    popupContainer_Street_LR.style.top = mouseY + 'px';
    popupContainer_Street_LR.style.zIndex = '1000';

    popupContainer_Street_LR.style.width = '400px'; 
    popupContainer_Street_LR.style.maxWidth = '400px'; 
    popupContainer_Street_LR.style.overflowX = 'hidden'; 

    // Add a title at the top of the popup
    var popupTitle = document.createElement('h3');
    popupTitle.textContent = 'Streets L / R';  // Your custom title
    popupTitle.style.textAlign = 'left';
    popupTitle.style.marginTop = '0';
    popupTitle.style.marginLeft = '10px';
    popupTitle.style.marginBottom = '10px';
    popupContainer_Street_LR.appendChild(popupTitle);

    var closeButton = document.createElement('div');
    closeButton.textContent = 'X';
    closeButton.style.cursor = 'pointer';
    closeButton.style.position = 'absolute';
    closeButton.style.top = '5px';
    closeButton.style.right = '5px';
    closeButton.style.fontWeight = 'bold';
    closeButton.addEventListener('click', function() {
        popupContainer_Street_LR.style.display = 'none';
        isPopupOpen_Street_LR = false;
    });

    // Lookback

    let userInput = lookback_feature_streetsLR('statOutside-inputbox-rename', '37', 'statOutside-button-rename', 'statOutside-button-rename-all', 'Lookback', 'All', 'freq-span', '0px');
    let userInputContainer = userInput.container;
    let inputElement = userInputContainer.querySelector('#statOutside-inputbox-rename')
    inputElement.value = statLookBack_streetsLR;

    var freqButton = userInput.buttons.button1;
    var freqButtonAll = userInput.buttons.button2;

if (freqButton) { freqButton.onclick = outsideStatsUpdate_streetsLR; }
if (freqButtonAll) { freqButtonAll.onclick = outsideStatsUpdateAll_streetsLR; }


    popupContainer_Street_LR.appendChild(userInputContainer);
    popupContainer_Street_LR.appendChild(myTable);
    popupContainer_Street_LR.appendChild(closeButton);


    // Create the vnumberContainer-like structure for L/R display
    var vnumberContainer = document.createElement('div');
    vnumberContainer.id = 'vnumberContainer';
    vnumberContainer.style.display = 'flex';
    vnumberContainer.style.overflowX = 'auto';  // Horizontal scrolling if content exceeds width
    vnumberContainer.style.whiteSpace = 'nowrap';
    vnumberContainer.style.width = '100%';  // Set container width to 25% of the popup width
    vnumberContainer.style.maxWidth = '100%';  // Prevent it from growing too wide
    vnumberContainer.style.border = '0px solid black';
    vnumberContainer.style.padding = '0px 10px 10px';
    vnumberContainer.style.boxSizing = 'border-box';
    vnumberContainer.style.marginBottom = '15px';
    vnumberContainer.style.fontSize = '24px';
    vnumberContainer.style.fontWeight = 'bold';

    // Populate the container with numbers and L/R indicators
    for (let i = numbers.length - 1; i >= 0; i--) {
        var number = numbers[i];
  
        const leftStreets = [1, 2, 3, 7, 8, 9, 13, 14, 15, 19, 20, 21, 25, 26, 27, 31, 32, 33];
        const rightStreets = [4, 5, 6, 10, 11, 12, 16, 17, 18, 22, 23, 24, 28, 29, 30, 34, 35, 36];

        // Create a container for each number and its L/R result
        let itemContainer = document.createElement('div');
        itemContainer.style.display = 'inline-block';
        itemContainer.style.textAlign = 'center';
        itemContainer.style.padding = '0 10px';

        // Create the number element (top row)
        let numberDiv = document.createElement('div');
        number = number === 37 ? 0:number;
        numberDiv.className = number === 0 ? 'historyGreen' : [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36].includes(number) ? 'historyRed' : 'historyBlack';
        numberDiv.style.display = 'block';
        numberDiv.textContent = number;

        // Create the result element (bottom row)
        let resultDiv = document.createElement('div');
        resultDiv.className = leftStreets.includes(number) ? 'left-label' : 'right-label';
        resultDiv.style.display = 'block';
        resultDiv.textContent = leftStreets.includes(number) ? 'L' : rightStreets.includes(number) ? 'R' : '-';


        // Append number and result to the item container
        itemContainer.appendChild(numberDiv);
        itemContainer.appendChild(resultDiv);

        // Append the item container to the main container
        vnumberContainer.appendChild(itemContainer);
    };

    // Add the vnumberContainer to the popup
    popupContainer_Street_LR.appendChild(vnumberContainer);


    var howToUseLink = document.createElement('a');
    howToUseLink.textContent = 'How to Use';
    howToUseLink.href = './items/streetsLR.html';
    howToUseLink.target = '_blank';
    howToUseLink.style.display = 'block';
    howToUseLink.style.marginTop = '10px';
    howToUseLink.style.textDecoration = 'underline';
    howToUseLink.style.color = '#007BFF';
    popupContainer_Street_LR.appendChild(howToUseLink);

    document.body.appendChild(popupContainer_Street_LR);




    dragPopup_Streets_LR(popupContainer_Street_LR);

    // Populate the table with loss data
    populate_table_Street_LF(id);

    // Resize the container to fit the table
    adjust_container_size_Street_LR();
}

function create_styled_table_Street_LR(id, title, headerData) {
    // Create table
    var table = document.createElement('table');
    table.className = "table-alert";
    table.style.width = 'auto'; 
    table.style.maxWidth = 'auto'; 
    table.style.borderCollapse = 'collapse';
    table.style.marginLeft = '10px';
    table.style.marginRight = '10px';
    table.style.marginBottom = '10px';

    table.id = id;

    // Sample headers
    var headers = headerData;
    var headerRow = document.createElement('tr');

    headerData.forEach((headerText, index) => {
        var header = document.createElement('th');
        header.textContent = headerText;
        header.style.padding = '8px';
        header.style.border = '1px solid #ddd';
        header.style.backgroundColor = '#ed9542';
        header.style.whiteSpace = 'nowrap'; // Prevent wrapping
        headerRow.appendChild(header);

         // Add click event listener for sorting
         header.addEventListener('click', function() {
            sortTable_streetLR(id, index);
        });
    });

    table.appendChild(headerRow);

    return table;
}

function dragPopup_Streets_LR(element) {
    $(element).draggable({
        stop: function(event, ui) {
            // Save the new position when dragging stops
            var position = ui.position;
            localStorage.setItem(element.id, JSON.stringify(position));
        }
    });

    // Apply the last known position, if available
    var savedPosition = localStorage.getItem(element.id);
    if (savedPosition) {
        var position = JSON.parse(savedPosition);
        $(element).css({
            top: position.top + 'px',
            left: position.left + 'px',
            position: 'absolute'
        });
    }
}



function adjust_container_size_Street_LR() {
    if (popupContainer_Street_LR) {
        // Set fixed size or limit maximum size

        popupContainer_Street_LR.style.maxHeight = '600px';
        popupContainer_Street_LR.style.overflow = 'auto'; // Add scrollbars if needed
        popupContainer_Street_LR.style.width = 'auto';
        popupContainer_Street_LR.style.maxWidth = '400px'; // Prevent from growing too wide
        popupContainer_Street_LR.style.overflowX = 'auto';

        // Ensure the container resizes to fit the table without expanding indefinitely
        popupContainer_Street_LR.style.width = 'auto';
        popupContainer_Street_LR.style.height = 'auto';
        popupContainer_Street_LR.style.width = popupContainer_Street_LR.scrollWidth + 'px';
        popupContainer_Street_LR.style.height = popupContainer_Street_LR.scrollHeight + 'px';
    }
}



function calculate_losses_Street_LR_XXX() {
    const rows = [
        [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34],  // First row
        [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35],  // Second row
        [3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36]   // Third row
    ];

    const dozens = [
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],   // First dozen
        [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24],  // Second dozen
        [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36]   // Third dozen
    ];

    const missCounts = {};

    const combinations = [
        { name: 'Dozen 1 Row 1', dozen: dozens[0], row: rows[0] },
        { name: 'Dozen 1 Row 2', dozen: dozens[0], row: rows[1] },
        { name: 'Dozen 1 Row 3', dozen: dozens[0], row: rows[2] },
        { name: 'Dozen 2 Row 1', dozen: dozens[1], row: rows[0] },
        { name: 'Dozen 2 Row 2', dozen: dozens[1], row: rows[1] },
        { name: 'Dozen 2 Row 3', dozen: dozens[1], row: rows[2] },
        { name: 'Dozen 3 Row 1', dozen: dozens[2], row: rows[0] },
        { name: 'Dozen 3 Row 2', dozen: dozens[2], row: rows[1] },
        { name: 'Dozen 3 Row 3', dozen: dozens[2], row: rows[2] },
        { name: 'Dozen 1 Dozen 2', dozen1: dozens[0], dozen2: dozens[1] },
        { name: 'Dozen 1 Dozen 3', dozen1: dozens[0], dozen2: dozens[2] },
        { name: 'Dozen 2 Dozen 3', dozen1: dozens[1], dozen2: dozens[2] },
        { name: 'Row 1 Row 2', row1: rows[0], row2: rows[1] },
        { name: 'Row 1 Row 3', row1: rows[0], row2: rows[2] },
        { name: 'Row 2 Row 3', row1: rows[1], row2: rows[2] },
    ];

    combinations.forEach(combo => missCounts[combo.name] = 0);

    for (let i = 0; i < numbers.length; i++) {
        combinations.forEach(combo => {
            let missed = false;

            if (combo.row && combo.dozen) {
                missed = !combo.row.includes(numbers[i]) && !combo.dozen.includes(numbers[i]);
            } else if (combo.dozen1 && combo.dozen2) {
                missed = !combo.dozen1.includes(numbers[i]) && !combo.dozen2.includes(numbers[i]);
            } else if (combo.row1 && combo.row2) {
                missed = !combo.row1.includes(numbers[i]) && !combo.row2.includes(numbers[i]);
            }

            if (missed) {
                missCounts[combo.name]++;
            } else {
                missCounts[combo.name] = 0;
            }
        });
    }

    return Object.keys(missCounts).map(key => ({
        combination: key,
        losses: missCounts[key]
    })).sort((a, b) => b.losses - a.losses);
}




function calculate_hits_misses_Street_LR() {
    var newArray = numbers.slice(-statLookBack_streetsLR);
    const streets = [
        [1, 2, 3],  // Street 1
        [4, 5, 6],  // Street 2
        [7, 8, 9],  // Street 3
        [10, 11, 12], // Street 4
        [13, 14, 15], // Street 5
        [16, 17, 18], // Street 6
        [19, 20, 21], // Street 7
        [22, 23, 24], // Street 8
        [25, 26, 27], // Street 9
        [28, 29, 30], // Street 10
        [31, 32, 33], // Street 11
        [34, 35, 36]  // Street 12
    ];

    const hitMissCounts = streets.map(street => ({
        street,
        totalHits: 0,  // Count total hits from the start of the spins
        lastMisses: 0  // Count misses until the last hit
    }));

    for (let i = 0; i < newArray.length; i++) {
        hitMissCounts.forEach(entry => {
            if (entry.street.includes(newArray[i])) {
                // If the current number is a hit, increment total hits
                entry.totalHits++;
                entry.lastMisses = 0;  // Reset the miss count
            } else {
                // If not a hit, increment the miss count
                entry.lastMisses++;
            }
        });
    }

    return hitMissCounts;
}

function populate_table_Street_LF(tableId) {
    const table = document.getElementById(tableId);
    
    if (!table) {
        console.error("Table not found:", tableId);
        return;
    }

    // Clear existing rows
    while (table.rows.length > 1) {
        table.deleteRow(1);
    }

    const hitMissData = calculate_hits_misses_Street_LR();
    
    // Iterate in pairs to combine two streets in one row
    for (let i = 0; i < hitMissData.length; i += 2) {
        const row = table.insertRow();

        const miss1 = row.insertCell(0);
        const hit1 = row.insertCell(1);
        const street1 = row.insertCell(2);
        const street2 = row.insertCell(3);
        const hit2 = row.insertCell(4);
        const miss2 = row.insertCell(5);

        // Fill data for the first street
        miss1.textContent = hitMissData[i].lastMisses;
        hit1.textContent = hitMissData[i].totalHits;
        street1.textContent = hitMissData[i].street[0]; // Display only the first number

        // If there's a second street, fill data for it; otherwise, leave empty
        if (hitMissData[i + 1]) {
            street2.textContent = hitMissData[i + 1].street[0]; // Display only the first number
            hit2.textContent = hitMissData[i + 1].totalHits;
            miss2.textContent = hitMissData[i + 1].lastMisses;
        } else {
            street2.textContent = '';
            hit2.textContent = '';
            miss2.textContent = '';
        }

        // Apply styling to distinguish the columns
        street1.style.textAlign = 'center';
        street2.style.textAlign = 'center';
       // street1.style.backgroundColor = '#f2f2f2'; // Light gray background for street columns
       // street2.style.backgroundColor = '#f2f2f2'; // Light gray background for street columns

        miss1.style.textAlign = 'center';
        hit1.style.textAlign = 'center';
        miss2.style.textAlign = 'center';
        hit2.style.textAlign = 'center';

        miss1.style.backgroundColor = '#ffe6e6'; // Light green for misses
        hit1.style.backgroundColor =  '#e6ffe6'; // Light red for hits

        miss2.style.backgroundColor = '#ffe6e6'; // Light green for misses
        hit2.style.backgroundColor = '#e6ffe6';  // Light red for hits

        // Prevent wrapping for better display
        miss1.style.whiteSpace = 'nowrap';
        hit1.style.whiteSpace = 'nowrap';
        street1.style.whiteSpace = 'nowrap';
        street2.style.whiteSpace = 'nowrap';
        hit2.style.whiteSpace = 'nowrap';
        miss2.style.whiteSpace = 'nowrap';
    }

    let streetResults = calculateStreetHitsAndMisses();

    const row = table.insertRow();

    const miss1 = row.insertCell(0);
    const hit1 = row.insertCell(1);
    const street1 = row.insertCell(2);
    const street2 = row.insertCell(3);
    const hit2 = row.insertCell(4);
    const miss2 = row.insertCell(5);

    miss1.textContent = streetResults.left.currentMissStreak;
    hit1.textContent = streetResults.left.hits;
    street1.textContent = 'L';
    street2.textContent = 'R';
    hit2.textContent = streetResults.right.hits;
    miss2.textContent = streetResults.right.currentMissStreak;

            // Apply styling to distinguish the columns
            street1.style.textAlign = 'center';
            street2.style.textAlign = 'center';
           // street1.style.backgroundColor = '#f2f2f2'; // Light gray background for street columns
           // street2.style.backgroundColor = '#f2f2f2'; // Light gray background for street columns
    
            miss1.style.textAlign = 'center';
            hit1.style.textAlign = 'center';
            miss2.style.textAlign = 'center';
            hit2.style.textAlign = 'center';
    
            miss1.style.backgroundColor = '#ffe6e6'; // Light green for misses
            hit1.style.backgroundColor =  '#e6ffe6'; // Light red for hits
    
            miss2.style.backgroundColor = '#ffe6e6'; // Light green for misses
            hit2.style.backgroundColor = '#e6ffe6';  // Light red for hits
    
            // Prevent wrapping for better display
            miss1.style.whiteSpace = 'nowrap';
            hit1.style.whiteSpace = 'nowrap';
            street1.style.whiteSpace = 'nowrap';
            street2.style.whiteSpace = 'nowrap';
            hit2.style.whiteSpace = 'nowrap';
            miss2.style.whiteSpace = 'nowrap';


    // Adjust container size to fit the table
    adjust_container_size_Street_LR();
}




function updateTable_Street_LR() {
    const tableId = 'id_stats_table_street_lr';
    const table = document.getElementById(tableId);

    if(statsLookBackAll_streetsLR)
    {
        statLookBack_streetsLR  = numbers.length;
        
    }

    if (table) {

        if(statsLookBackAll_streetsLR)
            {
                let spinBox = document.getElementById('statOutside-inputbox-rename');
                spinBox.value = numbers.length;
                statLookBack_streetsLR  = numbers.length;
                
            }

        // Clear and repopulate table data
        populate_table_Street_LF(tableId);

        // Reapply sorting if previously sorted
        const lastSortCol = table.getAttribute("data-sort-column");
        const lastSortDir = table.getAttribute("data-sort-direction");
        if (lastSortCol !== null) {
            sortTable_streetLR(tableId, parseInt(lastSortCol), lastSortDir);
        }
                // Update the L/R scroll box
                populateLRScrollBox();
    } 
}

function populateLRScrollBox() {
    const lrScrollBox = document.getElementById('vnumberContainer');
    if (!lrScrollBox) {
        console.warn("L/R scroll box not found.");
        return;
    }

    // Clear existing content
    while (lrScrollBox.firstChild) {
        lrScrollBox.removeChild(lrScrollBox.firstChild);
    }

    const leftStreets = [1, 2, 3, 7, 8, 9, 13, 14, 15, 19, 20, 21, 25, 26, 27, 31, 32, 33];
    const rightStreets = [4, 5, 6, 10, 11, 12, 16, 17, 18, 22, 23, 24, 28, 29, 30, 34, 35, 36];

    // Populate the container with numbers and L/R indicators
    for (let i = numbers.length - 1; i >= 0; i--) {
        var number = numbers[i];
        number = number === 37 ? 0 : number;  // Adjust for roulette wheel number conversion

        // Create a container for each number and its L/R result
        let itemContainer = document.createElement('div');
        itemContainer.style.display = 'inline-block';
        itemContainer.style.textAlign = 'center';
        itemContainer.style.padding = '0 10px';

        // Create the number element (top row)
        let numberDiv = document.createElement('div');
        numberDiv.className = number === 0 ? 'historyGreen' : 
            [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36].includes(number) ? 'historyRed' : 'historyBlack';
        numberDiv.style.display = 'block';
        numberDiv.textContent = number;

        // Create the result element (bottom row)
        let resultDiv = document.createElement('div');
        resultDiv.className = leftStreets.includes(number) ? 'left-label' : 'right-label';
        resultDiv.style.display = 'block';
        resultDiv.textContent = leftStreets.includes(number) ? 'L' : rightStreets.includes(number) ? 'R' : '-';

        // Append number and result to the item container
        itemContainer.appendChild(numberDiv);
        itemContainer.appendChild(resultDiv);

        // Append the item container to the main container
        lrScrollBox.appendChild(itemContainer);
    }
}

//***************************** */


function calculateStreetHitsAndMisses() {
    const leftStreets = [1, 2, 3, 7, 8, 9, 13, 14, 15, 19, 20, 21, 25, 26, 27, 31, 32, 33];
    const rightStreets = [4, 5, 6, 10, 11, 12, 16, 17, 18, 22, 23, 24, 28, 29, 30, 34, 35, 36];

    
    let results = {
        left: { hits: 0, currentMissStreak: 0, maxMissStreak: 0 },
        right: { hits: 0, currentMissStreak: 0, maxMissStreak: 0 }
    };

    numbers.forEach(number => {
        // Check hits and misses for left streets
        if (leftStreets.includes(number)) {
            results.left.hits++;
            results.left.currentMissStreak = 0;  // Reset misses streak for a hit
        } else {
            results.left.currentMissStreak++;
            if (results.left.currentMissStreak > results.left.maxMissStreak) {
                results.left.maxMissStreak = results.left.currentMissStreak;  // Update maximum misses streak
            }
        }

        // Check hits and misses for right streets
        if (rightStreets.includes(number)) {
            results.right.hits++;
            results.right.currentMissStreak = 0;  // Reset misses streak for a hit
        } else {
            results.right.currentMissStreak++;
            if (results.right.currentMissStreak > results.right.maxMissStreak) {
                results.right.maxMissStreak = results.right.currentMissStreak;  // Update maximum misses streak
            }
        }
    });

    return results;
}


function sortTable_streetLR(tableId, columnIndex, forceDirection = null) {
    let table = document.getElementById(tableId);
    if (!table) return;  // Ensure the table exists

    // Get current sort settings from table attributes
    let lastSortedColumn = table.getAttribute("data-sort-column");
    let currentDirection = table.getAttribute("data-sort-direction");

    // Determine the new direction based on incoming parameters or toggle logic
    let dir;
    if (forceDirection) {
        dir = forceDirection;
    } else {
        if (columnIndex.toString() === lastSortedColumn) {
            dir = currentDirection === "asc" ? "desc" : "asc";
        } else {
            dir = "asc"; // Default to ascending on new column click
        }
    }

    let switching = true;
    let switchcount = 0;

    while (switching) {
        switching = false;
        let rows = table.rows;

        for (let i = 1; i < rows.length - 1; i++) {
            let shouldSwitch = false;
            let x = rows[i].getElementsByTagName("TD")[columnIndex];
            let y = rows[i + 1].getElementsByTagName("TD")[columnIndex];
            if (!x || !y) continue; // Skip if cells are missing

            let xContent = isNaN(parseFloat(x.innerHTML)) ? x.innerHTML.toLowerCase() : parseFloat(x.innerHTML);
            let yContent = isNaN(parseFloat(y.innerHTML)) ? y.innerHTML.toLowerCase() : parseFloat(y.innerHTML);

            if ((dir === "asc" && xContent > yContent) || (dir === "desc" && xContent < yContent)) {
                shouldSwitch = true;
            }

            if (shouldSwitch) {
                rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                switching = true;
                switchcount++;
                break;
            }
        }

        // Only toggle if no switch occurred and it's not a forced direction
        if (switchcount === 0 && !forceDirection) {
            dir = dir === "asc" ? "desc" : "asc";
            switching = true;
        }
    }

    // Save the current state
    table.setAttribute("data-sort-column", columnIndex);
    table.setAttribute("data-sort-direction", dir);
}

function lookback_feature_streetsLR(textboxId, pHolder, button1Id, button2Id,  button1Text, button2Text, spanId, marginLeft){


	let container = document.createElement('div');

	const textBox = document.createElement('input');
    textBox.setAttribute('type', 'text');
    textBox.style.padding = '10px';
    textBox.style.marginLeft = marginLeft;
    textBox.style.borderRadius = '4px';
    textBox.style.border = '1px solid #ccc';
    textBox.style.width = '100px';
    textBox.id = textboxId;
    container.appendChild(textBox);




    var button1 = document.createElement('button');
    button1.textContent = button1Text;
    button1.style.padding = '8px 10px';
    button1.style.fontSize = '14px';
    button1.style.margin = '5px';
    button1.style.width = '100px';
    button1.id = button1Id;
    container.appendChild(button1);

	var button2 = document.createElement('button');
    button2.textContent = button2Text;
    button2.style.padding = '8px 10px';
    button2.style.fontSize = '14px';
    button2.style.margin = '5px';
    button2.style.width = '100px';
    button2.id = button2Id;
    container.appendChild(button2);

	return  {
        container,
        buttons: {
            button1: button1, 
            button2: button2 
        }
	};
}

function outsideStatsUpdate_streetsLR(){
    let spinBox = document.getElementById('statOutside-inputbox-rename');
    spinLength = ensureInputValue_streetsLR(spinBox.value,37);
    if(spinLength>numbers.length) {spinLength = numbers.length; }
    statLookBack_streetsLR = spinLength;
    statsLookBackAll_streetsLR = false;
    updateTable_Street_LR()
}

function outsideStatsUpdateAll_streetsLR(){
    let spinBox = document.getElementById('statOutside-inputbox-rename');
    spinBox.value = numbers.length;
    statLookBack_streetsLR = numbers.length;
    statsLookBackAll_streetsLR = true;
    updateTable_Street_LR()
}
function ensureInputValue_streetsLR(textBoxValue, defaultValue, lessThan=0, greaterThan = 1000000) {
   
    let num = Number(textBoxValue);

    if (isNaN(num) || num >= greaterThan || num <= lessThan) {
	
        return defaultValue;
    }

    return num;
}
