var  _patternLength = 3;
var _patternMultiplier = 2;

function updatePatternNewNumber()
{
  let container = document.getElementById('button-bar-div-7');
  if(container){
    container.innerHTML = '';
    let newBoard = getPattern();
    container.appendChild(newBoard);
  }

}


function getPattern() {
  

  var patternLength =  _patternLength;
  var patternMultiplier = _patternMultiplier;
  var patternTotal = patternLength * patternMultiplier;

  const patternContainer = patternDivContainer();


  // get input
  let userInput = patternUserInput();
  patternContainer.appendChild(userInput);

  
  const pantternTable = patternTable();

  const theadCounts = document.createElement('thead');


  // Base
  const patternHeaders = getPatternTableHeader(patternTotal);

  // Content
  const patternRB = getPatternRB(patternLength, patternMultiplier);
  const patternEO = getPatternEO(patternLength, patternMultiplier);
  const patternHL = getPatternHL(patternLength, patternMultiplier);
  const patternDozen = getPatternDozen(patternLength, patternMultiplier);
  const patternRow = getPatternRow(patternLength, patternMultiplier);

  theadCounts.appendChild(patternHeaders);
  theadCounts.appendChild(patternRB);
  theadCounts.appendChild(patternEO);
  theadCounts.appendChild(patternHL);
  theadCounts.appendChild(patternDozen);
  theadCounts.appendChild(patternRow);

  pantternTable.appendChild(theadCounts);

  patternContainer.appendChild(pantternTable);



  return patternContainer;
}

function getPatternTitle()
{
  let titleDiv = document.createElement('div');
  let title = document.createElement('span');
  title.style.display = 'inline-block';
  title.innerHTML = 'Pattern Break';
  title.style.marginTop = '5px';
  title.style.marginBottom = '-10px';
  title.style.marginLeft = '60px';
  titleDiv.appendChild(title);
  return titleDiv;
}
function patternDivContainer() {
  const countContainer = document.createElement('div');
  countContainer.id = 'missed-div';
  countContainer.style.width = '100%'; 
  //countContainer.style.overflowX = 'hidden'; 
  countContainer.style.marginTop = '35px';
  countContainer.style.marginLeft = '75px';
  countContainer.style.marginBottom = '50px';
  countContainer.style.display = 'block';
  countContainer.style.border = '0px solid #ccc';
  countContainer.style.overflowY = 'auto'; 
  countContainer.style.height = 'auto';
  countContainer.style.position = 'relative';

  let savedColor = localStorage.getItem(countContainer.id+'-containerIdbackgroundColor');
  if (savedColor) {
    countContainer.style.backgroundColor = savedColor;
  }

  let colorChangerQuickSpin = quickSpin_colorChanger(countContainer.id);
  countContainer.append(colorChangerQuickSpin);

  return countContainer;
}

function patternTable() {
  var table = document.createElement('table');
  table.id = 'pattern-table'; 
  table.style.borderCollapse = 'collapse';
  table.style.tableLayout = 'auto';
  table.style.width = 'auto'; 
  table.style.marginBottom = '25px';
  table.style.marginLeft = '50px';
  return table;
}

function tableHeaderPattern()
{
  const th = document.createElement('th');
    th.style.position = 'sticky';
    th.style.top = '0';
    th.style.backgroundColor = '#f9f9f9';
    th.style.zIndex = '10';
    th.style.padding = '8px';
    th.style.textAlign = 'center';
    th.style.border = '1px solid #ddd';
    th.style.boxSizing = 'border-box';
    return th;
}

function getPatternTableHeader(total){

  const basetr = document.createElement('tr');
  
  var th = tableHeaderPattern();
  th.textContent = 'Bet';
  th.style.width = '65px';
  basetr.appendChild(th);
  
  basetr.appendChild(th);

  return basetr;
}

function checkSegments(numberSegment) {
  // Calculate the total length of segments to compare
  let totalSegmentLength = _patternLength * _patternMultiplier;
  
  // Check if the segments can be exactly formed
  if (numberSegment.length < totalSegmentLength) {
      return false; // Not enough elements to form the desired segments
  }

  // Split the array into the necessary segments
  let segments = [];
  for (let i = 0; i < _patternMultiplier; i++) {
      let start = i * _patternLength;
      let segment = numberSegment.slice(start, start + _patternLength);
      segments.push(segment);
  }

  // Compare the segments
  let firstSegment = segments[0].join(''); // Convert to string for easy comparison
  for (let i = 1; i < segments.length; i++) {
      if (firstSegment !== segments[i].join('')) {
          return false; // Segments are not equal
      }
  }

  if(numberSegment.includes('-'))
  {
    return false;
  }

  return true; // All segments are equal
}

function changeRB(segment)
{
  var red = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
  var black = [2, 4, 6, 8, 10, 11, 13, 15, 17, 20, 22, 24, 26, 28, 29, 31, 33, 35];

  var bucket = [];
  segment.forEach(num => {
    var item = red.includes(num)? 'R': black.includes(num)? 'B' : '-';
    bucket.push(item);
  });
  return bucket;
}
function getPatternRB(length, multiplier)
{

  var total = length * multiplier;
  var numberSegment = numbers.slice(-total);

  numberSegment = changeRB(numberSegment);
  const basetr = document.createElement('tr');

  


  var betLocation = tableHeaderPattern();
  betLocation.textContent = '';
  basetr.appendChild(betLocation);

  numberSegment.forEach((num, index) => {
    var th = tableHeaderPattern();
    th.textContent = num;
    th.style.width = '65px';
  
    let segmentLength = numberSegment.length / multiplier;  
  
    if ((index + 1) % segmentLength === 0 && index !== numberSegment.length - 1) {
      th.style.borderRight = '2px solid black'; 
    }
  
    basetr.appendChild(th);
  });

  var th = tableHeaderPattern();
  th.textContent = 'Red / Black';
  basetr.appendChild(th);

  let truth = checkSegments(numberSegment);
  if(truth)
  {
    betLocation.style.backgroundColor = 'rgb(255, 254, 204)';
    
    let betItem = numberSegment[0]=='R'? 'B' : 'R';
    betLocation.innerHTML = betItem;

  }else
  {
    betLocation.innerHTML = ' ';
  }
  

  return basetr;
}

function changeEO(segment)
{

  var bucket = [];
  segment.forEach(num => {
    var item = '-';
    if(num>0)
    {
        item = num % 2 === 0 ? 'E' : 'O';
    }

    bucket.push(item);
  });
  return bucket;
}
function getPatternEO(length, multiplier)
{

  var total = length * multiplier;
  var numberSegment = numbers.slice(-total);

  numberSegment = changeEO(numberSegment);
  const basetr = document.createElement('tr');

  


  var betLocation = tableHeaderPattern();
  betLocation.textContent = '';
  basetr.appendChild(betLocation);

  
  numberSegment.forEach((num, index) => {
    var th = tableHeaderPattern();
    th.textContent = num;
    th.style.width = '65px';
  
    let segmentLength = numberSegment.length / multiplier;  
  
    if ((index + 1) % segmentLength === 0 && index !== numberSegment.length - 1) {
      th.style.borderRight = '2px solid black'; 
    }
  
    basetr.appendChild(th);
  });
  

  var th = tableHeaderPattern();
  th.textContent = 'Even / Odd';
  basetr.appendChild(th);

  let truth = checkSegments(numberSegment);
  if(truth)
  {
    betLocation.style.backgroundColor = 'rgb(255, 254, 204)';
    let betItem = numberSegment[0]=='E'? 'O' : 'E';
    betLocation.innerHTML = betItem;
  }else
  {
    betLocation.innerHTML = ' ';
  }
  

  return basetr;
}

function changeHL(segment)
{

  var bucket = [];
  segment.forEach(num => {
    var item = '-';
    if(num>0)
    {
        item = num <=18  ? 'L' : 'H';
    }

    bucket.push(item);
  });
  return bucket;
}
function getPatternHL(length, multiplier)
{

  var total = length * multiplier;
  var numberSegment = numbers.slice(-total);

  numberSegment = changeHL(numberSegment);
  const basetr = document.createElement('tr');

  


  var betLocation = tableHeaderPattern();
  betLocation.textContent = '';
  basetr.appendChild(betLocation);

  
  numberSegment.forEach((num, index) => {
    var th = tableHeaderPattern();
    th.textContent = num;
    th.style.width = '65px';
  
    let segmentLength = numberSegment.length / multiplier;  
  
    if ((index + 1) % segmentLength === 0 && index !== numberSegment.length - 1) {
      th.style.borderRight = '2px solid black'; 
    }
  
    basetr.appendChild(th);
  });
  

  var th = tableHeaderPattern();
  th.textContent = 'Low / High';
  basetr.appendChild(th);

  let truth = checkSegments(numberSegment);
  if(truth)
  {
    betLocation.style.backgroundColor = 'rgb(255, 254, 204)';
    let betItem = numberSegment[0]=='H'? 'L' : 'H';
    betLocation.innerHTML = betItem;
  }else
  {
    betLocation.innerHTML = ' ';
  }
  

  return basetr;
}

function changeDozen(segment)
{
  var d1 = [1,2,3,4,5,6,7,8,9,10,11,12];
  var d2 = [13,14,15,16,17,18,19,20,21,22,23,24];
  var d3 = [25,26,27,28,29,30,31,32,33,34,35,36];
  var bucket = [];

  segment.forEach(num => {
    var item = '-';
    if(num>0)
    {
        item = d1.includes(num)? 'd1': d2.includes(num)? 'd2' : d3.includes(num)? 'd3' :'-';
    }

    bucket.push(item);
  });
  return bucket;
}
function getPatternDozen(length, multiplier)
{

  var total = length * multiplier;
  var numberSegment = numbers.slice(-total);

  numberSegment = changeDozen(numberSegment);
  const basetr = document.createElement('tr');

  


  var betLocation = tableHeaderPattern();
  betLocation.textContent = '';
  basetr.appendChild(betLocation);

  
  numberSegment.forEach((num, index) => {
    var th = tableHeaderPattern();
    th.textContent = num;
    th.style.width = '65px';
  
    let segmentLength = numberSegment.length / multiplier;  
  
    if ((index + 1) % segmentLength === 0 && index !== numberSegment.length - 1) {
      th.style.borderRight = '2px solid black'; 
    }
  
    basetr.appendChild(th);
  });
  

  var th = tableHeaderPattern();
  th.textContent = 'Dozens';
  basetr.appendChild(th);

  let truth = checkSegments(numberSegment);
  if(truth)
  {
    betLocation.style.backgroundColor = 'rgb(255, 254, 204)';
    let betItem = '';
    if(numberSegment[0]=='d1')
    {
      betItem = 'd2 d3';
    }
    if(numberSegment[0]=='d2')
    {
      betItem = 'd1 d3';
    }
    if(numberSegment[0]=='d3')
    {
      betItem = 'd1 d2';
    }

    betLocation.innerHTML = betItem;
  }else
  {
    betLocation.innerHTML = ' ';
  }
  

  return basetr;
}

function changeRow(segment)
{
  var r1 = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];
  var r2 = [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35];
  var r3 = [3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36];
  var bucket = [];
  segment.forEach(num => {
    var item = '-';
    if(num>0)
    {
        item = r1.includes(num)? 'r1': r2.includes(num)? 'r2' : r3.includes(num)? 'r3' :'-';
    }

    bucket.push(item);
  });
  return bucket;
}
function getPatternRow(length, multiplier)
{

  var total = length * multiplier;
  var numberSegment = numbers.slice(-total);

  numberSegment = changeRow(numberSegment);
  const basetr = document.createElement('tr');

  


  var betLocation = tableHeaderPattern();
  betLocation.textContent = '';
  basetr.appendChild(betLocation);

  
  numberSegment.forEach((num, index) => {
    var th = tableHeaderPattern();
    th.textContent = num;
    th.style.width = '65px';
  
    let segmentLength = numberSegment.length / multiplier;  
  
    if ((index + 1) % segmentLength === 0 && index !== numberSegment.length - 1) {
      th.style.borderRight = '2px solid black'; 
    }
  
    basetr.appendChild(th);
  });
  

  var th = tableHeaderPattern();
  th.textContent = 'Rows';
  basetr.appendChild(th);

  let truth = checkSegments(numberSegment);
  if(truth)
  {
    betLocation.style.backgroundColor = 'rgb(255, 254, 204)';
    let betItem = '';
    if(numberSegment[0]=='r1')
    {
      betItem = 'r2 r3';
    }
    if(numberSegment[0]=='r2')
    {
      betItem = 'r1 r3';
    }
    if(numberSegment[0]=='r3')
    {
      betItem = 'r1 r2';
    }

    betLocation.innerHTML = betItem;
  }else
  {
    betLocation.innerHTML = ' ';
  }
  

  return basetr;
}

function patternUserInput()
{
  
    let container = document.createElement('div');

    var title = 'Pattern Break';
	var msg = 'Bet that a pattern does not repeat.';
	msg +='\n';
	msg +='\nFor example, group length 3 happens 2 times.';
	msg += '\n';
	msg += '\nThe tool then looks for a pattern of 3 such as [Red, Red, Black]';
	msg += '\nThen it looks for it to happen 2 times in a row [Red, Red, Black][Red, Red, Black]';
	msg += '\n';
	msg += '\nSince we do not want the pattern to come up again, the tool will alert to bet Black.';
	msg += '\n';
	var patternTitle = createTitleWithHelp(title,msg);
    container.appendChild(patternTitle);

	var patternLength = document.createElement('input');
	patternLength.type = 'text';
	patternLength.id = "patternLength-pattern";
	patternLength.name = "patternLength-pattern";
	patternLength.placeholder = "";
	patternLength.value =  _patternLength;
	patternLength.classList.add('textbox-container');
	patternLength.classList.add('triggerGroups');
  container.appendChild(patternLength);

	var label_patternLength = document.createElement('label');
	label_patternLength.htmlFor = 'patternLength-pattern';
	label_patternLength.appendChild(document.createTextNode('Pattern Length: '));
  container.appendChild(label_patternLength);

	var patternMultiplier = document.createElement('input');
	patternMultiplier.type = 'text';
	patternMultiplier.id = "patternMultiplier-pattern";
	patternMultiplier.name = "patternMultiplier-pattern";
	patternMultiplier.placeholder = "";
	patternMultiplier.value = _patternMultiplier;
	patternMultiplier.classList.add('textbox-container');
	patternMultiplier.classList.add('triggerGroups');
  container.appendChild(patternMultiplier);

	var label_patternMultiplier = document.createElement('label');
	label_patternMultiplier.htmlFor = 'patternMultiplier-pattern';
	label_patternMultiplier.appendChild(document.createTextNode('Pattern repeats: '));
  container.appendChild(label_patternMultiplier);

	// TRIGGER ADD CONTAINER
	const pattern_trigger_button = document.createElement('button');
	pattern_trigger_button.innerText = "Update";
	pattern_trigger_button.classList.add('triggerOptionsButton');
	pattern_trigger_button.id = "patternTriggerButton-pattern";
	pattern_trigger_button.addEventListener('click', function() {
    
    let l = document.getElementById('patternLength-pattern');
    _patternLength = ensureInputValue(l.value, 3, 0, 30);
    l.value = _patternLength;
    
    let m = document.getElementById('patternMultiplier-pattern');
    _patternMultiplier = ensureInputValue(m.value, 2, 0, 6);
    m.value = _patternMultiplier;



		updatePatternNewNumber();
	});	
    container.appendChild(pattern_trigger_button);

    return container;
}