
function createHoverNumbers() {
    // Create widget container
    const widgetContainer = document.createElement('div');
    widgetContainer.id = 'widget-container';

    let savedColor = localStorage.getItem(widgetContainer.id+'-containerIdbackgroundColor');
    if (savedColor) {
        widgetContainer.style.backgroundColor = savedColor;
    }

    let colorChangerQuickSpin = quickSpin_colorChanger(widgetContainer.id);
    widgetContainer.append(colorChangerQuickSpin);

    
    // Create number list container
    const numberList = document.createElement('div');
    numberList.id = 'number-list';
    widgetContainer.appendChild(numberList);
    
    // Add numbers to list
    const myNumbers = numbers;
    myNumbers.forEach(x => addNumberToList(x, numberList));

    // Add event listener for highlighting numbers
    numberList.addEventListener('mouseover', function(event) {
        const hoveredNumber = event.target.textContent;
        const allNumbers = numberList.querySelectorAll('.number');
        allNumbers.forEach(number => {
            if (number.textContent === hoveredNumber) {
                number.classList.add('highlight');
            } else {
                number.classList.remove('highlight');
            }
        });
    });

    // Add styles directly to elements
    const styles = `
        #widget-container {
            width: 1200px;
            height: 300px;
            overflow-x: auto;
            overflow-y: auto;
            border: 1px solid #ccc;
            padding: 5px;
            position: relative;
        }
        #number-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: flex-start;
            align-content: flex-start;
            width: 100%;
        }
        .number {
            display: inline-block;
            width: 30px;
            height: 30px;
            line-height: 30px;
            text-align: center;
            margin: 5px;
            cursor: pointer;
            border: 2px solid #ccc;
            border-radius: 10%;
        }
        .red { color: red; font-weight: bold;  }
        .black { color: black; font-weight: bold;  }
        .green { color: rgba(71, 255, 26, 0.93); font-weight: bold;  }
        .highlight { background-color: rgba(42, 209, 0, 0.4); }
    `;
    const styleSheet = document.createElement('style');
    styleSheet.type = 'text/css';
    styleSheet.innerText = styles;
    document.head.appendChild(styleSheet);

    return widgetContainer;
}

function addNumberToList(number, numberList) {
    const numberDiv = document.createElement('div');
    numberDiv.classList.add('number');
    if (number === 0) {
        numberDiv.classList.add('green');
    } else if ([32, 19, 21, 25, 34, 27, 36, 30, 23, 5, 16, 1, 14, 9, 18, 7, 12, 3].includes(number)) {
        numberDiv.classList.add('red');
    } else {
        numberDiv.classList.add('black');
    }
    numberDiv.textContent = number;
    numberList.insertBefore(numberDiv, numberList.firstChild);
}

function updateHoverAfterNumberChange() {
    let numberList = document.getElementById('number-list');
    if (numberList) {
        numberList.innerHTML = '';
        numbers.forEach(x => addNumberToList(x, numberList));
    } 
}