// This table displays how many times each bet type has come up over x spins.

function hitRate()
{
	// Example spins, replace with actual spins
const spins = numbers;

// Bet type definitions
const betTypes = [
    "Red", "Black", "Even", "Odd", "High", "Low",
    "Column 1", "Column 2", "Column 3",
    "Dozen 1", "Dozen 2", "Dozen 3"
];



// Function to calculate hit rates for each bet type
function calculateHitRatesForBetTypes(spins, betTypes, rouletteAttributes) {
    let results = betTypes.reduce((acc, type) => ({ ...acc, [type]: { total: 0, last100: 0, last25: 0, last5: 0 } }), {});

    spins.forEach((spin, index) => {
        let attributes = [];

        // Check attributes of each spin
        if (rouletteAttributes.red.includes(spin)) attributes.push("Red");
        else if (rouletteAttributes.black.includes(spin)) attributes.push("Black");

        if (spin !== 0) {
            if (spin % 2 === 0) attributes.push("Even");
            else attributes.push("Odd");

            if (spin <= 18) attributes.push("Low");
            else attributes.push("High");

            rouletteAttributes.columns.forEach((col, i) => {
                if (col.includes(spin)) attributes.push("Column " + (i + 1));
            });

            rouletteAttributes.dozens.forEach((doz, i) => {
                if (doz.includes(spin)) attributes.push("Dozen " + (i + 1));
            });
        }

        // Increment hit rates
        attributes.forEach(attr => {
            results[attr].total += 1;
            if (index >= spins.length - 100) results[attr].last100 += 1;
            if (index >= spins.length - 25) results[attr].last25 += 1;
            if (index >= spins.length - 5) results[attr].last5 += 1;
        });
    });

const totalSpins = spins.length;

// Calculate percentages
Object.keys(results).forEach(type => {
    results[type].total = ((results[type].total / totalSpins) * 100).toFixed(2) + '%';
    results[type].last100 = ((results[type].last100 / Math.min(100, totalSpins)) * 100).toFixed(2) + '%';
    results[type].last25 = ((results[type].last25 / Math.min(25, totalSpins)) * 100).toFixed(2) + '%';
    results[type].last5 = ((results[type].last5 / Math.min(5, totalSpins)) * 100).toFixed(2) + '%';
});

return results;
}

// Function to create and display the table for roulette bet types
function displayHitRatesTableForBetTypes(hitRates) {
    const table = document.createElement('table');
    table.style.borderCollapse = 'collapse';
    table.style.width = '100%';
    const thead = table.createTHead();
    const headerRow = thead.insertRow();
    const headers = ['Bet Type', 'Hit Rate Total', 'Hit Rate Last 100 Spins', 'Hit Rate Last 25 Spins', 'Hit Rate Last 5 Spins'];

    // Set headers
    headers.forEach(header => {
        const th = document.createElement('th');
        th.textContent = header;
        th.style.border = '1px solid black';
        th.style.padding = '5px';
        headerRow.appendChild(th);
    });

    // Fill table rows
    const tbody = table.appendChild(document.createElement('tbody'));
    Object.entries(hitRates).forEach(([type, rates]) => {
        const row = tbody.insertRow();
        row.insertCell().textContent = type;
        Object.values(rates).forEach(rate => {
            const cell = row.insertCell();
            cell.textContent = rate;
            cell.style.border = '1px solid black';
            cell.style.padding = '5px';
        });
    });

    document.body.appendChild(table);
}

// Calculate hit rates for bet types and display the table
const hitRatesForBetTypes = calculateHitRatesForBetTypes(spins, betTypes, rouletteAttributes);
displayHitRatesTableForBetTypes(hitRatesForBetTypes);


}