function buildHistogramChart() {

    let canvasitem = document.createElement('canvas');
    canvasitem.id = 'chart';
    canvasitem.style.width = '40%'; // Set canvas width as 80% of the container
    canvasitem.style.height = '50%'; // Set height (fixed or percentage)

    let data = numbers;

    if (chart) {
        chart.destroy();
    }

    var ctx = canvasitem.getContext('2d');
    chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: Array.from({ length: data.length }, (_, i) => i.toString()), 
            datasets: [{
                label: 'Winning Numbers Distribution',
                data: data,
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true, // Ensures canvas resizes correctly within the container
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });

   // container.appendChild(canvasitem);
    return canvasitem;
}


function updateHistogramChart() {
    let data = numbers;

    let canvas = document.getElementById('chart'); 

    if (!canvas) {
        return;
    }

    // Ensure the canvas size matches the updated chart
    canvas.width = 1200; // Set the width same as in buildHistogramChart
    canvas.height = 500; // Set the height same as in buildHistogramChart

    if (chart) {
        chart.destroy();
    }

    var ctx = canvas.getContext('2d');
    chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: Array.from({ length: data.length }, (_, i) => i.toString()),
            datasets: [{
                label: 'Winning Numbers Distribution',
                data: data,
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true, // Ensure the canvas adjusts correctly
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });
}
