function appendFooter() {

  if (!footerContainer) {
    console.error('❌ footerContainer not found!');
    return;
  }

    const customFooterDiv = document.createElement('div');

    // Separated HTML blocks for easier maintenance
    const musicControlsHTML = `
        <div class="music-player">
            <select id="trackSelector">
                <option value="../triggers_mp3/roulettemusic1.mp3">Track 1</option>
                <option value="../triggers_mp3/roulettemusic2.mp3">Track 2</option>
                <option value="../triggers_mp3/roulettemusic3.mp3">Track 3</option>
                <option value="../triggers_mp3/roulettemusic4.mp3">Track 4</option>
            </select>
            <button id="playPauseButton">Play</button>
            <input type="range" id="volumeControl" min="0" max="1" step="0.1" value="0.5">
            <audio id="bgMusic" preload="auto" loop></audio>
        </div>
    `;

const colorControlsHTML = `
<div id="footer-color-controls" style="display:flex;flex-wrap:wrap;gap:8px;padding:10px 0 0 0px;align-items:center;">
    <button class="color-btn" style="background:#990000;" onclick="changeColor('#990000')">Red</button>
    <button class="color-btn" style="background:#68A2F1;" onclick="changeColor('#68A2F1')">Blue</button>
    <button class="color-btn" style="background:#35654d;" onclick="changeColor('#35654d')">Green</button>
    <button class="color-btn" style="background:#D6BE44;" onclick="changeColor('#D6BE44')">Brown</button>
    <button class="color-btn" style="background:#778899;" onclick="changeColor('#778899')">Grey</button>
    <button class="color-btn" style="background:#252D41;" onclick="changeColor('rgb(37, 45, 65)')">Default</button>
    <input type="color" id="colorPicker" value="#990000" style="position:relative;top:4px;" onchange="changeColor(this.value)">
</div>
`;

    const timerControlsHTML = `
        <div class="controls">
            <label for="minutes">Set Timer (min):</label>
            <input type="number" id="minutes" min="1" value="5">
            <button onclick="startTimer()">Start</button>
            <button onclick="stopTimer()">Stop</button>
        </div>
        <center>
            <div class="timer-container"><br>
                <div class="timer" id="timer" 
                    style="float:left; font-size: 1.5rem; font-weight: bold; padding: 5px 5px; 
                    border-radius: 8px; background: linear-gradient(135deg, #3b82f6, #9333ea); 
                    color: #fff; text-shadow: 0 0 8px rgba(255, 255, 255, 0.6); 
                    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2); font-family: Arial, sans-serif; 
                    transition: all 0.3s ease-in-out;">
                    00:00 Take a break !!
                </div>
            </div>
        </center>
    `;

    // Combine sections
    customFooterDiv.innerHTML = musicControlsHTML + colorControlsHTML + timerControlsHTML;

    // Append all number audio clips
    for (let i = 0; i <= 36; i++) {
        const audio = document.createElement('audio');
        audio.id = i === 0 ? 'play_number_0' : `play_number_${i}`;
        audio.src = `../triggers_mp3/num_${i}.mp3`;
        audio.preload = 'auto';
        customFooterDiv.appendChild(audio);
    }

    // Add spin sound
    const spinSound = document.createElement('audio');
    spinSound.id = 'spinSound';
    spinSound.src = '../triggers_mp3/roulettespin.mp3';
    spinSound.preload = 'auto';
    customFooterDiv.appendChild(spinSound);

    // Append to footer container
   // footerContainer.appendChild(customFooterDiv);




    // Then append your static affiliate/footer content
    const footerHTML = `...`; // unchanged original footer HTML
    footerContainer.innerHTML += footerHTML;

appendAds();
    


    const spacer = document.createElement('div');
spacer.style.height = '200px';
spacer.style.width = '100%';
spacer.style.clear = 'both';
footerContainer.appendChild(spacer);

    setupMusicPlayerEvents();





}

function appendAds() {
const uniqueContainer = document.createElement('div');
uniqueContainer.classList.add('unique-container');





  footerContainer.appendChild(uniqueContainer);


  // Append your static affiliate/footer content
const affiliateHTML = `
<center><br><br><br>
  <a href="https://record.revmasters.com/_Y9MBsRcgHuDWm346AIeRA2Nd7ZgqdRLk/1/">
    <img src="https://i.imgur.com/KkFlYUO.gif">
  </a>
  <br><br>
  <a title="bitcoin casino" target="_blank" href="https://cloudbet.com/en/bitcoin-casino?af_token=ea3e7ea267961f1fdfcd25637712cfee">
    <img alt="casinos" src="https://i.imgur.com/ysW7Zt0.png">
  </a>
  <br>
  <a target="_blank" href="https://www.begambleaware.org/">
    <img src="../tv10/items/gambleaware.png" title="begambleaware.org">
  </a>
  <br>
  <a target="_blank" href="https://promos.paddypower.com/choose-your-friends-with-benefits-offer?referrerCode=ACFTU3H9D">
    <img title="paddy power casino and sports betting" src="https://i.imgur.com/gPIW1aw.png">
  </a>
  <br>
  <a href="https://tinyurl.com/WilliamHill-Vegas-casino">
    <img src="https://i.imgur.com/hFQS4sA.jpg" width="70%">
  </a>
  <br><br>
</center>
`;
footerContainer.innerHTML += affiliateHTML;

}

let onlineTabLoaded = false;

function showUniqueTab(index) {
  const tabs = document.querySelectorAll('.unique-tab');
  const contents = document.querySelectorAll('.unique-tab-content');

  tabs.forEach((tab, i) => {
    tab.classList.remove('active');
    contents[i]?.classList.remove('active');
  });

  tabs[index].classList.add('active');
  contents[index]?.classList.add('active');
/*
  // Only run scripts once when clicking the "Online now" tab
  if (index === 8 && !onlineTabLoaded) {
    onlineTabLoaded = true;
    const container = document.getElementById('unique-content-8');

    const counterScript1 = document.createElement('script');
    counterScript1.src = 'https://www.freevisitorcounters.com/auth.php?id=acb4e58d088bcaaa492a608231e7526feba9178f';
    counterScript1.type = 'text/javascript';

    const counterScript2 = document.createElement('script');
    counterScript2.src = 'https://www.freevisitorcounters.com/en/home/counter/1351480/t/0';
    counterScript2.type = 'text/javascript';

    container.appendChild(counterScript1);
    container.appendChild(counterScript2);
  }
    */
}

  // Set up event listeners for video controls
  document.addEventListener('DOMContentLoaded', function() {
    var video = document.getElementById('myVideo');
    
    if (video) {
      video.addEventListener('ended', function() {
        window.open('https://www.weedchats.net', '_blank');
      });

      video.addEventListener('pause', function() {
        window.open('https://www.weedchats.net', '_blank');
      });
    }
  });

function changeColor(color) {
    const container = document.getElementById('container');
    const colorPicker = document.getElementById('colorPicker');

    if (container) {
        container.style.backgroundColor = color;
        localStorage.setItem('userColor', color);
    }

    if (colorPicker) {
        colorPicker.value = toHex(color); // Sync the picker with the button
    }
}

// Helper to convert color names/rgb to hex for picker
function toHex(color) {
    const ctx = document.createElement("canvas").getContext("2d");
    ctx.fillStyle = color;
    return ctx.fillStyle;
}
let timerInterval;
let timeRemaining = 0;

function startTimer() {
    const minutesInput = document.getElementById('minutes').value;
    timeRemaining = parseInt(minutesInput) * 60;
    updateTimerDisplay(timeRemaining);
    clearInterval(timerInterval);
    timerInterval = setInterval(() => {
        timeRemaining--;
        if (timeRemaining <= 0) {
            clearInterval(timerInterval);
            timeRemaining = 0;
            flashScreen();
        }
        updateTimerDisplay(timeRemaining);
    }, 1000);
}

function stopTimer() {
    clearInterval(timerInterval);
    timeRemaining = 0;
    updateTimerDisplay(timeRemaining);
    document.body.classList.remove('flashing');
}

function updateTimerDisplay(seconds) {
    const minutes = Math.floor(seconds / 60);
    const secs = seconds % 60;
    document.getElementById('timer').textContent = `${String(minutes).padStart(2, '0')}:${String(secs).padStart(2, '0')} Take a break !!`;
}

function flashScreen() {
    document.body.classList.add('flashing');
}

function setupMusicPlayerEvents() {
  const audio = document.getElementById('bgMusic');
  const playPause = document.getElementById('playPauseButton');
  const selector = document.getElementById('trackSelector');
  const volume = document.getElementById('volumeControl');

  if (!audio || !playPause || !selector || !volume) return;

  playPause.onclick = () => {
    if (audio.paused) {
      audio.src = selector.value;
      audio.play();
      playPause.textContent = 'Pause';
    } else {
      audio.pause();
      playPause.textContent = 'Play';
    }
  };

  volume.oninput = () => {
    audio.volume = volume.value;
  };

  selector.onchange = () => {
    audio.src = selector.value;
    if (!audio.paused) audio.play();
  };

  // 👇 Optional but helpful defaults
  audio.src = selector.value;
  audio.volume = 0.5;
}

// Create a container for the color controls
const colorControls = document.createElement('div');
colorControls.id = 'footer-color-controls';
colorControls.style.display = 'flex';
colorControls.style.flexWrap = 'wrap';
colorControls.style.gap = '8px';
colorControls.style.padding = '10px 0 0 100px'; // matches indentation style
colorControls.style.alignItems = 'center';

// Create color buttons
const colors = [
  { name: 'Red', value: '#990000' },
  { name: 'Blue', value: '#68A2F1' },
  { name: 'Green', value: '#35654d' },
  { name: 'Brown', value: '#D6BE44' },
  { name: 'Grey', value: '#778899' },
  { name: 'Default', value: 'rgb(37, 45, 65)' }
];

colors.forEach(color => {
  const btn = document.createElement('button');
  btn.textContent = color.name;
  btn.className = 'color-btn';
  btn.style.marginRight = '5px';
  btn.onclick = () => changeColor(color.value);
  colorControls.appendChild(btn);
});

// Add color picker
const colorPicker = document.createElement('input');
colorPicker.type = 'color';
colorPicker.value = '#990000';
colorPicker.style.position = 'relative';
colorPicker.style.top = '4px';
colorPicker.onchange = function () {
  changeColor(this.value);
};
colorControls.appendChild(colorPicker);




function colorChanger()
{
  
    const customFooterDiv = document.createElement('div');
    customFooterDiv.style.height = 'auto';

    // Separated HTML blocks for easier maintenance
    const musicControlsHTML = `
        <div class="music-player">
            <select id="trackSelector">
                <option value="../triggers_mp3/roulettemusic1.mp3">Track 1</option>
                <option value="../triggers_mp3/roulettemusic2.mp3">Track 2</option>
                <option value="../triggers_mp3/roulettemusic3.mp3">Track 3</option>
                <option value="../triggers_mp3/roulettemusic4.mp3">Track 4</option>
            </select>
            <button id="playPauseButton">Play</button>
            <input type="range" id="volumeControl" min="0" max="1" step="0.1" value="0.5">
            <audio id="bgMusic" preload="auto" loop></audio>
        </div>
    `;

const colorControlsHTML = `
<div id="footer-color-controls" style="display:flex;flex-wrap:wrap;gap:8px;padding:10px 0 0 0px;align-items:center;">
    <button class="color-btn" style="background:#990000;" onclick="changeColor('#990000')">Red</button>
    <button class="color-btn" style="background:#68A2F1;" onclick="changeColor('#68A2F1')">Blue</button>
    <button class="color-btn" style="background:#35654d;" onclick="changeColor('#35654d')">Green</button>
    <button class="color-btn" style="background:#D6BE44;" onclick="changeColor('#D6BE44')">Brown</button>
    <button class="color-btn" style="background:#778899;" onclick="changeColor('#778899')">Grey</button>
    <button class="color-btn" style="background:#252D41;" onclick="changeColor('rgb(37, 45, 65)')">Default</button>
    <input type="color" id="colorPicker" value="#990000" style="position:relative;top:4px;" onchange="changeColor(this.value)">
</div>
`;

const timerControlsHTML = `
    <div class="controls">
        <label for="minutes">Set Timer (min):</label>
        <input type="number" id="minutes" min="1" value="5">
        <button onclick="startTimer()">Start</button>
        <button onclick="stopTimer()">Stop</button>
    </div>
    <div class="timer-container" style="display:flex; justify-content:center; margin-top:10px;">
        <div class="timer" id="timer" 
            style="font-size: 1.5rem; font-weight: bold; padding: 5px 10px; 
            border-radius: 8px; background: linear-gradient(135deg, #3b82f6, #9333ea); 
            color: #fff; text-shadow: 0 0 8px rgba(255, 255, 255, 0.6); 
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2); font-family: Arial, sans-serif; 
            transition: all 0.3s ease-in-out; text-align:center;">
            00:00 Take a break !!
        </div>
    </div>
`;

    // Combine sections
    customFooterDiv.innerHTML = musicControlsHTML + colorControlsHTML + timerControlsHTML;

    // Append all number audio clips
    for (let i = 0; i <= 36; i++) {
        const audio = document.createElement('audio');
        audio.id = i === 0 ? 'play_number_0' : `play_number_${i}`;
        audio.src = `../triggers_mp3/num_${i}.mp3`;
        audio.preload = 'auto';
        customFooterDiv.appendChild(audio);
    }

    // Add spin sound
    const spinSound = document.createElement('audio');
    spinSound.id = 'spinSound';
    spinSound.src = '../triggers_mp3/roulettespin.mp3';
    spinSound.preload = 'auto';
    customFooterDiv.appendChild(spinSound);
    return customFooterDiv;
}