function coldBuild() {

    let container = document.createElement('div');
    container.style.marginLeft = '25px';
    container.style.marginBottom = '15px';
    container.id = 'cold-tool';
    
    let savedColor = localStorage.getItem(container.id+'-containerIdbackgroundColor');
    if (savedColor) {
        container.style.backgroundColor = savedColor;
    }

    let colorChangerQuickSpin = quickSpin_colorChanger(container.id);
    container.append(colorChangerQuickSpin);

    
    let containerUserInput = document.createElement('div');
    containerUserInput.id = 'container-cold-user-input';
    let containerContents = document.createElement('div');
    containerContents.id = 'container-cold-contents';

    let titleDiv = document.createElement('div');
    let titleSpan = document.createElement('span'); 
    titleSpan.innerHTML = '<h2>Cold Numbers: spins since last up</h2>';
    titleDiv.appendChild(titleSpan);
    titleDiv.style.marginBottom = '-20px'; 
    container.appendChild(titleDiv);

    // User Input
    let userInput = two_box_input_and_button('cold-inputbox', '37', 'cold-button', 'cold-button-all','Lookback', 'All','cold-span','0px');
    let userInputContainer = userInput.container;
    var b1 = userInput.buttons.button1;
    var b2 = userInput.buttons.button2;

    if (b1) { b1.onclick = coldUpdate; }
    if (b2) { b2.onclick = coldUpdateAll; }

    containerUserInput.appendChild(userInputContainer);


	let last37 = numbers.slice(-37);

	const frequencyCount = last37.reduce((acc, num, index) => {
		acc[num] = last37.length - 1 - index;
		return acc;
	}, Array.from({length: 37}, () => last37.length));


	let allNumbers = Array.from({length: 37}, (_, index) => index);


	allNumbers.sort((b, a) => {
		const lastA = frequencyCount[a];
		const lastB = frequencyCount[b];

		return lastB - lastA || a - b;
	});


    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
    const frequencyRow = document.createElement('div');

    
    numberRow.style.display = frequencyRow.style.display ='flex';


    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
        const frequencyCell = document.createElement('div');

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;


        // Base styles for cells
        [numberCell, frequencyCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
        frequencyCell.style.color = 'black';

        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; 
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; 
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; 
        }
	
        numberRow.appendChild(numberCell);
        frequencyRow.appendChild(frequencyCell);
    });



	table.appendChild(frequencyRow);
    table.appendChild(numberRow);

    containerContents.appendChild(table);

    container.appendChild(containerUserInput);
    container.appendChild(containerContents);

	return container;
}

function coldUpdateAll(){
    
    let spinLength = document.getElementById('cold-inputbox');
    spinLength.value = numbers.length;
    
    coldUpdate();
}
function coldUpdate(){
   
    let spinLength = document.getElementById('cold-inputbox').value;
    
    spinLength = ensureInputValue(spinLength,37);
    if(spinLength>numbers.length) {spinLength = numbers.length; }
    updateColdTable(spinLength);
}

function updateColdTable(lookBackSpins)
{
    var newSpins = numbers.slice(-lookBackSpins);
    
    var container = document.getElementById('container-cold-contents');
    container.innerHTML = '';


	const frequencyCount = newSpins.reduce((acc, num, index) => {
		acc[num] = newSpins.length - 1 - index;
		return acc;
	}, Array.from({length: 37}, () => newSpins.length));


	let allNumbers = Array.from({length: 37}, (_, index) => index);


	allNumbers.sort((b, a) => {
		const lastA = frequencyCount[a];
		const lastB = frequencyCount[b];

		return lastB - lastA || a - b;
	});


    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
    const frequencyRow = document.createElement('div');

    
    numberRow.style.display = frequencyRow.style.display ='flex';


    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
        const frequencyCell = document.createElement('div');

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;


        // Base styles for cells
        [numberCell, frequencyCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
        frequencyCell.style.color = 'black';

        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; 
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; 
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; 
        }
	
        numberRow.appendChild(numberCell);
        frequencyRow.appendChild(frequencyCell);
    });



	table.appendChild(frequencyRow);
    table.appendChild(numberRow);

    container.appendChild(table);





}

function updateColdNewNumber()
{

    var container = document.getElementById('container-cold-contents');
    if(container)
    {
        coldUpdate();
    }
}


function frequencyBuildbackup() {
    let last37 = numbers.slice(-37);


	// Counting the frequency of each number in last37
	const frequencyCountAll = numbers.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Counting the frequency of each number in last37
	const frequencyCount = last37.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Array of numbers from 0 to 35
	let allNumbers = Array.from({length: 37}, (_, index) => index);

	// Sort these numbers by their frequency in last37, then by number if frequencies are equal
	allNumbers.sort((a, b) => {
		const freqA = frequencyCount[a] || 0;
		const freqB = frequencyCount[b] || 0;
		return freqB - freqA || a - b;
	});


    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
	const frequencyAllRow = document.createElement('div');
    const frequencyRow = document.createElement('div');
    const lastSeenRow = document.createElement('div'); 
	const lastUpRow = document.createElement('div');
    
    frequencyAllRow.style.display = numberRow.style.display = frequencyRow.style.display = lastSeenRow.style.display =  lastUpRow.style.display ='flex';



	const helpCellfreqAll = document.createElement('div');
	helpCellfreqAll.style.display = 'flex';
	helpCellfreqAll.style.justifyContent = 'center';
	helpCellfreqAll.style.alignItems = 'center';
	helpCellfreqAll.style.border = '1px solid black';
	helpCellfreqAll.style.width = '32px';
	helpCellfreqAll.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up.';
	var helpIcon = createHelpBox(msg);
	helpCellfreqAll.appendChild(helpIcon);
	frequencyAllRow.appendChild(helpCellfreqAll);


	const helpCellfreq = document.createElement('div');
	helpCellfreq.style.display = 'flex';
	helpCellfreq.style.justifyContent = 'center';
	helpCellfreq.style.alignItems = 'center';
	helpCellfreq.style.border = '1px solid black';
	helpCellfreq.style.width = '32px';
	helpCellfreq.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up over the last 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCellfreq.appendChild(helpIcon);
	frequencyRow.appendChild(helpCellfreq);

	const helpCelllaw = document.createElement('div');
	helpCelllaw.style.display = 'flex';
	helpCelllaw.style.justifyContent = 'center';
	helpCelllaw.style.alignItems = 'center';
	helpCelllaw.style.border = '1px solid black';
	helpCelllaw.style.width = '32px';
	helpCelllaw.style.height = '25px';
	var msg = 'The Law of the Third says that in 37 spins,';
	msg += '\nabout 24 numbers will come up.';
	msg += '\n\n';
	msg += "This leaves about 1/3 of the number not coming up,";
	msg += '\n';
	msg += "and several repeat numbers.";
	msg += '\n';
	msg += '\n';
	msg += 'This chart shows the frequency of numbers over the last 37 spins.';
	msg += '\n';
	msg += '\n';
	msg += 'We leave it to the player to figure out how take advantage of it.';
	var patternTitle = createHelpBox(msg);
	helpCelllaw.appendChild(patternTitle);
	numberRow.appendChild(helpCelllaw);


	const helpCell = document.createElement('div');
	helpCell.style.display = 'flex';
	helpCell.style.justifyContent = 'center';
	helpCell.style.alignItems = 'center';
	helpCell.style.border = '1px solid black';
	helpCell.style.width = '32px';
	helpCell.style.height = '25px';
	var msg = 'Shows the last time the number appeared in 37 spins.\nA blank means the number has appeared in over 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCell.appendChild(helpIcon);
	lastSeenRow.appendChild(helpCell);
	

	const helpLastUp = document.createElement('div');
	helpLastUp.style.display = 'flex';
	helpLastUp.style.justifyContent = 'center';
	helpLastUp.style.alignItems = 'center';
	helpLastUp.style.border = '1px solid black';
	helpLastUp.style.width = '32px';
	helpLastUp.style.height = '25px';
	var msg = 'Shows the last time the number appeared.\nA blank means the number has never come up.';
	var helpIcon = createHelpBox(msg);
	helpLastUp.appendChild(helpIcon);
	lastUpRow.appendChild(helpLastUp);


    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
		const frequencyAllCell = document.createElement('div');
        const frequencyCell = document.createElement('div');
        const lastSeenCell = document.createElement('div'); 
		const lastUpAllCell = document.createElement('div'); 

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;
		frequencyAllCell.innerText = frequencyCountAll[num] || 0;
		

        // Calculate spins since last appearance
        const lastIndexOfNum = last37.lastIndexOf(num);
        lastSeenCell.innerText = lastIndexOfNum !== -1 ? (last37.length - 1) - lastIndexOfNum : '';

		// Calculate Last up all
		const lastUpAllIndex = numbers.lastIndexOf(num);
		lastUpAllCell.innerText = lastUpAllIndex !== -1 ? (numbers.length - 1) - lastUpAllIndex : '';

        // Base styles for cells
        [numberCell, frequencyAllCell, frequencyCell, lastSeenCell, lastUpAllCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
		frequencyAllCell.style.color = 'black';
        frequencyCell.style.color = 'blue';
        lastSeenCell.style.color = 'blue'; // Color for spins since last appearance
		lastUpAllCell.style.color = 'black';

        // Apply background color based on the number
        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; // Red
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; // Black
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; // Assuming 0 has a unique color
        }
	
        // Append cells to their respective rows
        numberRow.appendChild(numberCell);
		frequencyAllRow.appendChild(frequencyAllCell);
        frequencyRow.appendChild(frequencyCell);
        lastSeenRow.appendChild(lastSeenCell);
		lastUpRow.appendChild(lastUpAllCell);
    });






    // Append rows to the table container
	table.appendChild(frequencyAllRow);
    table.appendChild(frequencyRow);
    table.appendChild(numberRow);
    table.appendChild(lastSeenRow); 
	table.appendChild(lastUpRow);

	return table;
}
