function panelHighScoreContent() {
    let container = document.createElement('div');
    container.id = 'highScoreBox';
    container.style.padding = '20px';
    container.style.border = '1px solid #ccc';
    container.style.margin = '10px';
    container.style.borderRadius = '5px';
    container.style.backgroundColor = '#f9f9f9';
    
    // Create the addScoreForm with styles
    const addScoreForm = document.createElement('form');
    addScoreForm.id = 'addScoreForm';
    addScoreForm.style.marginBottom = '20px';

    // Styling function for inputs
    const styleInput = (input) => {
        input.style.padding = '10px';
        input.style.margin = '5px';
        input.style.borderRadius = '5px';
        input.style.border = '1px solid #ddd';
    };

    const nameInput = document.createElement('input');
    nameInput.type = 'text';
    nameInput.id = 'name';
    nameInput.name = 'name';
    nameInput.placeholder = 'Name';
    nameInput.required = true;
    nameInput.setAttribute('autocomplete', 'off');
    styleInput(nameInput); // Apply styles
    
    const scoreInput = document.createElement('input');
    scoreInput.type = 'number';
    scoreInput.id = 'score';
    scoreInput.name = 'score';
    scoreInput.placeholder = 'Score';
    scoreInput.required = true;
    styleInput(scoreInput); // Apply styles
    
    const addButton = document.createElement('button');
    addButton.type = 'submit';
    addButton.id = 'addItem';
    addButton.textContent = 'Add Score';
    addButton.style.padding = '10px 20px';
    addButton.style.border = 'none';
    addButton.style.borderRadius = '5px';
    addButton.style.backgroundColor = '#007bff';
    addButton.style.color = 'white';
    addButton.style.cursor = 'pointer';
    
    // Append children to addScoreForm
    addScoreForm.appendChild(nameInput);
    addScoreForm.appendChild(scoreInput);
    addScoreForm.appendChild(addButton);
    
    container.appendChild(addScoreForm);
    
    let span1 = document.createElement('span');
    span1.innerHTML = high_score_message;
    span1.style.display = 'block'; 
    span1.style.textAlign = 'center';
    span1.style.color = 'blue';
    span1.style.fontSize = '24px';
    container.appendChild(span1);

    // Create scoresContainer with some styles
    const scoresContainer = document.createElement('div');
    scoresContainer.id = 'scoresContainer';
    scoresContainer.style.marginTop = '20px';

    container.appendChild(document.createElement('br'));
    container.appendChild(document.createElement('br'));
    container.appendChild(scoresContainer);

    addScoreForm.addEventListener("submit", addRecord);

    return container;
}

function getRecords() {
    fetch('fetch_scores.php')
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response xx was not ok');
        }
        return response.json();
    })
    .then(response => {
        const container = document.getElementById("scoresContainer");
        container.innerHTML = ""; // Clear previous contents

        if (!response.success) {
            container.textContent = `Error: ${response.error}`;
            return;
        }

        if (response.data.length === 0) {
            container.textContent = "No high scores found.";
        } else {
            // Create table structure with styles
            const table = document.createElement("table");
            table.style.width = '100%';
            table.style.borderCollapse = 'collapse';
            table.style.border = '1px solid #ddd';
            table.style.marginTop = '20px';

            const thead = document.createElement("thead");
            thead.style.backgroundColor = '#f2f2f2';

            const tbody = document.createElement("tbody");
            
            const headers = ['ID', 'Player', 'Score'];
            const trHead = document.createElement("tr");
            headers.forEach(header => {
                const th = document.createElement("th");
                th.textContent = header;
                th.style.padding = '12px';
                th.style.textAlign = 'left';
                trHead.appendChild(th);
            });
            thead.appendChild(trHead);

            response.data.forEach(score => {
                const tr = document.createElement("tr");
                Object.values(score).forEach(text => {
                    const td = document.createElement("td");
                    td.textContent = text;
                    td.style.padding = '8px';
                    tr.appendChild(td);
                });
                tbody.appendChild(tr);
            });

            table.appendChild(thead);
            table.appendChild(tbody);
            container.appendChild(table);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById("scoresContainer").innerHTML = "<p>Error loading scores.</p>";
    });
}




function addRecord(e) {
    e.preventDefault(); // Correctly preventing form submission

    const data = {
        name: document.getElementById("name").value,
        score: document.getElementById("score").value
    };

    fetch('add_score.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    })
    .then(response => response.json())
    .then(data => {
        
        getRecords(); // Refresh the scores list
    })
    .catch((error) => {
        console.error('Error:', error);
    });
};
