
function hits_in_a_row(spins, conditionFunction) {
    let count = 0; 
    let inspected = 0; 

    for (let i = numbers.length - 1; i >= 0 && inspected < spins; i--, inspected++) {
        if (conditionFunction(numbers[i])) {
            count++; 
        } else {
            break; 
        }
    }
    return count; 
}

function misses_in_a_row(spins, conditionFunction) {
    let count = 0; 
    let inspected = 0; 

    for (let i = numbers.length - 1; i >= 0 && inspected < spins; i--, inspected++) {
        if (!conditionFunction(numbers[i])) {
            count++; 
        } else {
            break; 
        }
    }
    return count; 
}

function percent_hits(spins, conditionFunction) {
    let count = 0; 
    let inspected = 0;

    for (let i = numbers.length - 1; i >= 0 && inspected < spins; i--, inspected++) {
        if (conditionFunction(numbers[i])) {
            count++; 
        } 
    }

    if (inspected === 0) return 0;

    return (count / inspected) * 100;
}

function total_hit(spins, conditionFunction) {
    let count = 0; 
    let inspected = 0;

    for (let i = numbers.length - 1; i >= 0 && inspected < spins; i--, inspected++) {
        if (conditionFunction(numbers[i])) {
            count++; 
        } 
    }

    if (inspected === 0) return 0;

    return count;
}




function executeAndCollectResults(overSpins, conditions, functions, labels) {
    const results = {};

    conditions.forEach((condition, index) => {

        const label = labels[index];
        const conditionResults = [];

        functions.forEach(func => {
            const resultValue = func(overSpins, condition);
            conditionResults.push(resultValue);
        });

        results[label] = conditionResults;
    });

    return results;
}
//------------------------------------------------------
// Condition Functions
//------------------------------------------------------

function condition_even(number) {
    return number % 2 === 0 && number !== 0;
}

function condition_odd(number){
    return number % 2 === 1 && number !== 0;
}

function condition_red(number){
    var set = numRed;
    return set.includes(number);
}

function condition_black(number){
    var set = numBlack;
    return set.includes(number);
}

function condition_high(number){
    var set  = [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36];
    return set.includes(number);
}

function condition_low(number){
    var set  = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18];
    return set.includes(number);
}

function condition_dozen1(number){
    var set  = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
    return set.includes(number);
}

function condition_dozen2(number){
    var set  = [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24];
    return set.includes(number);
}

function condition_dozen3(number){
    var set  = [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36];
    return set.includes(number);
}

function condition_row1(number){
    var set  = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];
    return set.includes(number);
}

function condition_row2(number){
    var set  = [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35];
    return set.includes(number);
}

function condition_row3(number){
    var set  = [3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36];
    return set.includes(number);
}


function condition_red_odd_high(number){
    var set  = condition_red(number) && condition_odd(number)  && condition_high(number);
    return set;
 };
function condition_red_odd_low(number){
    var set  = condition_red(number) && condition_odd(number)  && condition_low(number);
    return set;
 };
function condition_red_even_high(number){
    var set  = condition_red(number) && condition_even(number)  && condition_high(number);
    return set;
 };
function condition_red_even_low(number){
    var set  = condition_red(number) && condition_even(number)  && condition_low(number);
    return set;
 };
function condition_black_odd_high(number){ 
    var set  = condition_black(number) && condition_odd(number)  && condition_high(number);
    return set;
};
function condition_black_odd_low(number){ 
    var set  = condition_black(number) && condition_odd(number)  && condition_low(number);
    return set;
};
function condition_black_even_high(number){
    var set  = condition_black(number) && condition_even(number)  && condition_high(number);
    return set;
 };
function condition_black_even_low(number){ 
    var set  = condition_black(number) && condition_even(number)  && condition_low(number);
    return set;
};
