<?php
header('Content-Type: text/plain');

$url = 'https://api.casinoscores.com/svc-evolution-game-events/api/lightningroulette?limit=1'; // fetch 1 latest spin
$response = file_get_contents($url);
$data = json_decode($response, true);

if ($data && isset($data[0]['data']['result']['outcome']['number'])) {
    $number = $data[0]['data']['result']['outcome']['number'];
    $settledAt = $data[0]['data']['settledAt'] ?? gmdate("Y-m-d\TH:i:s\Z"); // fallback to now if missing

    // Output wrapped as expected by JS
    echo json_encode([
        [
            "data" => [
                "settledAt" => $settledAt,
                "result" => [
                    "outcome" => [
                        "number" => $number
                    ]
                ]
            ]
        ]
    ]);
    exit;
}

// Return empty array if data not available
echo json_encode([]);