function welcomeScreen() { 
    var container = document.createElement('div');

    var headerTitle = "How to Play";

    var textContent = `
        <p>Welcome to our Roulette Alert Tool! Ready to enhance your roulette experience? Follow these simple steps to get started:</p>
        <ol>
            <li><strong>Start with Triggers:</strong> Find the 'Add Trigger' button located on the left side of your screen. Click on it to add a trigger to the triggers list.</li>
            <br/>
            <li><strong>Play & Stay Alert:</strong> Now, dive into your roulette game as usual. Our tool will keep a vigilant eye on the wheel and the outcomes for you. <strong>Get Alerts:</strong> When one of your specified triggers occurs, you'll receive an immediate alert. This means you won't miss any opportunity you're tracking!</li>
            <br/><li><strong>Enjoy & Experiment:</strong> Feel free to adjust your triggers at any time based on your observations and strategy. The more you play, the better you'll get at identifying the most promising triggers for your gameplay.</li>
        </ol>
        <p>Have fun and may luck be on your side! Remember, our Roulette Alert Tool is here to make your gaming experience more enjoyable and informed. Whether you're a seasoned player or new to the roulette wheel, we're excited to be part of your journey.</p>
        <br/><p>This tool is a work in progress. </p>
        <br/><p>Please send comments or suggestions to <a href="mailto:tollens@gmail.com">tollens@gmail.com</a></p>
        <br><p><a target="_blank" title="Play baccarat live with others" href="../casino/multiplay-baccarat"><img width=500px src="../tv10/items/bacimg.gif"></a></p>
    `;

    // Main header
    var headerElement = document.createElement('h3');
    headerElement.innerText = headerTitle;
    headerElement.classList.add('rwd-table-title');

    // Watch Tutorials link
    var tutorialHeader = document.createElement('h4');
    var tutorialLink = document.createElement('a');
    tutorialLink.href = "https://gamble-galaxy.com/shop/HowTo.html";
    tutorialLink.innerText = "Watch Tutorials";
    tutorialLink.target = "_blank";
    tutorialHeader.appendChild(tutorialLink);
    tutorialHeader.style.textAlign = 'center';

    // **Banner Button at the top linking to group**
    var bannerDiv = document.createElement('div');
    var bannerLink = document.createElement('a');
    bannerLink.href = "https://gamble-galaxy.com/group.php?id=22";
    bannerLink.innerText = "Download this tool ! Click for more info.";
    bannerLink.target = "_blank";
    bannerLink.style.display = "block";
    bannerLink.style.textAlign = "center";
    bannerLink.style.backgroundColor = "#ff9900";
    bannerLink.style.color = "#fff";
    bannerLink.style.fontWeight = "bold";
    bannerLink.style.padding = "15px";
    bannerLink.style.borderRadius = "8px";
    bannerLink.style.marginBottom = "20px";
    bannerLink.style.textDecoration = "none";
    bannerLink.style.fontSize = "18px";
    bannerLink.style.transition = "background-color 0.2s";
    bannerLink.onmouseover = function() { this.style.backgroundColor = "#e68a00"; }
    bannerLink.onmouseout = function() { this.style.backgroundColor = "#ff9900"; }

    bannerDiv.appendChild(bannerLink);

    // Text content div
    var textElement = document.createElement('div');
    textElement.classList.add('rwd-table-text');
    textElement.innerHTML = textContent;

    // Append everything
    container.appendChild(bannerDiv);      // Banner goes on top
    container.appendChild(headerElement);  // How to Play header
    container.appendChild(tutorialHeader); // Watch Tutorials link
    container.appendChild(textElement);    // Main content

    return container;
}
