function videoPopup(){

	var showDivButton = document.createElement('button');
	showDivButton.textContent = 'Video';
    showDivButton.style.padding = '8px 10px';
    showDivButton.style.fontSize = '14px';
    showDivButton.style.margin = '5px';
	dragButtonContainer.appendChild(showDivButton);

	// Create draggable div
	var draggableDiv = document.createElement('div');
	draggableDiv.style.display = 'none';
	draggableDiv.style.width = '500px';
	draggableDiv.style.height = '750px';
	draggableDiv.style.background = 'lightblue';
	draggableDiv.style.position = 'absolute';
	draggableDiv.style.padding = '10px';
	draggableDiv.style.boxSizing = 'border-box';
	draggableDiv.style.border = '1px solid #ddd';
	draggableDiv.style.borderRadius = '5px';
	draggableDiv.style.cursor = 'move';
	draggableDiv.style.zIndex = '1000'; 



	const footerHTML = `
	<div class="drag-overlay">
	<iframe src="https://stoner.whereby.com/stonersa1c5fed9-9709-46ae-9cee-a314be9a267e" allow="camera; microphone; fullscreen; display-capture;" style="height: 700px; width: 100%; border:none; position: absolute; top: 0; left: 0;z-index: 999;"></iframe>
	</div>`;

	let videoContainer = document.createElement('div');
	videoContainer.style.position = 'relative'; // Changed to relative
	videoContainer.style.marginLeft = '10px';
	videoContainer.style.marginTop = '10px';
	videoContainer.style.height = '500px'; // Set height to match the iframe
	videoContainer.style.width = '300px;'; // Set width
	videoContainer.style.zIndex = '9999999';
	videoContainer.innerHTML = footerHTML;
	draggableDiv.appendChild(videoContainer);

	document.body.appendChild(draggableDiv);


	// Create close button
	var closeButton = document.createElement('div');
	closeButton.textContent = 'X';
	closeButton.style.cursor = 'pointer';
	closeButton.style.position = 'absolute';
	closeButton.style.top = '5px';
	closeButton.style.right = '5px';
	closeButton.style.fontWeight = 'bold';
	draggableDiv.appendChild(closeButton);

	// Show the div
	showDivButton.addEventListener('click', function() {
		draggableDiv.style.display = 'block';
		// Position the div at a specific location when shown
		draggableDiv.style.top = '100px';
		draggableDiv.style.left = '150px';
	});

	// Close the div
	closeButton.addEventListener('click', function() {
		draggableDiv.style.display = 'none';
	});

	// Draggable functionality
	let isDragging = false;

	draggableDiv.addEventListener('mousedown', function(e) {
		isDragging = true;
		var rect = draggableDiv.getBoundingClientRect();
		var offsetX = e.clientX - rect.left;
		var offsetY = e.clientY - rect.top;

		function mouseMoveHandler(e) {
			if (isDragging) {
				// Calculate the new position including the scroll offsets
				var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
				var scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
		
				draggableDiv.style.top = (e.clientY - offsetY + scrollTop) + 'px';
				draggableDiv.style.left = (e.clientX - offsetX + scrollLeft) + 'px';
			}
		}

		function mouseUpHandler() {
			isDragging = false;
			window.removeEventListener('mousemove', mouseMoveHandler);
			window.removeEventListener('mouseup', mouseUpHandler);
		}

		window.addEventListener('mousemove', mouseMoveHandler);
		window.addEventListener('mouseup', mouseUpHandler);
	});
}