function simulation_options() {
    let container = document.createElement('div');
    container.id = 'container-simulations';
    container.style.marginLeft = '25px';
    container.style.marginBottom = '15px';

    let title = document.createElement('h2');
    title.innerText = 'Player Simulations';
    title.style.marginBottom = '10px';
    title.style.color = '#333';
    container.appendChild(title);

    let description = document.createElement('p');
    description.innerText = 'Have a roulette idea that you want to test out? Send us an email and we will add it tollens@gmail.com';
    description.style.marginBottom = '20px';
    description.style.fontSize = '1.5em';
    container.appendChild(description);

    let grid = document.createElement('div');
    grid.style.display = 'grid';
    grid.style.gridTemplateColumns = '150px 1fr 7fr'; // Button, Title, Description
    grid.style.gap = '15px';
    grid.style.alignItems = 'center';
    grid.style.border = '1px solid #ccc';
    grid.style.borderRadius = '5px';
    grid.style.padding = '10px';
    grid.style.backgroundColor = '#f9f9f9';


    addSimulationRow(
        grid,
        "Test",
        "Zero High",
        "Bet high after a zero, using a progression.",
        () => zero_high()
    );

    addSimulationRow(
        grid,
        "Test",
        "Triple D",
        "Bet dozen 2 and 3 after 3 single digits in a row, use triple martingale on a loss.",
        () => ddd()
    );


    container.appendChild(grid);
    container.appendChild(document.createElement('br'));
    return container;
}

function addSimulationRow(grid, buttonText, titleText, descriptionText, simulationFunction) {
    // Button Column
    let button = document.createElement('button');
    button.innerText = buttonText;
    button.style.padding = '10px 20px';
    button.style.backgroundColor = '#4CAF50';
    button.style.color = 'white';
    button.style.border = 'none';
    button.style.borderRadius = '5px';
    button.style.cursor = 'pointer';
    button.style.fontSize = '18px'; // Slightly smaller than main font
    button.style.fontWeight = 'bold';
    button.onclick = simulationFunction;
    grid.appendChild(button);

    // Title Column
    let title = document.createElement('div');
    title.innerText = titleText;
    title.style.fontSize = '24px'; // Main font size
    title.style.fontWeight = 'bold';
    title.style.color = '#333';
    grid.appendChild(title);

    // Description Column
    let description = document.createElement('div');
    description.innerText = descriptionText;
    description.style.fontSize = '24px'; // Main font size
    description.style.color = '#555';
    grid.appendChild(description);
}