function createProfitChartWidget() {
    const widgetContainer = document.createElement('div');
    widgetContainer.id = 'profit-chart-widget';

    // Optional background color
    let savedColor = localStorage.getItem(widgetContainer.id + '-backgroundColor');
    if (savedColor) {
        widgetContainer.style.backgroundColor = savedColor;
    }

    // Optional color changer
    let colorChanger = quickSpin_colorChanger(widgetContainer.id);
    widgetContainer.append(colorChanger);

    // Create button controls
    const buttonContainer = document.createElement('div');
    buttonContainer.style.marginBottom = '10px';

    const profitBtn = document.createElement('button');
    profitBtn.textContent = 'Profit Chart';
    profitBtn.id = 'profitChartBtn';
    profitBtn.style.marginRight = '10px';

    const sessionBtn = document.createElement('button');
    sessionBtn.textContent = 'Session Profit';
    sessionBtn.id = 'sessionProfitBtn';

    buttonContainer.appendChild(profitBtn);
    buttonContainer.appendChild(sessionBtn);
    widgetContainer.appendChild(buttonContainer);

    // Create chart canvas
    const canvas = document.createElement('canvas');
    canvas.id = 'profitChartCanvas';
    canvas.width = 1000;
    canvas.height = 600;
    widgetContainer.appendChild(canvas);

    // Add styles
    const styles = `
        #profit-chart-widget {
            width: 1050px;
            height: 730px;
            overflow: hidden;
            border: 1px solid #ccc;
            padding: 10px;
            position: relative;
        }
        #profit-chart-widget button {
            padding: 5px 10px;
            font-size: 14px;
            cursor: pointer;
        }
        #profit-chart-widget button.active {
            font-weight: bold;
            background-color: #ddd;
        }
    `;
    const styleSheet = document.createElement('style');
    styleSheet.type = 'text/css';
    styleSheet.innerText = styles;
    document.head.appendChild(styleSheet);

    // Create the chart
    const ctx = canvas.getContext('2d');
    window.sessionChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: profitHistory.map((_, i) => i + 1),
            datasets: [{
                label: 'Profit',
                data: profitHistory,
                borderColor: 'green',
                backgroundColor: 'rgba(0, 128, 0, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.2
            }]
        },
        options: {
            responsive: false,
            animation: false,
            plugins: {
                legend: { display: true }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Spin' } },
                y: { display: true, title: { display: true, text: 'Profit' } }
            }
        }
    });

    // Button logic
    profitBtn.addEventListener('click', () => {
        updateChartData(profitHistory, 'Profit');
        profitBtn.classList.add('active');
        sessionBtn.classList.remove('active');
    });

    sessionBtn.addEventListener('click', () => {
        updateChartData(session_user_amount_array, 'Session Profit');
        sessionBtn.classList.add('active');
        profitBtn.classList.remove('active');
    });

    // Default to Profit
    profitBtn.classList.add('active');

    return widgetContainer;
}

function updateChartData(dataArray, title) {
    if (!window.sessionChart) return;

    window.sessionChart.data.labels = dataArray.map((_, i) => i + 1);
    window.sessionChart.data.datasets[0].data = dataArray;
    window.sessionChart.data.datasets[0].label = title;
    window.sessionChart.options.scales.y.title.text = title;
    window.sessionChart.update();
}

function updateProfitChartWidget() {
    const chartContainer = document.getElementById('profit-chart-widget');
    const canvas = document.getElementById('profitChartCanvas');

    if (!chartContainer || !canvas || !window.sessionChart) {
        console.warn("Profit chart widget or chart not found.");
        return;
    }

    const profitBtn = document.getElementById('profitChartBtn');
    const sessionBtn = document.getElementById('sessionProfitBtn');

    const currentLabel = window.sessionChart.data.datasets[0].label;
    const isProfit = currentLabel === 'Profit';

    const newData = isProfit ? profitHistory : session_user_amount_array;
    const newLabel = isProfit ? 'Profit' : 'Session Profit';

    // Update chart
    updateChartData(newData, newLabel);

    // Update button highlight
    if (isProfit) {
        profitBtn?.classList.add('active');
        sessionBtn?.classList.remove('active');
    } else {
        sessionBtn?.classList.add('active');
        profitBtn?.classList.remove('active');
    }
}
