
var lastStreetNumbers = 37;

function updateLinesNewNumber() {
  updateBuildLines();
  scrollToBottom();
}

function updateBuildLines() {
  let container = document.getElementById('button-bar-div-5');
  if (container) {
    container.innerHTML = '';
    let newBoard = buildTable();
    container.appendChild(newBoard);
  }

}


function buildLines() {
  return [0, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];
}

function buildLinesStreet() {
  return [0, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];
}

function buildLinesCounts() {
  var lines = buildLinesStreet();
  var missedCounts = new Array(lines.length).fill(0);

  // Assume 'numbers' is defined globally or passed into this function
  const spins = [...numbers];
  var lastNumbers = spins.slice(-lastStreetNumbers);
  // Create rows for each spin
  lastNumbers.forEach(spin => {
    lines.forEach((line, index) => {
      if (line === 0) {
        missedCounts[0] = line === spin ? 0 : missedCounts[0] + 1;
      }
      else {
        missedCounts[index] = (line === spin || line + 1 === spin || line + 2 === spin) ? 0 : missedCounts[index] + 1;
      }

    });
  });
  missedCounts[0] = 9;
  missedCounts.push('Street ');

  return missedCounts;
}


function getLinesTitle(title) {
  let titleDiv = document.createElement('div');
  let titleSpan = document.createElement('span');
  titleSpan.innerHTML = `<h2>${title}</h2>`;
  titleDiv.style.marginLeft = '25px';
  titleDiv.appendChild(titleSpan);
  titleDiv.style.marginBottom = '-20px';
  return titleDiv;

}

function getCountTitle(title) {
  let titleDiv = document.createElement('div');
  let titleSpan = document.createElement('span');
  titleSpan.innerHTML = `${title}`;
  titleDiv.style.marginLeft = '25px';
  titleDiv.appendChild(titleSpan);
  titleDiv.style.marginTop = '25px';
  titleDiv.style.marginBottom = '-30px';
  return titleDiv;

}
function getHitTitle(title) {
  let titleDiv = document.createElement('div');
  let titleSpan = document.createElement('span');
  titleSpan.innerHTML = `${title}`;
  titleDiv.style.marginLeft = '25px';
  titleDiv.appendChild(titleSpan);
  titleDiv.style.marginTop = '5px';
  // titleDiv.style.marginBottom = 'px'; 
  return titleDiv;

}

function streetUserInput() {
  let containerUserInput = document.createElement('div');
  containerUserInput.id = 'container-street-user-input';
  containerUserInput.style.display = 'flex';
  containerUserInput.style.alignItems = 'center';
  containerUserInput.style.marginLeft = '25px';
  containerUserInput.style.marginBottom = '-20px';
  containerUserInput.style.marginTop = '20px';



  // User Input
  let userInput = two_box_input_and_button('street-inputbox', lastStreetNumbers, 'street-button', 'street-button-all', 'Lookback', 'All', 'street-span', '0px');
  let userInputContainer = userInput.container;
  var freqButton = userInput.buttons.button1;
  var freqButtonAll = userInput.buttons.button2;

  if (freqButton) { freqButton.onclick = streetUpdate; }
  if (freqButtonAll) { freqButtonAll.onclick = streetUpdateAll; }

  containerUserInput.appendChild(userInputContainer);
  return containerUserInput;
}
function streetUpdateAll() {
  let spinLength = document.getElementById('street-inputbox');
  spinLength.value = numbers.length;
  lastStreetNumbers = spinLength.value;
  updateLinesNewNumber();
}
function streetUpdate() {
  let spinLength = document.getElementById('street-inputbox').value;
  spinLength = ensureInputValue(spinLength, 37);
  if (spinLength > numbers.length) { spinLength = numbers.length; }
  lastStreetNumbers = spinLength;
  updateLinesNewNumber();
}


function buildTable() {

  const container = document.createElement('div');
  container.id = 'streets-tool';

  let savedColor = localStorage.getItem(container.id + '-containerIdbackgroundColor');
  if (savedColor) {
    container.style.backgroundColor = savedColor;
  }

  let colorChangerQuickSpin = quickSpin_colorChanger(container.id);
  container.append(colorChangerQuickSpin);

  let streetUsesrInputs = streetUserInput();
  container.appendChild(streetUsesrInputs);

  let countTitle = getCountTitle('Misses in a row');
  container.appendChild(countTitle);

  let countContainer = getMissedCounts_1();
  container.appendChild(countContainer);
  let hitTitle = getHitTitle('Total hits');
  container.appendChild(hitTitle);

  let lineTitle = getLinesTitle('Streets ');
  container.appendChild(lineTitle);

  // let hits = getCountTitle('Hits');
  // container.appendChild(hits);

  const board = document.createElement('div');
  board.id = 'tableContainer-lines';
  const lines = buildLines();
  const table = document.createElement('table');
  table.id = 'rouletteTable-lines';
  const thead = document.createElement('thead');
  const tbody = document.createElement('tbody');
  table.appendChild(thead);
  table.appendChild(tbody);

  // Create header row
  const headerRow = document.createElement('tr');
  lines.forEach(line => {
    const th = document.createElement('th');
    th.textContent = line;
    headerRow.appendChild(th);
  });
  thead.appendChild(headerRow);

  // Simulate 50 spins for demonstration (replace this with real spin results)
  const spins = [...numbers];
  var lastNumbers = spins.slice(-lastStreetNumbers);
  // Create rows for each spin
  lastNumbers.forEach((spin, index) => {
    const row = document.createElement('tr');
    lines.forEach(line => {
      const cell = document.createElement('td');
      if (line === 0) {
        cell.textContent = line === spin ? spin : ' ';
        if (line === spin) {
          cell.classList.add('highlight-lines');
        }
      } else {
        if (line > 0) {
          cell.textContent = line === spin || line + 1 === spin || line + 2 === spin ? spin : ' ';
          if (line === spin || line + 1 === spin || line + 2 === spin) {
            cell.classList.add('highlight-lines');
          }

        }
      }


      row.appendChild(cell);
    });
    tbody.appendChild(row);
  });
  board.appendChild(table);

  container.appendChild(board);
  return container;
}

function scrollToBottom() {
  const container = document.getElementById('tableContainer-lines');
  if (container) {
    container.scrollTop = container.scrollHeight;
  }

}

function getLastStreets() {
  let inputValue = document.getElementById('streets-inputbox');
  let lastXNumbers = numbers;
  if (inputValue) {
    inputValue = inputValue.value;

    // Check if the input value is a number
    let number = parseFloat(inputValue);
    if (isNaN(number)) {
      number = 37;

    }

    if (numbers.length > number) {
      lastXNumbers = numbers.slice(-number);
    }


  } else {
    if (numbers.length > 37) {
      lastXNumbers = numbers.slice(-37);
    }

  }


  return lastXNumbers;
}

function getMissedCounts_1() {


  const countContainer = styledDivMissed();
  countContainer.style.overflowX = 'hidden';
  const tableCounts = styledTableMissed();

  const theadCounts = document.createElement('thead');

  // Base
  const basetr = getBaseTh();

  // Street
  const trCounts = getStreetsTh_1();

  // Street Hit
  const streethits = getStreetsTh_hit();


  theadCounts.appendChild(trCounts);
  theadCounts.appendChild(basetr);
  tableCounts.appendChild(theadCounts);
  tableCounts.appendChild(streethits);


  countContainer.appendChild(tableCounts);



  return countContainer;
}

function getStreetsTh_1() {
  const trCounts = document.createElement('tr');

  const lineCounts = buildLinesCountsMissed_1();
  lineCounts.forEach((count, index) => {
    const th = document.createElement('th');
    th.textContent = count;
    th.style.position = 'sticky';
    th.style.top = '0';
    th.style.backgroundColor = '#f9f9f9';
    th.style.zIndex = '10';
    th.style.padding = '8px';
    if (index === 12) {
      th.style.textAlign = 'left';
      th.colSpan = '1';
      th.style.width = '100px';
    }
    else {
      th.style.textAlign = 'center';

    }
    th.style.border = '1px solid #ddd';
    th.style.boxSizing = 'border-box';
    trCounts.appendChild(th);
  });
  return trCounts;
}
function buildLinesCountsMissed_1() {
  var lines = buildLinesStreetMissed();
  var missedCounts = new Array(lines.length).fill(0);

  const spins = [...numbers];
  var lastNumbers = spins.slice(-lastStreetNumbers);
  // Create rows for each spin
  lastNumbers.forEach(spin => {
    lines.forEach((line, index) => {
      if (line === 0) {
        missedCounts[0] = line === spin ? 0 : missedCounts[0] + 1;
      }
      else {
        missedCounts[index] = (line === spin || line + 1 === spin || line + 2 === spin) ? 0 : missedCounts[index] + 1;
      }

    });
  });

  missedCounts.push('Misses');

  return missedCounts;
}

function getStreetsTh_hit() {
  const trCounts = document.createElement('tr');

  const lineCounts = buildLinesCountsMissed_hit();
  lineCounts.forEach((count, index) => {
    const th = document.createElement('th');
    th.textContent = count;
    if (count == 0) {
      th.style.backgroundColor = '#FFFF8F';
    } else {
      th.style.backgroundColor = '#f9f9f9';
    }
    th.style.position = 'sticky';
    th.style.top = '0';

    th.style.zIndex = '10';
    th.style.padding = '8px';
    if (index === 12) {
      th.style.textAlign = 'left';
      th.colSpan = '1';
      th.style.width = '100px';
    }
    else {
      th.style.textAlign = 'center';

    }
    th.style.border = '1px solid #ddd';
    th.style.boxSizing = 'border-box';
    trCounts.appendChild(th);
  });
  return trCounts;
}
function buildLinesStreetMissed_1() {
  return [
    [1, 2, 3], [4, 5, 6], [7, 8, 9], [10, 11, 12],
    [13, 14, 15], [16, 17, 18], [19, 20, 21], [22, 23, 24],
    [25, 26, 27], [28, 29, 30], [31, 32, 33], [34, 35, 36]
  ];
}

function buildLinesCountsMissed_hit() {
  var streets = buildLinesStreetMissed_1();
  var hitCounts = new Array(streets.length).fill(0);

  const spins = [...numbers];
  var lastNumbers = spins.slice(-lastStreetNumbers);

  lastNumbers.forEach(spin => {
    streets.forEach((line, index) => {
      if (line.includes(spin)) {
        hitCounts[index] += 1;
      }
    });
  });

  hitCounts.push('Hits');

  return hitCounts;
}
