
function buildHistogramChart() {
    let container = document.createElement('div');
    container.id = 'histoGramContainer';
    container.style.width = '400px';
    container.style.height = '300px';
    container.style.margin = '20px auto';
    container.style.border = '1px solid #ccc';
    container.style.padding = '10px';

    let canvasitem = document.createElement('canvas');
    canvasitem.id = 'chart';

    let data = numbers;

    if (chart) {
        chart.destroy();
    }

    var ctx = canvasitem.getContext('2d');
    chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: Array.from({ length: 500 }, (_, i) => i.toString()),
            datasets: [{
                label: 'Winning Numbers Distribution',
                data: data,
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: { // Updated for Chart.js version 3.x and later
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });

    container.appendChild(canvasitem);
    return container;
}


function updateHistogramChart()
{
    let data = numbers;

    let canvas = document.getElementById('chart'); 

    if (!canvas) {
        return;
    }
    if (chart) {
        chart.destroy();
    }

    var ctx = canvas.getContext('2d');
    chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: Array.from({ length: 500 }, (_, i) => i.toString()),
            datasets: [{
                label: 'Winning Numbers Distribution',
                data: data,
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: { // Updated for Chart.js version 3.x and later
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });
   
}

