function slider(numArray) {
    // Create a label for the slider description
    const descriptionLabel = document.createElement('label');
    descriptionLabel.setAttribute('for', 'slider');
    descriptionLabel.className = 'slider-description';
    descriptionLabel.textContent = 'Show sleepers on table';

    // Create the checkbox input
    const sliderCheckbox = document.createElement('input');
    sliderCheckbox.type = 'checkbox';
    sliderCheckbox.id = 'slider';
    sliderCheckbox.className = 'slider-checkbox';

    // Create the label for the checkbox
    const sliderLabel = document.createElement('label');
    sliderLabel.setAttribute('for', 'slider');
    sliderLabel.className = 'slider-label';

    // Create the slider button
    const sliderButton = document.createElement('span');
    sliderButton.className = 'slider-button';

    // Append the button to the label
    sliderLabel.appendChild(sliderButton);

    // Create a container for the slider and description
    const sliderContainer = document.createElement('div');
    sliderContainer.id = 'slider-container-id';
    sliderContainer.className = 'slider-container';
    sliderContainer.style.display = 'flex';
    sliderContainer.style.alignItems = 'center';
    sliderContainer.style.marginLeft = '10px';

    // Append the description and slider to the container
    sliderContainer.appendChild(descriptionLabel);
    sliderContainer.appendChild(sliderCheckbox);
    sliderContainer.appendChild(sliderLabel);

    sliderCheckbox.addEventListener('change', () => {
        if (sliderCheckbox.checked) {
            let fullArray = Array.from({ length: 37 }, (_, i) => i);
            sliderUnhighlight();

            let lastXNumbers = getNumberSequence();

            let finalArray = fullArray.filter(item => !lastXNumbers.includes(item));      

            sliderHighlight(finalArray);

            const frequency = countOutsideNumbersFrequency(finalArray);

            const frequenciesArray = [
                frequency.red, frequency.black, 
                frequency.even, frequency.odd,
                frequency.high, frequency.low, 
                frequency.dozens[0], frequency.dozens[1],frequency.dozens[2], 
                frequency.rows[0], frequency.rows[1], frequency.rows[2]
            ];
            const sleeperChart = createDivContainer(frequenciesArray,finalArray);
            let container = document.getElementById('frequency-container');
            let item = document.getElementById('sleeper-chart');
            if (container.contains(item)) {
                container.removeChild(item);
            }

            container.appendChild(sleeperChart);



        } else {
            sliderUnhighlight();
            let container = document.getElementById('frequency-container');
            let item = document.getElementById('sleeper-chart');
            if (container.contains(item)) {
                container.removeChild(item);
            }
        }
    });
	
    return sliderContainer;
}

function updateSleeperTable()
{
    let item = document.getElementById('sleeper-chart');

  
            if (item) {
                item.innerHTML = '';
                let lastXNumbers = getNumberSequence();
                let fullArray = Array.from({ length: 37 }, (_, i) => i);
                let finalArray = fullArray.filter(item => !lastXNumbers.includes(item));      
    
                const frequency = countOutsideNumbersFrequency(finalArray);
    
                const frequenciesArray = [
                    frequency.red, frequency.black, 
                    frequency.even, frequency.odd,
                    frequency.high, frequency.low, 
                    frequency.dozens[0], frequency.dozens[1],frequency.dozens[2], 
                    frequency.rows[0], frequency.rows[1], frequency.rows[2]
                ];
                const sleeperChart = createDivContainer(frequenciesArray);
                item.appendChild(sleeperChart);
            }
}


function handleSliderChange() {
    const sliderCheckbox = document.getElementById('slider');

    if(sliderCheckbox)
    {

        if (sliderCheckbox.checked) {
            let fullArray = Array.from({ length: 37 }, (_, i) => i);
            sliderUnhighlight();
    
            let lastXNumbers = getNumberSequence();
    
            let finalArray = fullArray.filter(item => !lastXNumbers.includes(item));
    
            sliderHighlight(finalArray);
    
        } else {
            sliderUnhighlight();
        }
    }

}

function sliderHighlight(arr)
{

    arr.forEach(item => {
        let div;
        if (item === 0) {
            div = document.querySelector(`div[data-values="zero_${item}"]`);
        } else {
            div = document.querySelector(`div[data-values="${item}"]`);
        }

        if (div) {
            div.classList.add('slider-highlights');
        }
    });

}
function sliderUnhighlight()
{
    let arr = Array.from({ length: 37 }, (_, i) => i);
    arr.forEach(item => {
        let div;
        if (item === 0) {
            div = document.querySelector(`div[data-values="zero_${item}"]`);
        } else {
            div = document.querySelector(`div[data-values="${item}"]`);
        }

        if (div) {
            div.classList.remove('slider-highlights');
        }
    });
}

function getNumberSequence()
{
    let inputValue = document.getElementById('freq-inputbox');
    let lastXNumbers = numbers;
    if(inputValue)
    {
        inputValue = inputValue.value;

        // Check if the input value is a number
        let number = parseFloat(inputValue);
        if (isNaN(number)) {
            number = 37;

        }
        
        if(numbers.length>number)
            {
                lastXNumbers = numbers.slice(-number);
            }


    }else{
        if(numbers.length>37)
            {
                lastXNumbers = numbers.slice(-37);
            }

    }


    return lastXNumbers;
}

function frequencyBuild() {
    let container = document.createElement('div');
    container.id = 'frequency-container';
    container.style.marginLeft = '25px';
    container.style.marginBottom = '15px';

    let savedColor = localStorage.getItem(container.id+'-containerIdbackgroundColor');
    if (savedColor) {
        container.style.backgroundColor = savedColor;
    }

    let colorChangerQuickSpin = quickSpin_colorChanger(container.id);
    container.append(colorChangerQuickSpin);
    
    let containerUserInput = document.createElement('div');
    containerUserInput.id = 'container-frequency-user-input';
    containerUserInput.style.display = 'flex';
    containerUserInput.style.alignItems = 'center';

    let containerContents = document.createElement('div');
    containerContents.id = 'container-frequency-contents';

    let titleDiv = document.createElement('div');
    let titleSpan = document.createElement('span'); 
    titleSpan.innerHTML = '<h2>Frequency</h2>';
    titleDiv.appendChild(titleSpan);
    titleDiv.style.marginBottom = '-20px'; 
    container.appendChild(titleDiv);

    // User Input
    let userInput = two_box_input_and_button('freq-inputbox', '37', 'freq-button', 'freq-button-all', 'Lookback', 'All', 'freq-span', '0px');
    let userInputContainer = userInput.container;
    var freqButton = userInput.buttons.button1;
    var freqButtonAll = userInput.buttons.button2;

    if (freqButton) { freqButton.onclick = frequencyUpdate; }
    if (freqButtonAll) { freqButtonAll.onclick = frequencyUpdateAll; }

    containerUserInput.appendChild(userInputContainer);


    let lastXNumbers = getNumberSequence();
    

    // Counting the frequency of each number in last37
    const frequencyCountAll = lastXNumbers.reduce((acc, num) => {
        acc[num] = (acc[num] || 0) + 1;
        return acc;
    }, {});

    // Counting the frequency of each number in last37
    const frequencyCount = lastXNumbers.reduce((acc, num) => {
        acc[num] = (acc[num] || 0) + 1;
        return acc;
    }, {});

	

    // Array of numbers from 0 to 35
    let allNumbers = Array.from({length: 37}, (_, index) => index);

    // Sort these numbers by their frequency in last37, then by number if frequencies are equal
    allNumbers.sort((a, b) => {
        const freqA = frequencyCount[a] || 0;
        const freqB = frequencyCount[b] || 0;
        return freqB - freqA || a - b;
    });

    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
    const frequencyAllRow = document.createElement('div');
    const frequencyRow = document.createElement('div');
    const lastSeenRow = document.createElement('div'); 
    const lastUpRow = document.createElement('div');
    
    frequencyAllRow.style.display = numberRow.style.display = frequencyRow.style.display = lastSeenRow.style.display = lastUpRow.style.display = 'flex';
	
    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
        const frequencyAllCell = document.createElement('div');
        const frequencyCell = document.createElement('div');
        const lastSeenCell = document.createElement('div'); 
        const lastUpAllCell = document.createElement('div'); 

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;
        frequencyAllCell.innerText = frequencyCountAll[num] || 0;

        // Calculate spins since last appearance
        const lastIndexOfNum = lastXNumbers.lastIndexOf(num);
        lastSeenCell.innerText = lastIndexOfNum !== -1 ? (lastXNumbers.length - 1) - lastIndexOfNum : '';

        // Calculate Last up all
        const lastUpAllIndex = numbers.lastIndexOf(num);
        lastUpAllCell.innerText = lastUpAllIndex !== -1 ? (numbers.length - 1) - lastUpAllIndex : '';

        // Base styles for cells
        [numberCell, frequencyAllCell, frequencyCell, lastSeenCell, lastUpAllCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
        frequencyAllCell.style.color = 'black';
        frequencyCell.style.color = 'blue';
        lastSeenCell.style.color = 'blue'; // Color for spins since last appearance
        lastUpAllCell.style.color = 'black';

        // Apply background color based on the number
        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; 
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; 
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; 
        }

        // Append cells to their respective rows
        numberRow.appendChild(numberCell);
        frequencyAllRow.appendChild(frequencyAllCell);
        frequencyRow.appendChild(frequencyCell);
        lastSeenRow.appendChild(lastSeenCell);
        lastUpRow.appendChild(lastUpAllCell);
    });

    table.appendChild(frequencyRow);
    table.appendChild(numberRow);

    containerContents.appendChild(table);

    let toggleButton = slider();
    containerUserInput.appendChild(toggleButton);
    container.appendChild(containerUserInput);

   

	container.appendChild(containerContents);



    return container;
}

function countOutsideNumbersFrequency(finalArray) {


    let red = 0, black = 0, even = 0, odd = 0, low = 0, high = 0;
    let dozens = [0, 0, 0];
    let rows = [0, 0, 0];

    finalArray.forEach(number => {
        // Count red and black
        if ((number >0)) {

            if (number % 2 === 0) even++;
            else odd++;
            
            if (number <= 18) low++;
            else high++;
            
            if (numRed.includes(number)) red++;
            if (numBlack.includes(number)) black++;
        }

        // Count dozens
        if (rouletteAttributes.dozens[0].includes(number)) dozens[0]++;
        if (rouletteAttributes.dozens[1].includes(number)) dozens[1]++;
        if (rouletteAttributes.dozens[2].includes(number)) dozens[2]++;

        // Count rows
        if (rouletteAttributes.columns[0].includes(number)) rows[0]++;
        if (rouletteAttributes.columns[1].includes(number)) rows[1]++;
        if (rouletteAttributes.columns[2].includes(number)) rows[2]++;
    });

    return {
        red,
        black,
        even,
        odd,
        low,
        high,
        dozens,
        rows
    };
}

function createDivContainer(frequenciesArray) {
    // Assuming numbers is defined elsewhere in your code
    let currentNumber = numbers.length ? numbers[numbers.length - 1] : null;


    // Create container div
    const container = document.createElement('div');
    container.id = 'sleeper-chart';

    // Create title
    const title = document.createElement('div');
    // Set the text content of the title including the current number
    title.textContent = 'Sleepers Frequency - Number up: ';

    // Create a span for the current number to apply specific styling
    const currentNumberSpan = document.createElement('span');
    currentNumberSpan.textContent = currentNumber;

    // Change the font color if the current number is red
    if (numRed.includes(currentNumber)) {
        currentNumberSpan.style.color = 'red';
    }
    if (currentNumber === 0) {
        currentNumberSpan.style.color = 'green';
    }

    let fullArray = Array.from({ length: 37 }, (_, i) => i);


    let lastXNumbers = getNumberSequence();

    let finalArray = fullArray.filter(item => !lastXNumbers.includes(item)); 

    // Append the current number span to the title
    title.appendChild(currentNumberSpan);
    
    const sleeperCountSpan = document.createElement('span');
    sleeperCountSpan.textContent = 'Sleeper Count: '+finalArray.length;
    sleeperCountSpan.style.marginLeft = '100px';

    title.appendChild(sleeperCountSpan);

    title.style.fontWeight = 'bold'; // Make the title bold if desired
    container.appendChild(title);

    // Create first row for column headers
    const row1 = document.createElement('div');
    row1.classList.add('row-sleeper-chart');
    row1.id = 'row1';
    const columnHeaders = ['Red', 'Black', 'Even', 'Odd', 'High', 'Low', 'Doz 1', 'Doz 2', 'Doz 3', 'Row 1', 'Row 2', 'Row 3'];
    
    columnHeaders.forEach((columnHeader, index) => {
        const columnHeaderDiv = document.createElement('div');
        columnHeaderDiv.classList.add('label-sleeper-chart');
        columnHeaderDiv.textContent = columnHeader;

        // Highlight the header if it matches currentNumber logic
        if (currentNumber !== null && currentNumber>0) {
            if (
                (columnHeader === 'Red' && numRed.includes(currentNumber)) ||
                (columnHeader === 'Black' && numBlack.includes(currentNumber)) ||
                (columnHeader === 'Even' && currentNumber % 2 === 0) ||
                (columnHeader === 'Odd' && currentNumber % 2 !== 0) ||
                (columnHeader === 'High' && currentNumber > 18) ||
                (columnHeader === 'Low' && currentNumber <= 18) ||
                (columnHeader === 'Doz 1' && rouletteAttributes.dozens[0].includes(currentNumber)) ||
                (columnHeader === 'Doz 2' && rouletteAttributes.dozens[1].includes(currentNumber)) ||
                (columnHeader === 'Doz 3' && rouletteAttributes.dozens[2].includes(currentNumber)) ||
                (columnHeader === 'Row 1' && rouletteAttributes.columns[0].includes(currentNumber)) ||
                (columnHeader === 'Row 2' && rouletteAttributes.columns[1].includes(currentNumber)) ||
                (columnHeader === 'Row 3' && rouletteAttributes.columns[2].includes(currentNumber))
            ) {
                columnHeaderDiv.style.backgroundColor = 'lightgreen';
            }
        }

        row1.appendChild(columnHeaderDiv);
    });

    // Create second row
    const row2 = document.createElement('div');
    row2.classList.add('row-sleeper-chart');
    row2.id = 'row2';
    // You can add content to the second row dynamically here if needed
    frequenciesArray.forEach(data => {
        const dataDiv = document.createElement('div');
        dataDiv.classList.add('data-sleeper-chart'); // Change the class to 'data-sleeper-chart'
        dataDiv.textContent = data;
        row2.appendChild(dataDiv);
    });

    // Append rows to container
    container.appendChild(row1);
    container.appendChild(row2);

    // Return the container
    return container;
}




function frequencyBuild_old() {

    let container = document.createElement('div');
    container.style.marginLeft = '25px';
    container.style.marginBottom = '15px';
    
    let containerUserInput = document.createElement('div');
    containerUserInput.id = 'container-frequency-user-input';
    let containerContents = document.createElement('div');
    containerContents.id = 'container-frequency-contents';

    let titleDiv = document.createElement('div');
    let titleSpan = document.createElement('span'); 
    titleSpan.innerHTML = '<h2>Frequency</h2>';
    titleDiv.appendChild(titleSpan);
    titleDiv.style.marginBottom = '-20px'; 
    container.appendChild(titleDiv);

    // User Input
    let userInput = two_box_input_and_button('freq-inputbox', '37', 'freq-button', 'freq-button-all','Lookback', 'All','freq-span','0px');
    let userInputContainer = userInput.container;
    var freqButton = userInput.buttons.button1;
    var freqButtonAll = userInput.buttons.button2;

    if (freqButton) { freqButton.onclick = frequencyUpdate; }
    if (freqButtonAll) { freqButtonAll.onclick = frequencyUpdateAll; }

    containerUserInput.appendChild(userInputContainer);


    // Display

    let last37 = numbers.slice(-37);


	// Counting the frequency of each number in last37
	const frequencyCountAll = numbers.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Counting the frequency of each number in last37
	const frequencyCount = last37.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Array of numbers from 0 to 35
	let allNumbers = Array.from({length: 37}, (_, index) => index);

	// Sort these numbers by their frequency in last37, then by number if frequencies are equal
	allNumbers.sort((a, b) => {
		const freqA = frequencyCount[a] || 0;
		const freqB = frequencyCount[b] || 0;
		return freqB - freqA || a - b;
	});


    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
	const frequencyAllRow = document.createElement('div');
    const frequencyRow = document.createElement('div');
    const lastSeenRow = document.createElement('div'); 
	const lastUpRow = document.createElement('div');
    
    frequencyAllRow.style.display = numberRow.style.display = frequencyRow.style.display = lastSeenRow.style.display =  lastUpRow.style.display ='flex';


/*
	const helpCellfreqAll = document.createElement('div');
	helpCellfreqAll.style.display = 'flex';
	helpCellfreqAll.style.justifyContent = 'center';
	helpCellfreqAll.style.alignItems = 'center';
	helpCellfreqAll.style.border = '1px solid black';
	helpCellfreqAll.style.width = '32px';
	helpCellfreqAll.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up.';
	var helpIcon = createHelpBox(msg);
	helpCellfreqAll.appendChild(helpIcon);
	frequencyAllRow.appendChild(helpCellfreqAll);


	const helpCellfreq = document.createElement('div');
	helpCellfreq.style.display = 'flex';
	helpCellfreq.style.justifyContent = 'center';
	helpCellfreq.style.alignItems = 'center';
	helpCellfreq.style.border = '1px solid black';
	helpCellfreq.style.width = '32px';
	helpCellfreq.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up over the last 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCellfreq.appendChild(helpIcon);
	frequencyRow.appendChild(helpCellfreq);

	const helpCelllaw = document.createElement('div');
	helpCelllaw.style.display = 'flex';
	helpCelllaw.style.justifyContent = 'center';
	helpCelllaw.style.alignItems = 'center';
	helpCelllaw.style.border = '1px solid black';
	helpCelllaw.style.width = '32px';
	helpCelllaw.style.height = '25px';
	var msg = 'The Law of the Third says that in 37 spins,';
	msg += '\nabout 24 numbers will come up.';
	msg += '\n\n';
	msg += "This leaves about 1/3 of the number not coming up,";
	msg += '\n';
	msg += "and several repeat numbers.";
	msg += '\n';
	msg += '\n';
	msg += 'This chart shows the frequency of numbers over the last 37 spins.';
	msg += '\n';
	msg += '\n';
	msg += 'We leave it to the player to figure out how take advantage of it.';
	var patternTitle = createHelpBox(msg);
	helpCelllaw.appendChild(patternTitle);
	numberRow.appendChild(helpCelllaw);


	const helpCell = document.createElement('div');
	helpCell.style.display = 'flex';
	helpCell.style.justifyContent = 'center';
	helpCell.style.alignItems = 'center';
	helpCell.style.border = '1px solid black';
	helpCell.style.width = '32px';
	helpCell.style.height = '25px';
	var msg = 'Shows the last time the number appeared in 37 spins.\nA blank means the number has appeared in over 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCell.appendChild(helpIcon);
	lastSeenRow.appendChild(helpCell);
	

	const helpLastUp = document.createElement('div');
	helpLastUp.style.display = 'flex';
	helpLastUp.style.justifyContent = 'center';
	helpLastUp.style.alignItems = 'center';
	helpLastUp.style.border = '1px solid black';
	helpLastUp.style.width = '32px';
	helpLastUp.style.height = '25px';
	var msg = 'Shows the last time the number appeared.\nA blank means the number has never come up.';
	var helpIcon = createHelpBox(msg);
	helpLastUp.appendChild(helpIcon);
	lastUpRow.appendChild(helpLastUp);
*/

    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
		const frequencyAllCell = document.createElement('div');
        const frequencyCell = document.createElement('div');
        const lastSeenCell = document.createElement('div'); 
		const lastUpAllCell = document.createElement('div'); 

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;
		frequencyAllCell.innerText = frequencyCountAll[num] || 0;
		

        // Calculate spins since last appearance
        const lastIndexOfNum = last37.lastIndexOf(num);
        lastSeenCell.innerText = lastIndexOfNum !== -1 ? (last37.length - 1) - lastIndexOfNum : '';

		// Calculate Last up all
		const lastUpAllIndex = numbers.lastIndexOf(num);
		lastUpAllCell.innerText = lastUpAllIndex !== -1 ? (numbers.length - 1) - lastUpAllIndex : '';

        // Base styles for cells
        [numberCell, frequencyAllCell, frequencyCell, lastSeenCell, lastUpAllCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
		frequencyAllCell.style.color = 'black';
        frequencyCell.style.color = 'blue';
        lastSeenCell.style.color = 'blue'; // Color for spins since last appearance
		lastUpAllCell.style.color = 'black';

        // Apply background color based on the number
        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; 
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; 
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; 
        }
	
        // Append cells to their respective rows
        numberRow.appendChild(numberCell);
		frequencyAllRow.appendChild(frequencyAllCell);
        frequencyRow.appendChild(frequencyCell);
        lastSeenRow.appendChild(lastSeenCell);
		lastUpRow.appendChild(lastUpAllCell);
    });



	table.appendChild(frequencyAllRow);
    table.appendChild(numberRow);

    containerContents.appendChild(table);
	let toggleButton = slider(lastXNumbers);
	containerUserInput.appendChild(toggleButton);
    container.appendChild(containerUserInput);

    container.appendChild(containerContents);

	return container;
}

function frequencyUpdateAll(){
    let spinLength = document.getElementById('freq-inputbox');
    spinLength.value = numbers.length;
    frequencyUpdate();
}
function frequencyUpdate(){
    let spinLength = document.getElementById('freq-inputbox').value;
    spinLength = ensureInputValue(spinLength,37);
    if(spinLength>numbers.length) {spinLength = numbers.length; }
    updateFrequencyTable(spinLength);
}

function updateFrequencyTable(lookBackSpins)
{
    var newSpins = numbers.slice(-lookBackSpins);
    
    var container = document.getElementById('container-frequency-contents');
    container.innerHTML = '';

 

     const frequencyCount = newSpins.reduce((acc, num) => {
         acc[num] = (acc[num] || 0) + 1;
         return acc;
     }, {});
 
     let allNumbers = Array.from({length: 37}, (_, index) => index);
 
     allNumbers.sort((a, b) => {
         const freqA = frequencyCount[a] || 0;
         const freqB = frequencyCount[b] || 0;
         return freqB - freqA || a - b;
     });
 
 

     const table = document.createElement('div');
     
     // Create rows for numbers and frequencies
     const numberRow = document.createElement('div');
     const frequencyAllRow = document.createElement('div');

     frequencyAllRow.style.display = numberRow.style.display ='flex';
 

 
     allNumbers.forEach(num => {
         const numberCell = document.createElement('div');
         const frequencyAllCell = document.createElement('div');

 
         numberCell.innerText = num;
         frequencyAllCell.innerText = frequencyCount[num] || 0;
         
 
         [numberCell, frequencyAllCell].forEach(cell => {
             cell.style.width = '32px';
             cell.style.height = '25px';
             cell.style.display = 'flex';
             cell.style.justifyContent = 'center';
             cell.style.alignItems = 'center';
             cell.style.border = '1px solid black';
         });
 
         numberCell.style.color = 'white';
         frequencyAllCell.style.color = 'black';

 
         if (numRed.includes(num)) {
             numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; 
         } else if (numBlack.includes(num)) {
             numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; 
         } else if (num === 0) {
             numberCell.style.backgroundColor = 'rgb(146, 196, 150)';
         }
     
         numberRow.appendChild(numberCell);
         frequencyAllRow.appendChild(frequencyAllCell);

     });
 

     table.appendChild(frequencyAllRow);
     table.appendChild(numberRow);
 
     container.appendChild(table);

     handleSliderChange();

}

function updateFrequnecyNewNumber()
{

    var container = document.getElementById('container-frequency-contents');
    if(container)
    {
        frequencyUpdate();
    }
}


function frequencyBuildbackup() {
    let last37 = numbers.slice(-37);


	// Counting the frequency of each number in last37
	const frequencyCountAll = numbers.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Counting the frequency of each number in last37
	const frequencyCount = last37.reduce((acc, num) => {
		acc[num] = (acc[num] || 0) + 1;
		return acc;
	}, {});

	// Array of numbers from 0 to 35
	let allNumbers = Array.from({length: 37}, (_, index) => index);

	// Sort these numbers by their frequency in last37, then by number if frequencies are equal
	allNumbers.sort((a, b) => {
		const freqA = frequencyCount[a] || 0;
		const freqB = frequencyCount[b] || 0;
		return freqB - freqA || a - b;
	});


    // Create container for the table
    const table = document.createElement('div');
    
    // Create rows for numbers and frequencies
    const numberRow = document.createElement('div');
	const frequencyAllRow = document.createElement('div');
    const frequencyRow = document.createElement('div');
    const lastSeenRow = document.createElement('div'); 
	const lastUpRow = document.createElement('div');
    
    frequencyAllRow.style.display = numberRow.style.display = frequencyRow.style.display = lastSeenRow.style.display =  lastUpRow.style.display ='flex';



	const helpCellfreqAll = document.createElement('div');
	helpCellfreqAll.style.display = 'flex';
	helpCellfreqAll.style.justifyContent = 'center';
	helpCellfreqAll.style.alignItems = 'center';
	helpCellfreqAll.style.border = '1px solid black';
	helpCellfreqAll.style.width = '32px';
	helpCellfreqAll.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up.';
	var helpIcon = createHelpBox(msg);
	helpCellfreqAll.appendChild(helpIcon);
	frequencyAllRow.appendChild(helpCellfreqAll);


	const helpCellfreq = document.createElement('div');
	helpCellfreq.style.display = 'flex';
	helpCellfreq.style.justifyContent = 'center';
	helpCellfreq.style.alignItems = 'center';
	helpCellfreq.style.border = '1px solid black';
	helpCellfreq.style.width = '32px';
	helpCellfreq.style.height = '25px';
	var msg = 'Shows the frequency of the numbers that came up over the last 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCellfreq.appendChild(helpIcon);
	frequencyRow.appendChild(helpCellfreq);

	const helpCelllaw = document.createElement('div');
	helpCelllaw.style.display = 'flex';
	helpCelllaw.style.justifyContent = 'center';
	helpCelllaw.style.alignItems = 'center';
	helpCelllaw.style.border = '1px solid black';
	helpCelllaw.style.width = '32px';
	helpCelllaw.style.height = '25px';
	var msg = 'The Law of the Third says that in 37 spins,';
	msg += '\nabout 24 numbers will come up.';
	msg += '\n\n';
	msg += "This leaves about 1/3 of the number not coming up,";
	msg += '\n';
	msg += "and several repeat numbers.";
	msg += '\n';
	msg += '\n';
	msg += 'This chart shows the frequency of numbers over the last 37 spins.';
	msg += '\n';
	msg += '\n';
	msg += 'We leave it to the player to figure out how take advantage of it.';
	var patternTitle = createHelpBox(msg);
	helpCelllaw.appendChild(patternTitle);
	numberRow.appendChild(helpCelllaw);


	const helpCell = document.createElement('div');
	helpCell.style.display = 'flex';
	helpCell.style.justifyContent = 'center';
	helpCell.style.alignItems = 'center';
	helpCell.style.border = '1px solid black';
	helpCell.style.width = '32px';
	helpCell.style.height = '25px';
	var msg = 'Shows the last time the number appeared in 37 spins.\nA blank means the number has appeared in over 37 spins.';
	var helpIcon = createHelpBox(msg);
	helpCell.appendChild(helpIcon);
	lastSeenRow.appendChild(helpCell);
	

	const helpLastUp = document.createElement('div');
	helpLastUp.style.display = 'flex';
	helpLastUp.style.justifyContent = 'center';
	helpLastUp.style.alignItems = 'center';
	helpLastUp.style.border = '1px solid black';
	helpLastUp.style.width = '32px';
	helpLastUp.style.height = '25px';
	var msg = 'Shows the last time the number appeared.\nA blank means the number has never come up.';
	var helpIcon = createHelpBox(msg);
	helpLastUp.appendChild(helpIcon);
	lastUpRow.appendChild(helpLastUp);


    allNumbers.forEach(num => {
        const numberCell = document.createElement('div');
		const frequencyAllCell = document.createElement('div');
        const frequencyCell = document.createElement('div');
        const lastSeenCell = document.createElement('div'); 
		const lastUpAllCell = document.createElement('div'); 

        numberCell.innerText = num;
        frequencyCell.innerText = frequencyCount[num] || 0;
		frequencyAllCell.innerText = frequencyCountAll[num] || 0;
		

        // Calculate spins since last appearance
        const lastIndexOfNum = last37.lastIndexOf(num);
        lastSeenCell.innerText = lastIndexOfNum !== -1 ? (last37.length - 1) - lastIndexOfNum : '';

		// Calculate Last up all
		const lastUpAllIndex = numbers.lastIndexOf(num);
		lastUpAllCell.innerText = lastUpAllIndex !== -1 ? (numbers.length - 1) - lastUpAllIndex : '';

        // Base styles for cells
        [numberCell, frequencyAllCell, frequencyCell, lastSeenCell, lastUpAllCell].forEach(cell => {
            cell.style.width = '32px';
            cell.style.height = '25px';
            cell.style.display = 'flex';
            cell.style.justifyContent = 'center';
            cell.style.alignItems = 'center';
            cell.style.border = '1px solid black';
        });

        numberCell.style.color = 'white';
		frequencyAllCell.style.color = 'black';
        frequencyCell.style.color = 'blue';
        lastSeenCell.style.color = 'blue'; // Color for spins since last appearance
		lastUpAllCell.style.color = 'black';

        // Apply background color based on the number
        if (numRed.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(221, 82, 82)'; // Red
        } else if (numBlack.includes(num)) {
            numberCell.style.backgroundColor = 'rgb(68, 60, 60)'; // Black
        } else if (num === 0) {
            numberCell.style.backgroundColor = 'rgb(146, 196, 150)'; // Assuming 0 has a unique color
        }
	
        // Append cells to their respective rows
        numberRow.appendChild(numberCell);
		frequencyAllRow.appendChild(frequencyAllCell);
        frequencyRow.appendChild(frequencyCell);
        lastSeenRow.appendChild(lastSeenCell);
		lastUpRow.appendChild(lastUpAllCell);
    });






    // Append rows to the table container
	table.appendChild(frequencyAllRow);
    table.appendChild(frequencyRow);
    table.appendChild(numberRow);
    table.appendChild(lastSeenRow); 
	table.appendChild(lastUpRow);

	return table;
}

function slider_old()
{

    const sliderContainer = document.createElement('div');
	sliderContainer.id = 'slider-container';

	// Create a label for the slider description
	const descriptionLabel = document.createElement('label');
	descriptionLabel.setAttribute('for', 'slider');
	descriptionLabel.className = 'slider-description';
	descriptionLabel.textContent = 'Show sleeper numbers on table';

    // Create the checkbox input
    const sliderCheckbox = document.createElement('input');
    sliderCheckbox.type = 'checkbox';
    sliderCheckbox.id = 'slider';
    sliderCheckbox.className = 'slider-checkbox';

    // Create the label for the checkbox
    const sliderLabel = document.createElement('label');
    sliderLabel.setAttribute('for', 'slider');
    sliderLabel.className = 'slider-label';

    // Create the slider button
    const sliderButton = document.createElement('span');
    sliderButton.className = 'slider-button';

    // Append the button to the label
    sliderLabel.appendChild(sliderButton);

    // Append the checkbox and label to the container
	sliderContainer.appendChild(descriptionLabel);
    sliderContainer.appendChild(sliderCheckbox);
    sliderContainer.appendChild(sliderLabel);
	


	return sliderContainer;

}