/**********************************************************    Trigger Panels: [Bulk] Panel 
******************************************************************************************************************** 
****************    Trigger Panels: [Bulk] Panel                                                                   
******************************************************************************************************************** 
*/

function panelBulkContent() {

	// Paste Tab Container
	let panelPasteNumbers = document.createElement('div');
	panelPasteNumbers.setAttribute('id', 'paste-container');

	// Message to users
	let textMessage = document.createElement('h2');
	textMessage.innerText = "Enter bulk spins";
	textMessage.setAttribute('id', 'paste-pasteNumbersMessage');

	const buttonGroupContainer = document.createElement('div');
	buttonGroupContainer.setAttribute('id', 'paste-button-container');


	// Apply Button
	const addNumbersButton = document.createElement('button');
	addNumbersButton.innerText = "Apply";
	addNumbersButton.classList.add('bulk-button');
	//addNumbersButton.setAttribute('id', 'paste-applyButton');
	addNumbersButton.onclick = applyButtonEvent;

	// Reverse Button
	const reverseButton = document.createElement('button');
	reverseButton.innerText = "Reverse";
	reverseButton.classList.add('bulk-button');
	//reverseButton.setAttribute('id', 'paste-reverseButton');
	reverseButton.onclick = reverseButtonEvent;

	// Clear Button
	const clearButton = document.createElement('button');
	clearButton.innerText = "Clear";
	clearButton.classList.add('bulk-button');
	//clearButton.setAttribute('id', 'paste-clearButton');
	clearButton.onclick = clearButtonEvent;

	// Create button
	var copyButton = document.createElement('button');
	copyButton.innerText = 'Clipboard';
	copyButton.classList.add('bulk-button');

	// Event listener for the button
	copyButton.addEventListener('click', function () {
		// Select the text
		let data = document.getElementById('paste-enterOwnNumbers').value;
		// Copy the text inside the text field
		navigator.clipboard.writeText(data)
			.then(() => {
				// Success message
				showMessageAtCursor("Copied to clipboard.");
			})
			.catch(err => {
				// If the user denies clipboard permissions or another error occurs
				console.error('Failed to copy: ', err);
			});
	});

	buttonGroupContainer.appendChild(addNumbersButton);
	buttonGroupContainer.appendChild(reverseButton);
	buttonGroupContainer.appendChild(clearButton);
	buttonGroupContainer.appendChild(copyButton);

	// Enter Text Area
	const textarea = document.createElement('textarea');
	textarea.setAttribute('id', 'paste-enterOwnNumbers');
	textarea.placeholder = '1,2,3 4 5 6 Enters separated by a comma or space';

	// Add items to Paste Tab Container
	panelPasteNumbers.appendChild(textMessage);
	panelPasteNumbers.appendChild(buttonGroupContainer);
	panelPasteNumbers.appendChild(textarea);

	return panelPasteNumbers;
}


function processBulkNumbers(input) {
   
    var groups = input.split('-');

    var result = groups.map(group => {
        var cleanedGroup = group.replace(/\s+/g, "").replace(/\./g, ",").replace(/[^0-9,]/g, "");
        
        var numbers = cleanedGroup.split(',')
                        .map(number => parseInt(number, 10))
                        .filter(number => !isNaN(number) && number >= 0 && number <= 36);

        return numbers;
    }).filter(group => group.length > 0); 

    return result;
}
function processBulkNumbers_api(input) {
    var cleanedInput;
    if (wheelType == 38) {
       
        cleanedInput = input
            .replace(/\s+/g, " ") // Normalize spaces
            .replace(/,|\.|\s+/g, ",") // Replace delimiters with a comma
            .split(",") // Split into an array
            .map(item => {
                if (item === "00") return 37; // Replace "00" with 38
                let num = parseInt(item, 10); // Convert to a number
                return isNaN(num) || num < 0 || num > 37 ? null : num; // Retain only valid numbers
            })
            .filter(item => item !== null); // Remove invalid entries
    } else {
      
        cleanedInput = input
            .replace(/\s+/g, " ") // Normalize spaces
            .replace(/,|\.|\s+/g, ",") // Replace delimiters with a comma
            .split(",") // Split into an array
            .map(item => {
                if (item === "00") return 0; // Replace "00" with 37
                if (item === "37") return 0; // Replace "38" with 37
                let num = parseInt(item, 10); // Convert to a number
                return isNaN(num) || num < 0 || num > 37 ? null : num; // Retain only valid numbers
            })
            .filter(item => item !== null); // Remove invalid entries
    }


    return cleanedInput;
}

function applyButtonEvent() {


	var textarea = document.getElementById('paste-enterOwnNumbers');

	var value = textarea.value;

	value = processBulkNumbers(value);

	if(value.length==0)
	{
		showMessageAtCursor("Text Box needs a value.");
		return;
	}

	value.forEach(group => {

		group.forEach(item=>{
			numberPadSpin(item);
		})

	});
}
// Builk Reverse Button
function reverseButtonEvent() {
	let temp = [];
	var textarea = document.getElementById('paste-enterOwnNumbers');

	var value = textarea.value;
	var valueSpace = value.split(/[ ,]+/).join(',')
	valueSpace = valueSpace.replace(/(\r\n|\n|\r)/gm, ",");
	valueSpace = valueSpace.match(/[^ ,]+/g).join(',')

	var finalResults = valueSpace.split(',');
	for (var i = 0; i < finalResults.length; i++) {
		if (!isNaN(+finalResults[i])) {
			if (finalResults[i] >= 1 && finalResults[i] <= 100) {
				temp.push(finalResults[i]);
			}
		}
	}
	temp.reverse();

	textarea.value = temp.join(", ");
}
// Bulk Clear Button
function clearButtonEvent() {
	var textarea = document.getElementById('paste-enterOwnNumbers');
	textarea.value = '';
}