function populateTabs(){

	// bulkd, legend, highscore, bias, stats

	updateTab('tab-content-1', welcomeScreen);
    
	updateTab('tab-content-2', panelBulkContent);
	updateTab('tab-content-3', panelLegendContent);

    
	updateTab('tab-content-4', panelHighScoreContent);
    
	updateTab('tab-content-5', colorChanger);



}

function createTabbedNavigation() {
    // Create main container for tabs
    const tabContainer = document.createElement("div");
    tabContainer.id = "tabContainer";

    // Inject CSS styles
    const style = document.createElement('style');
    style.type = 'text/css';
    style.innerHTML = `
        .tab-container {
            overflow: hidden;
            background-color: #f1f1f1;
            padding: 10px;
            border: 1px solid #ccc;
        }
        .tab {
            float: left;
            border: 1px solid #ccc;
            background-color: #e5e5e5;
            margin-right: 4px;
            border-bottom: none;
            padding: 10px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .tab:hover {
            background-color: #ddd;
        }
        .tab-content {
            padding: 10px;
            border: 1px solid #ccc;
            border-top: none;
            display: none;
        }
        .active-tab {
            background-color: white;
        }
    `;
    document.head.appendChild(style);

    // Create the tab and content container
    const tabContainerDiv = document.createElement("div");
    tabContainerDiv.className = "tab-container";
    tabContainer.appendChild(tabContainerDiv);

    const tabs = ["Triggers", "Bulk", "Legend","High Score","Color Changer"];
    const contents = ["Content 1", "Bulk", "Content3","HighScore"];
    const tabContentsDivs = [];

    tabs.forEach((tab, index) => {
        // Create tabs
        const tabDiv = document.createElement("div");
        tabDiv.className = "tab";
        tabDiv.textContent = tab;
        tabDiv.onclick = function() {
            document.querySelectorAll(".tab").forEach(t => t.classList.remove("active-tab"));
            tabContentsDivs.forEach(c => c.style.display = "none");
    
            tabDiv.classList.add("active-tab");
            tabContentsDivs[index].style.display = "block";
            
            // Special action for "Bias" tab
            if (tab === "Bias") {
                biasChartUpdate();
            }
            if(tab === "High Score"){
                getRecords();
            }
        
        };
        tabContainerDiv.appendChild(tabDiv);

        // Create content for each tab with a unique ID
        const tabContentDiv = document.createElement("div");
        tabContentDiv.className = "tab-content";
        tabContentDiv.id = `tab-content-${index + 1}`; // Unique ID for each content area
        tabContentDiv.textContent = contents[index];
        if (index === 0) { // Make the first tab active by default
            tabContentDiv.style.display = "block";
            tabDiv.classList.add("active-tab");
        }
        tabContentsDivs.push(tabContentDiv);
        tabContainer.appendChild(tabContentDiv);

    });
	return tabContainer;
}

function updateTab(id, functioncall) {
   
    const contentToUpdate = document.getElementById(id);    
    if (contentToUpdate) {
        contentToUpdate.innerHTML = '';
		var contents = functioncall();
        contentToUpdate.appendChild(contents);
    }
}
function selectTabAndUpdateContent(tabIndex, contentUpdateFunction) {
    // Assuming tab indexes start from 1 for tab-content-1
    const tabId = `tab-content-${tabIndex}`;
    updateTab(tabId, contentUpdateFunction); // Update the content using the provided function

    // Simulate a click on the tab to ensure it gets selected and shown
    document.querySelectorAll(".tab")[tabIndex - 1].click();
}
function selectTab(tabIndex)
{
	document.querySelectorAll(".tab")[tabIndex - 1].click();
}


