// This is the triggers table that displays the misses or hits out of x spins
let toggle345 = false;
let streets345 = [];
function display_alerts(){
	streets345 = [];
	// Display Alerts
	panelAlertContainer.innerHTML = '';
	panelWatchContainer.innerHTML = '';

	let triggerWatch = trigger_watch_display();
	let trigerAlert = trigger_alert_display();

	panelAlertContainer.appendChild(trigerAlert);
	panelWatchContainer.appendChild(triggerWatch);

	table_alert_locations();
	showStreets345();

}
function trigger_watch_display() {
	
	let triggerfunctionsMap = {
		'Even': detailEven,
		'Odd': detailOdd,
		'Red': detailRed,
		'Black': detailBlack,
		'High': detailHigh,
		'Low': detailLow,
		'Dozen1': detailDozen1,
		'Dozen2': detailDozen2,
		'Dozen3': detailDozen3,
		'Row1': detailRow1,
		'Row2': detailRow2,
		'Row3': detailRow3,
		'Quads': detailQuads,
		'Splits': detailSplits,
		'Streets': detailStreets,
		'DoubleStreet': detailDoubleStreet,
		'StraightNumbers': detailStraightNumbers,
		'Uniques': detailUniques,
		'Groups': detailGroups,
		'Pattern': detailPattern
	};

	

	let container = createAndClearBlankDiv('trigger-watch-title-container');
/*
	const triggerWatchTitle = document.createElement('h2');
	triggerWatchTitle.id = 'trigger-watch-title';
	triggerWatchTitle.textContent = 'Trigger Watch';

	container.appendChild(triggerWatchTitle);
*/	

	alertHighLightStack = [];
	alertId = [];
	alertCounter = [];
	alertItem = [];
	alertItemDetail = [];
	alert_nameTag = [];
	watch_nameTag = [];

	watch_id = [];
	
	watch_count = [];
	watch_loss = [];
	watchCounter = [];
	watchItem = [];
	watchItemDetail = [];
	watch_highlight_stack = [];
	watchWinLoss = [];
	alertWinLoss = [];

	let calcLoss = triggerListLoss;
	let calcItem = triggerListItem;
	let calcText = triggerListText;
	let calWinLoss = triggerListWinLoss;
	let calNameTag = triggerListName;




	for (var x = 0; x < calcItem.length; x++) {
		if (triggerfunctionsMap[calcItem[x]]) {

			triggerfunctionsMap[calcItem[x]](calcLoss[x], calcItem[x], calcText[x],calWinLoss[x],calNameTag[x]);

		}
	}
	
	
	

	let outsideSortedTableContainer = outsideDetailTable_sorted();

	
	container.appendChild(outsideSortedTableContainer);
	


	return container;
}

function createDetailedTable(id,tableTitle="FIX") {



	// Create table
	const table = document.createElement('table');
	table.setAttribute('id', id);
	table.classList.add('trigger-watch-table');

	// Table Title
	const headerTitle = table.insertRow();
	const headerCell = document.createElement('th');
	headerCell.textContent = `Watch  -   `+tableTitle;
	headerCell.colSpan = 3; 
	headerCell.style.textAlign = 'center';
	headerCell.style.color = 'brown';
	headerTitle.appendChild(headerCell);

	// Create header row
	const headerRow = table.insertRow();
	const headers = ['Tag','W/L','Count', 'Item', 'Bet'];
	headers.forEach(headerText => {
		let headerCell = document.createElement('th');
		headerCell.textContent = headerText;
		headerRow.appendChild(headerCell);
	});

	
	return table;

}

function outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag) {


	watch_id.push(id);
	watch_nameTag.push(nameTag);
	watch_loss.push(loss);
	watch_highlight_stack.push(highlightFunction);

	var id = id;
	var item = item;
	var detail = detail;

	var sets = numberGroups;

	sets.forEach((set, index) => {
		let counter = 0; // Initialize counter for each set
		numbers.forEach(number => {
			if(winLoss=="L")
			{
				// If the number is in the set, reset counter to 0
				if (set.includes(number)) {
					counter = 0;
				} else {
					// If the number is not in the set, increment the counter
					counter += 1;
				}
			}
			else
			{
				// If the number is in the set, reset counter to 0
				if (!set.includes(number)) {
					counter = 0;
				} else {
					// If the number is not in the set, increment the counter
					counter += 1;
				}
			}

		});

		watchWinLoss.push(winLoss);
		watch_count.push(counter);
		watchCounter.push(counter + " / " + loss);
		watchItem.push(item);
		watchItemDetail.push(detail);


	});


}
function uniqueDetailTable(loss, item, detail, id, numberGroups, highlightFunction, nameTag) {


	watch_id.push(id);
	watch_nameTag.push(nameTag);
	watch_loss.push(loss);
	watch_highlight_stack.push(highlightFunction);


	var item = item;
	var detail = detail;

	var sets = numberGroups;

	sets.forEach((set, index) => {
		let counter = 0; // Initialize counter for each set
		counter = set.length;

		watchWinLoss.push("-");
		watch_count.push(counter);
		watchCounter.push(counter + " / " + loss);
		watchItem.push(item);
		watchItemDetail.push(detail);

	});

	
}

function uniquePatternTable(loss, item, detail, id, betPlacement, highlightFunction,nameTag){
	

	watch_id.push(id);
	watch_nameTag.push(nameTag);
	watch_loss.push(loss);
	watch_highlight_stack.push(highlightFunction);

	var item = item;
	var detail = detail;
	
	let counter = 0; // Initialize counter for each set
	watchWinLoss.push("-");
	
	watch_count.push(counter);
	watchCounter.push("Pattern");
	watchItem.push(item);
	watchItemDetail.push(betPlacement);

	
}


function outsideDetailTable_sorted()
{
	let untoggle = true;

	let container = createAndClearBlankDiv('outside-detail-table-container');


	let indexedMap = watch_count.map((value, index) => ({ value, index }));
	indexedMap.sort((a, b) => b.value - a.value);
	let sortedIndexes = indexedMap.map(item => item.index);

	sortedIndexes.forEach((value, index) => {

		
		let table = container.querySelector(`#${CSS.escape(watch_id[value])}`);

		if (!table) {
			table = createDetailedTable(watch_id[value],watch_id[value]);
			if(!(watch_id[value]==="Streets 11:1"))
			{
				untoggle = false;
			}
			if(!(watch_id[value]==="Splits 17:1"))
			{
				if(isButtonOn())
					{	
						makeElementDraggable(table);
					}
			}
			if((watch_id[value]==="Streets 11:1 "))
				{
					
						
						const button = document.createElement('button');
						button.innerText = 'Toggle Rows 3,4,5';
						button.onclick = function () {
							if(toggle345)
							{
								toggle345 = false;
							}
							else
							{
								toggle345 = true;
							}
							showStreets345();

						};
						table.appendChild(button);

					
				}
			container.appendChild(table);
		}

		const newRow = table.insertRow();
		const cellTag = newRow.insertCell();


		cellTag.textContent = watch_nameTag[value];
					const cellButton = newRow.insertCell();
			cellButton.style.verticalAlign = "bottom";
		//const cell0 = newRow.insertCell();
		const cell1 = newRow.insertCell();
		const cell2 = newRow.insertCell();
		cell2.style.whiteSpace = "pre-line"; 
		const cell3 = newRow.insertCell();

					const button = document.createElement('button');
			button.textContent = watchWinLoss[value];
			button.onclick = () => { 
				setChips(watchItemDetail[value],watch_nameTag[value]);
			 };
			cellButton.appendChild(button);


		//cell0.textContent = watchWinLoss[value];
		cell1.textContent = watchCounter[value];
		cell2.textContent = watchItem[value];
		cell3.textContent = watchItemDetail[value];
	/*	if(watch_id[value]==="Streets 11:1 ")
			{
			
				streets345.push(watchItemDetail[value]);
			}
*/

			        // Add details to streets345 array if watch_id is "Streets 11:1"
					if (watch_id[value] === "Streets 11:1 ") {
						streets345.push(watchItemDetail[value]);

			
					
						
					}
	

		if (watch_count[value] >= watch_loss[value]) {

			alert_nameTag.push(watch_nameTag[value]);
			alertId.push(watch_id[value]);
			alertWinLoss.push(watchWinLoss[value]);
			alertHighLightStack.push(watch_highlight_stack[value]);
			alertCounter.push(watchCounter[value]);
			alertItem.push(watchItem[value]);
			alertItemDetail.push(watchItemDetail[value]);

		}
	});

	if(untoggle)
	{
		
		toggle345 = false;
		street345_remove_all();
	}
	return container;
}

function detailEven(loss, item, text, winLoss,nameTag) {

	var id = 'Evens 1:1';
	var item = 'Even';
	var detail = 'Even';

	var numberGroups = [[2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36]];

	var highlightFunction = highlight_Even;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);


}

function detailOdd(loss, item, text, winLoss,nameTag)  {

	var id = 'Evens 1:1';
	var item = 'Odd';
	var detail = 'Odd';

	var numberGroups = [[1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35]];

	var highlightFunction = highlight_Odd;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}
function detailRed(loss, item, text,  winLoss, nameTag) {

	var id = 'Evens 1:1';
	var item = 'Red';
	var detail = 'Red';

	var numberGroups = [numRed];

	var highlightFunction = highlight_Red;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}
function detailBlack(loss, item, text, winLoss, nameTag) {

	var id = 'Evens 1:1';
	var item = 'Black';
	var detail = 'Black';

	var numberGroups = [numBlack];

	var highlightFunction = highlight_Black;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss, nameTag);
}
function detailHigh(loss, item, text, winLoss,nameTag) {

	var id = 'Evens 1:1';
	var item = 'High';
	var detail = 'High';

	var numberGroups = [[19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36]];

	var highlightFunction = highlight_high;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);

}
function detailLow(loss, item, text, winLoss,nameTag) {

	var id = 'Evens 1:1';
	var item = 'Low';
	var detail = 'Low';

	var numberGroups = [[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18]];

	var highlightFunction = highlight_low;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}

function detailDozen1(loss, item, text, winLoss,nameTag) {
	var id = 'Dozens 2:1';
	var item = 'Dozen 1 (1-12)';
	var detail = 'Dozen 1 (1-12)';

	var numberGroups = [[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]];

	var highlightFunction = highlight_dozen_1;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}
function detailDozen2(loss, item, text, winLoss,nameTag) {
	var id = 'Dozens 2:1';
	var item = 'Dozen 2 (13-24)';
	var detail = 'Dozen 2 (13-24)';

	var numberGroups = [[13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24]];

	var highlightFunction = highlight_dozen_2;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}
function detailDozen3(loss, item, text, winLoss,nameTag) {
	var id = 'Dozens 2:1';
	var item = 'Dozen 3 (25-36)';
	var detail = 'Dozen 3 (25-36)';

	var numberGroups = [[25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36]];

	var highlightFunction = highlight_dozen_3;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}
function detailRow1(loss, item, text, winLoss,nameTag) {

	var id = 'Dozens 2:1';
	var item = 'Row 1 (1,4,7...)';
	var detail = 'Row 1 (1,4,7...)';

	var numberGroups = [[1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34]];

	var highlightFunction = highlight_row_1;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);

}
function detailRow2(loss, item, text, winLoss,nameTag) {

	var id = 'Dozens 2:1';
	var item = 'Row 2 (2,5,8...)';
	var detail = 'Row 2 (2,5,8...)';

	var numberGroups = [[2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35]];

	var highlightFunction = highlight_row_2;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);

}
function detailRow3(loss, item, text, winLoss,nameTag) {
	var id = 'Dozens 2:1';
	var item = 'Row 3 (3,6,9...)';
	var detail = 'Row 3 (3,6,9...)';

	var numberGroups = [[3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36]];

	var highlightFunction = highlight_row_3;

	outsideDetailTable(loss, item, detail, id, numberGroups, highlightFunction, winLoss,nameTag);
}

function detailQuads(loss, item, text, winLoss,nameTag) {

	var id = 'Corners 8:1';

	var numberGroups = [
		[1, 2, 4, 5], [2, 3, 5, 6],
		[4, 5, 7, 8], [5, 6, 8, 9],
		[7, 8, 10, 11], [8, 9, 11, 12],
		[10, 11, 13, 14], [11, 12, 14, 15],
		[13, 14, 16, 17], [14, 15, 17, 18],
		[16, 17, 19, 20], [17, 18, 20, 21],
		[19, 20, 22, 23], [20, 21, 23, 24],
		[22, 23, 25, 26], [23, 24, 26, 27],
		[25, 26, 28, 29], [26, 27, 29, 30],
		[28, 29, 31, 32], [29, 30, 32, 33],
		[31, 32, 34, 35], [32, 33, 35, 36]
	];

	var highlightFunction = highlight_quad;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Corner';
		var detail = set;

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});

}
function detailSplits(loss, item, text, winLoss,nameTag) {
	var id = 'Splits 17:1';

	// Splits
	var numberGroups = [
		[1, 2], [2, 3], 
		[4, 5], [5, 6], 
		[7, 8], [8, 9], 
		[10, 11], [11, 12],
		[13, 14], [14, 15], 
		[16, 17], [17, 18], 
		[19, 20], [20, 21], 
		[22, 23], [23, 24],
		[25, 26], [26, 27], 
		[28, 29], [29, 30], 
		[31, 32], [32, 33], 
		[34, 35], [35, 36]];


	var highlightFunction = highlight_split_down;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Split';
		var detail = set;

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});


	var numberGroups = [
		[1, 4], [4, 7], [7, 10], [10, 13], [13, 16], [16, 19], [19, 22], [22, 25], [25, 28], [28, 31], [31, 34],
		[2, 5], [5, 8], [8, 11], [11, 14], [14, 17], [17, 20], [20, 23], [23, 26], [26, 29], [29, 32], [32, 35],
		[3, 6], [6, 9], [9, 12], [12, 15], [15, 18], [18, 21], [21, 24], [24, 27], [27, 30], [30, 33], [33, 36]];

	var highlightFunction = highlight_split_across;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Split';
		var detail = set;

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});
}
function detailStreets(loss, item, text, winLoss,nameTag) {
	var id = 'Streets 11:1 ';

	var numberGroups = [
		[1, 2, 3],
		[4, 5, 6],
		[7, 8, 9],
		[10, 11, 12],
		[13, 14, 15],
		[16, 17, 18],
		[19, 20, 21],
		[22, 23, 24],
		[25, 26, 27],
		[28, 29, 30],
		[31, 32, 33],
		[34, 35, 36]];

	var highlightFunction = highlight_street;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Street';
		var detail = set;

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});
}
function detailDoubleStreet(loss, item, text, winLoss,nameTag) {
	var id = 'Lines 5:1';

	var numberGroups = [
		[1, 2, 3, 4, 5, 6],
		[4, 5, 6, 7, 8, 9],
		[7, 8, 9, 10, 11, 12],
		[10, 11, 12, 13, 14, 15],
		[13, 14, 15, 16, 17, 18],
		[16, 17, 18, 19, 20, 21],
		[19, 20, 21, 22, 23, 24],
		[22, 23, 24, 25, 26, 27],
		[25, 26, 27, 28, 29, 30],
		[28, 29, 30, 31, 32, 33],
		[31, 32, 33, 34, 35, 36]];

	var highlightFunction = highlight_double_street;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Lines';
		var detail = set;

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});
}
function detailStraightNumbers(loss, item, text, winLoss,nameTag) {
	var id = 'Straights 35:1';

	var numberGroups = [
		[0], [1], [2], [3], [4], [5], [6], [7], [8], [9], [10],
		[11], [12], [13], [14], [15], [16], [17], [18], [19], [20],
		[21], [22], [23], [24], [25], [26], [27], [28], [29], [30],
		[31], [32], [33], [34], [35], [36]];

	var highlightFunction = highlight_straight_numbers;

	numberGroups.forEach(set => {

		var setNumbers = [set];
		var item = 'Straight';
		var detail = set;
		nameTag = "Straight"

		outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

	});
}

function detailUniques(loss, item, text,  winLoss, nameTag) {


	var id = 'Uniques';

	var uniqueNumbers = [];
	for (let i = numbers.length - 1; i >= 0; i--) {
		let number = numbers[i];
		if (uniqueNumbers.indexOf(number) !== -1) {
			break;
		} else {
			uniqueNumbers.push(number);
		}
	}

	let detail_arr = uniqueNumbers.map(item => parseInt(item, 10));

	var highlightFunction = highlight_uniques;
	var setNumbers = [uniqueNumbers];
	var item = 'Uniques';
	var detail = detail_arr;

	uniqueDetailTable(loss, item, detail, id, setNumbers, highlightFunction,nameTag);

	
}


function detailGroups(loss, item, text, winLoss,nameTag) {

	var id = 'Groups';

	var arr = text.split(',')

	arr = arr.map(item => parseInt(item, 10));

	var highlightFunction = highlight_number_groups;
	var setNumbers = [arr];
	var item = 'Group';
	var detail = arr;

	outsideDetailTable(loss, item, detail, id, setNumbers, highlightFunction, winLoss,nameTag);

}


function detailPattern(loss, item, detail,winLoss,nameTag) {



	var id = getIdForPatternTable(detail);

	let arrayTotal = getNumbersForPatterns(detail);



	
	

	
	var item = item;
	var highlightFunction = null;





	// ----------------------------------------------  RED / BLACK
	//  RED / BLACK
	// --------------------------------------------------------------
	// Map to Red/Black

	let redBlackResults = arrayTotal.map(subArray => mapToRB(subArray));

	// Display Red/Black Map
	var textView = "";
	redBlackResults.forEach((item, index)=>{
		textView += item;
		if (index < arrayTotal.length - 1) {
			textView += "\n";
		}
	});

	// Check if Red/Black elements are all equal
	const areAllArraysEqual = redBlackResults.every(array => 
		JSON.stringify(array) === JSON.stringify(redBlackResults[0]));
	
	// Determine what to bet if all elments are equal for R/B check.
	var textContent = "";
	if (areAllArraysEqual) {
		let firstElement = redBlackResults[redBlackResults.length - 1][0];
		if (firstElement === 'B') {
			textContent = "Red";
			highlightFunction = highlight_pattern_red;
		} else if (firstElement === 'R') {
			textContent = "Black";
			highlightFunction = highlight_pattern_black;
		}
	}

	// Alert R/B
	if(highlightFunction !== null)
	{	
		alert_nameTag.push(nameTag);
			alertId.push(id);
			alertHighLightStack.push(highlightFunction);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent);
	}
	uniquePatternTable(10, textView, detail, id, textContent, highlightFunction,nameTag);
	// -------------------------------------------- EVEN / ODD
	//  EVEN / ODD
	// --------------------------------------------------------------

	// Map numbers
	let results_EO = arrayTotal.map(subArray => mapToEO(subArray));

	// Display Map
	var textView = "";
	results_EO.forEach((item, index)=>{
		textView += item;
		if (index < arrayTotal.length - 1) {
			textView += "\n";
		}
	});

	// Check all items equal
	const equal_EO = results_EO.every(array => 
		JSON.stringify(array) === JSON.stringify(results_EO[0]));
	
	// Determine bet when triggered
	var highlightFunction = null;
	var textContent = "";
	if (equal_EO) {
		let firstElement = results_EO[results_EO.length - 1][0];
		if (firstElement === 'E') {
			textContent = "Odd";
			highlightFunction = highlight_pattern_odd;
		} else if (firstElement === 'O') {
			textContent = "Even";
			highlightFunction = highlight_pattern_even;
		}
	}

	// Alert
	if(highlightFunction !== null)
	{	
		alert_nameTag.push(nameTag);
			alertId.push(id);
			alertHighLightStack.push(highlightFunction);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent);
	}

	uniquePatternTable(10, textView, detail, id, textContent, highlightFunction,nameTag);
	// -------------------------------------------- HIGH / LOW
	//  HIGH / LOW
	// --------------------------------------------------------------

	// Map numbers
	let results_HL = arrayTotal.map(subArray => mapToHL(subArray));

	// Display Map
	var textView = "";
	results_HL.forEach((item, index)=>{
		textView += item;
		if (index < arrayTotal.length - 1) {
			textView += "\n";
		}
	});

	// Check all items equal
	const equal_HL = results_HL.every(array => 
		JSON.stringify(array) === JSON.stringify(results_HL[0]));
	
	// Determine bet when triggered
	var highlightFunction = null;
	var textContent = "";
	if (equal_HL) {
		let firstElement = results_HL[results_HL.length - 1][0];
		if (firstElement === 'H') {
			textContent = "Low";
			highlightFunction = highlight_pattern_low;
		} else if (firstElement === 'L') {
			textContent = "High";
			highlightFunction = highlight_pattern_high;
		}
	}

	// Alert
	if(highlightFunction !== null)
	{	
		alert_nameTag.push(nameTag);
			alertId.push(id);
			alertHighLightStack.push(highlightFunction);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent);
	}

	uniquePatternTable(10, textView, detail, id, textContent, highlightFunction,nameTag);
	// -------------------------------------------- DOZENS 
	//  DOZENS
	// --------------------------------------------------------------

	// Map numbers
	let results_D1 = arrayTotal.map(subArray => mapToD1(subArray));

	// Display Map
	var textView = "";
	results_D1.forEach((item, index)=>{
		textView += item;
		if (index < arrayTotal.length - 1) {
			textView += "\n";
		}
	});


	// Check all items equal
	const equal_D1 = results_D1.every(array => 
		JSON.stringify(array) === JSON.stringify(results_D1[0]));
	
	// Determine bet when triggered
	var highlightFunction1 = null;
	var highlightFunction2 = null;
	var textContent1 = "";
	var textContent2 = "";
	if (equal_D1) {
		let firstElement = results_D1[results_D1.length - 1][0];
		if (firstElement === 'D1') {
			textContent1 = "Dozen 2";
			textContent2 = "Dozen 3";
			highlightFunction1 = highlight_pattern_dozen_2;
			highlightFunction2 = highlight_pattern_dozen_3;
		}
		if (firstElement === 'D2') {
			textContent1 = "Dozen 1";
			textContent2 = "Dozen 3";
			highlightFunction1 = highlight_pattern_dozen_1;
			highlightFunction2 = highlight_pattern_dozen_3;
		}
		if (firstElement === 'D3') {
			textContent1 = "Dozen 1";
			textContent2 = "Dozen 2";
			highlightFunction1 = highlight_pattern_dozen_1;
			highlightFunction2 = highlight_pattern_dozen_2;
		}

	}


	// Alert
	if(highlightFunction1 !== null)
	{	
			alertId.push(id);
			alert_nameTag.push(nameTag);
			alertHighLightStack.push(highlightFunction1);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent1);

            alertId.push(id);
			alert_nameTag.push(nameTag);
			alertHighLightStack.push(highlightFunction2);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent2);
	}
	uniquePatternTable(10, textView, detail, id, textContent1, highlightFunction1,nameTag);
	uniquePatternTable(10, textView, detail, id, textContent2, highlightFunction2,nameTag);

	// -------------------------------------------- ROWS
	//  ROWS
	// --------------------------------------------------------------

	// Map numbers
	let results_R1 = arrayTotal.map(subArray => mapToR1(subArray));

	// Display Map
	var textView = "";
	results_R1.forEach((item, index)=>{
		textView += item;
		if (index < arrayTotal.length - 1) {
			textView += "\n";
		}
	});
	//uniquePatternTable(10, textView, detail, id, textContent2);

	// Check all items equal
	const equal_R1 = results_R1.every(array => 
		JSON.stringify(array) === JSON.stringify(results_R1[0]));
	
	// Determine bet when triggered
	var highlightFunction1 = null;
	var highlightFunction2 = null;
	var textContent1 = "";
	var textContent2 = "";
	if (equal_R1) {
		let firstElement = results_R1[results_R1.length - 1][0];
		if (firstElement === 'R1') {
			textContent1 = "Row 2";
			textContent2 = "Row 3";
			highlightFunction1 = highlight_pattern_row_2;
			highlightFunction2 = highlight_pattern_row_3;
		}
		if (firstElement === 'R2') {
			textContent1 = "Row 1";
			textContent2 = "Row 3";
			highlightFunction1 = highlight_pattern_row_1;
			highlightFunction2 = highlight_pattern_row_3;
		}
		if (firstElement === 'R3') {
			textContent1 = "Row 1";
			textContent2 = "Row 2";
			highlightFunction1 = highlight_pattern_row_1;
			highlightFunction2 = highlight_pattern_row_2;
		}

	}


	// Alert
	if(highlightFunction1 !== null)
	{	
		alert_nameTag.push(nameTag);
			alertId.push(id);
			alertHighLightStack.push(highlightFunction1);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent1);

			alert_nameTag.push(nameTag);
            alertId.push(id);
			alertHighLightStack.push(highlightFunction2);
			alertWinLoss.push("-");
			alertCounter.push('Pattern');
			alertItem.push(textView);
			alertItemDetail.push(textContent2);
	}
	uniquePatternTable(10, textView, detail, id, textContent1, highlightFunction1,nameTag);
	uniquePatternTable(10, textView, detail, id, textContent2, highlightFunction2,nameTag);
	
}

function showStreets345() {
    highlight_street345_remove();

    let table = document.getElementById('Streets 11:1 ');
    if (table) {
        table.rows[4].style.backgroundColor = '#d0d6ce';
        table.rows[5].style.backgroundColor = '#d0d6ce';
        table.rows[6].style.backgroundColor = '#d0d6ce';
    }

    if (toggle345) {
        if (table) {
            table.rows[4].style.backgroundColor = 'yellow';
            table.rows[5].style.backgroundColor = 'yellow';
            table.rows[6].style.backgroundColor = 'yellow';
        }

        streets345.slice(2, 5).forEach(group => {
            var stringId = group.join(`, `);
            highlight_street345(stringId);
        });
    }
}
function street345_remove_all() { 
    var classItem = 'hilight-street345';
    const streets = [
        '1, 2, 3', '4, 5, 6', '7, 8, 9', '10, 11, 12', '13, 14, 15', 
        '16, 17, 18', '19, 20, 21', '22, 23, 24', '25, 26, 27', 
        '28, 29, 30', '31, 32, 33', '34, 35, 36'
    ];

    // Loop through each street
    streets.forEach(street => {
        // Replace commas with spaces or another format if that's how your data-values attribute stores it
        const streetString = street;

        // Select the element with data-values matching the street
        const specificElement = document.querySelector(`[data-values="${streetString}"]`);
        
        if (specificElement) {
            specificElement.classList.remove(classItem);
        } 
    });
}

function highlight_street345_remove() {
    var classItem = 'hilight-street345';
    streets345.forEach(item => {
        var stringId = item.join(`, `); // Ensure the format matches

        const specificElement = document.querySelector(`[data-values="${stringId}"]`);
        if (specificElement) {
            specificElement.classList.remove(classItem);
        } 
    });
}

function highlight_street345(item) {
    var classItem = 'hilight-street345';

    const specificElement = document.querySelector(`[data-values="${item}"]`);

    if (specificElement !== null) {

        specificElement.classList.add(classItem);
    } 
}
