
function applyStyles(element, styleObj) {
	if(styleObj)
	{
		Object.keys(styleObj).forEach(key => {
			element.style[key] = styleObj[key];
		});
	}
  
  }

  function processBulkNumbers_api(input) {
    var cleanedInput;
	wheelType = 37;
    if (wheelType == 38) {
       
        cleanedInput = input
            .replace(/\s+/g, " ") // Normalize spaces
            .replace(/,|\.|\s+/g, ",") // Replace delimiters with a comma
            .split(",") // Split into an array
            .map(item => {
                if (item === "00") return 37; // Replace "00" with 38
                let num = parseInt(item, 10); // Convert to a number
                return isNaN(num) || num < 0 || num > 37 ? null : num; // Retain only valid numbers
            })
            .filter(item => item !== null); // Remove invalid entries
    } else {
      
        cleanedInput = input
            .replace(/\s+/g, " ") // Normalize spaces
            .replace(/,|\.|\s+/g, ",") // Replace delimiters with a comma
            .split(",") // Split into an array
            .map(item => {
                if (item === "00") return 0; // Replace "00" with 37
                if (item === "37") return 0; // Replace "38" with 37
                let num = parseInt(item, 10); // Convert to a number
                return isNaN(num) || num < 0 || num > 37 ? null : num; // Retain only valid numbers
            })
            .filter(item => item !== null); // Remove invalid entries
    }


    return cleanedInput;
}


function ensureRouletteNumber(textboxValue)
{
	let num = Number(textboxValue);

    if (isNaN(num) || num >= 37 || num <= 0) {
	
        return 0;
    }

    return num;
}

function ensureInputValue(textBoxValue, defaultValue, lessThan=0, greaterThan = 1000000) {
   
    let num = Number(textBoxValue);

    if (isNaN(num) || num >= greaterThan || num <= lessThan) {
	
        return defaultValue;
    }

    return num;
}

function createAndClearBlankDiv(id)
{
    let container = document.getElementById(id);

	if(container){
		container.remove();
		container = document.createElement('div');
		container.id = id;
	}
	else{
		container = document.createElement('div');
		container.id = id;
	}

	return container;
}

function get_TriggerCode()
{
	let data = document.getElementById('trigger-code');
	data.value = '';
	for(var x=0; x<triggerListLoss.length; x++)
	{
		data.value += triggerListWinLoss[x]+":"+triggerListLoss[x]+":"+triggerListItem[x]+":"+triggerListText[x]+";\n";
	}
	
}
function setTriggerCode()
{

	triggerCode = '';
	for(var x=0; x<triggerListLoss.length; x++)
	{
		triggerCode += triggerListWinLoss[x]+":"+triggerListLoss[x]+":"+triggerListItem[x]+":"+triggerListText[x]+";\n";
	}
	
}

function processValue(input) {
 
    var groups = input.split('-');

    var result = groups.map(group => {

        var cleanedGroup = group.replace(/\s+/g, "").replace(/\./g, ",").replace(/[^0-9,]/g, "");
        
        var numbers = [...new Set(cleanedGroup.split(',')
                       .map(number => parseInt(number, 10))
                       .filter(number => !isNaN(number) && number >= 0 && number <= 36))];

        return numbers;
    }).filter(group => group.length > 0); 

    return result;
}

function isInRed(num) {
	return numRed.includes(num) ? 'R' : num==0? '-': 'B';
}
function mapToRB(subArray) {
	return subArray.map(num => isInRed(num));
}
function isEO(num) {
	return num % 2 === 1 ? 'O' : num==0? '-': 'E';
}

function mapToEO(subArray) {
	return subArray.map(num => isEO(num));
}
function isHL(num) {
	return num >18 ? 'H' : num==0? '-': 'L';
}

function mapToHL(subArray) {
	return subArray.map(num => isHL(num));
}
function isD1(num) {
	var item = "-";
	if(num>=1 && num<=12)
	{
		item = "D1";
	}
	if(num>=13 && num<=24)
	{
		item = "D2";
	}
	if(num>=25 && num<=36)
	{
		item = "D3";
	}
	return item;
}

function mapToD1(subArray) {
	return subArray.map(num => isD1(num));
}
function isR1(num) {
	var r1 = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];
	var r2 = [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35];
	var r3 = [3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36];
	var item = "-";
	if(r1.includes(num))
	{
		item = "R1";
	}
	if(r2.includes(num))
	{
		item = "R2";
	}
	if(r3.includes(num))
	{
		item = "R3";
	}
	return item;
}

function mapToR1(subArray) {
	return subArray.map(num => isR1(num));
}

function getNumbersForPatterns(text){

	let parts = text.split(" ");
	let patternLength = parseInt(parts[0], 10);
	let patternMultiplier = parseInt(parts[2], 10);
	let patternLookback = patternLength * patternMultiplier;
	
	
	// Get array pattern
	let relevantPortion = numbers.slice(-patternLookback);
	let arrayTotal = [];
	for (let i = 0; i < patternMultiplier; i++) {
	  let start = i * patternLength;
	  let chunk = relevantPortion.slice(start, start + patternLength);
	  arrayTotal.push(chunk);
	}
	return arrayTotal;
}
function getIdForPatternTable(text)
{
	let parts = text.split(" ");
	let patternLength = parseInt(parts[0], 10);
	let patternMultiplier = parseInt(parts[2], 10);
	return ``+patternLength+` x ` + patternMultiplier;

}

function three_box_input_and_button(inputBoxId, inputBoxSize, buttonId, buttonIdAll, checkboxId, inputLabel, buttonLabel, checkboxLabel, spanId, spanText,checkBoxChecked) {
    let container = document.createElement('div');
    
    // Input box
    let inputBox = document.createElement('input');
    inputBox.id = inputBoxId;
    inputBox.type = 'text';
	inputBox.style.fontSize = '37px';
	inputBox.style.width = '225px';
	inputBox.setAttribute('type', 'tel');
	inputBox.setAttribute('id', 'freq-inputbox');
	inputBox.setAttribute('pattern', '[0-9]*');
	inputBox.setAttribute('inputmode', 'numeric');
	inputBox.setAttribute('placeholder', '37');
    container.appendChild(inputBox);
    
    // Button 1
    let button1 = document.createElement('button');
    button1.id = buttonId;
    button1.textContent = buttonLabel;
	button1.style = 'width: 150px; height: 50px; margin: 5px 10px 5px 10px; font-size: 30px;';
    container.appendChild(button1);

    // Button 2
    let button2 = document.createElement('button');
    button2.id = buttonIdAll;
    button2.textContent = 'All';
	button2.style = 'width: 150px; height: 50px; margin: 5px 10px 5px 10px; font-size: 30px;';
    container.appendChild(button2);

    // Checkbox
    let checkbox = document.createElement('input');
    checkbox.id = checkboxId;
    checkbox.type = 'checkbox';
	checkbox.style.transform = 'scale(4)';
	checkbox.style.marginRight = '20px';
	checkbox.style.marginLeft = '40px';
	checkbox.style.marginTop = '-10px';
	if(checkBoxChecked)
	{
		checkbox.checked = true;
	}
    container.appendChild(checkbox);



    // Labels
    let label1 = document.createElement('label');
    label1.textContent = 'Highlight';
	label1.style.fontSize = '35px';
	label1.style.marginLeft = '10px';
    label1.setAttribute('for', checkboxId);
    container.appendChild(label1);

    return { container, buttons: { button1, button2 }, checkbox };
}

function two_box_input_and_button(textboxId, pHolder, button1Id, button2Id,  button1Text, button2Text, spanId, marginLeft){

	/* Attach On click
	
		var updateButtonEvens = document.getElementById('update_button_id_stats_table_evens');
		if (updateButtonEvens) { updateButtonEvens.onclick = calc_Evens; }

	*/

	let container = document.createElement('div');

	const textBox = document.createElement('input');
    textBox.setAttribute('type', 'text');
    textBox.setAttribute('placeholder', pHolder);
    textBox.style.padding = '10px';
    textBox.style.marginLeft = marginLeft;
    textBox.style.borderRadius = '4px';
    textBox.style.border = '1px solid #ccc';
    textBox.style.width = '100px';
    textBox.id = textboxId;
    container.appendChild(textBox);


    var button1 = document.createElement('button');
    button1.textContent = button1Text;
    button1.style.padding = '8px 10px';
    button1.style.fontSize = '14px';
    button1.style.margin = '5px';
    button1.style.width = '100px';
    button1.id = button1Id;
    container.appendChild(button1);

	var button2 = document.createElement('button');
    button2.textContent = button2Text;
    button2.style.padding = '8px 10px';
    button2.style.fontSize = '14px';
    button2.style.margin = '5px';
    button2.style.width = '100px';
    button2.id = button2Id;
    container.appendChild(button2);

    var overSpins = document.createElement('span');
    overSpins.id = spanId;
	overSpins.innerHTML = '';
    container.appendChild(overSpins);
	return  {
        container,
        buttons: {
            button1: button1, 
            button2: button2 
        }
	};
}

function getStyledNumbed(n)
{
	let item = document.createElement('div');
		var colourClass = numRed.includes(n) ? ' historyRed' : ' historyBlack';
		if (n == 0) colourClass = ' historyGreen';

		item.setAttribute('class', 'nbnHistory' + colourClass);
		item.innerText = n;

		return item;
}


function logAllCssClassProperties(className) {

	// To call this
	//logAllCssClassProperties('outsideHighlight');
    
	// An object to store all styles for the class
    let styles = {};

    // Get all stylesheets on the page
    const stylesheets = document.styleSheets;

    // Iterate through each stylesheet
    for (let i = 0; i < stylesheets.length; i++) {
        const rules = stylesheets[i].rules || stylesheets[i].cssRules;

        // Iterate through each rule in the stylesheet
        for (let j = 0; j < rules.length; j++) {
            const rule = rules[j];

            // Check if the rule is a style rule and matches the class name
            if (rule.selectorText && rule.selectorText.split(',').includes('.' + className)) {
                
                // Iterate through all properties in the rule
                for (let k = 0; k < rule.style.length; k++) {
                    const propName = rule.style[k];
                    styles[propName] = rule.style[propName];
                }
            }
        }
    }

    // Log all collected styles
    return styles;
}

function injectSharedResponsiveStyles(targetId) {
    const style = document.createElement('style');
    style.textContent = `
        #${targetId} {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            padding: 10px;
            width: calc(100% - 150px);
            box-sizing: border-box;
            background-color: lightgrey;
        }

        #${targetId} button {
            flex: 1 1 auto;
            min-width: 140px;
            max-width: calc(33% - 20px);
            width: 150px;
            height: 50px;
            font-size: 24px;
        }

       
    `;
    document.head.appendChild(style);
}
