
  document.addEventListener('DOMContentLoaded', function () {
    const footerAd = document.getElementById('footerAd');
    footerAd.innerHTML = '<div id="notes-include"></div>';

    // Assuming this script runs after the footerAd is set
    document.getElementById('notes-include').addEventListener('elementAdded', fetchAndInsertNotes);
    
    // Dispatch an event to indicate the element has been added
    var event = new Event('elementAdded');
    document.getElementById('notes-include').dispatchEvent(event);
  });

  function fetchAndInsertNotes() {
    fetch('notes_2.html')
      .then(response => {
        if (!response.ok) {
          throw new Error('Network response was not ok');
        }
        return response.text();
      })
      .then(html => {
        const container = document.getElementById('notes-include');
        if (container) {
          container.innerHTML = html;
        } else {
          console.error('Container element not found');
        }
      })
      .catch(err => console.error('Failed to load notes:', err));
  }
