const buttonStateSubMore = {
    'sub-more-buttonBar-button-1': false,
    'sub-more-buttonBar-button-2': false,
    'sub-more-buttonBar-button-3': false,
    'sub-more-buttonBar-button-4': false,
    'sub-more-buttonBar-button-5': false,
};

function addButtonsToButtonBar_sub_more() {

    makeButtonForButtonBar_sub_more("1", "Missed", allMissed);
    makeButtonForButtonBar_sub_more("2", "Pattern", getPattern);
    makeButtonForButtonBar_sub_more("3", "Sleepers", navigateFrequencyBuild);
    makeButtonForButtonBar_sub_more("4", "Bouncy", bounce);
    makeButtonForButtonBar_sub_more("5", "Combo", combo);

    injectSharedResponsiveStyles("more-sub-button-bar");
}

function clickFirstButton_sub_more() {
    // This function finds the first button and clicks it
    const firstButton = document.getElementById('sub-more-buttonBar-button-1');
    if (firstButton) {
        firstButton.click();
    }
}

function makeButtonForButtonBar_sub_more(id, title, functionCall) {
    const button = document.createElement('button');
    button.id = `sub-more-buttonBar-button-${id}`;
    button.textContent = title;
button.className = 'sub-more-button-bar-button';


    
    
    button.onclick = () => {
        untoggleButtonBarButtons(); 
        buttonBarContents_sub_more(id, functionCall); 
    };

    document.getElementById('more-sub-button-bar').appendChild(button);
    buttonStateSub[button.id] = false;
}



function toggleButton_sub_more(buttonId) {
    // Reset all buttons first
    console.log("Sub Button ID");
    console.log(buttonId)
    resetOtherButtons_sub_more(buttonId);
    // Toggle the clicked button
    buttonStateSub[buttonId] = true;
    const button = document.getElementById(buttonId);
    button.style.backgroundColor = 'lightgreen';
}

function resetOtherButtons_sub_more(exceptId) {
    // Iterate over all button states and reset except the one that is clicked
    Object.keys(buttonStateSub).forEach(id => {
        if (id !== exceptId) {
            buttonStateSub[id] = false;
            const button = document.getElementById(id);
            button.style.backgroundColor = '';
        }
    });
}

function hideAllContentDivsExcept_sub_more(exceptId) {
    Object.keys(buttonStateSub).forEach(id => {
        let contentDiv = document.getElementById(`sub-more-button-bar-div-${id.slice(-1)}`);
        if (contentDiv && id !== `sub-more-buttonBar-button-${exceptId}`) {
            contentDiv.style.display = 'none';
        }
    });
}

function buttonBarContents_sub_more(id, functionCall) {
/*
    if(id == 1)
    {
        bottom.hidden = true;
    }
    else
    {
        bottom.hidden = false;  
    }
  */  
    const buttonId = `sub-more-buttonBar-button-${id}`;
    toggleButton_sub_more(buttonId);

    hideAllContentDivsExcept_sub_more(id);

    let contentDiv = document.getElementById(`sub-more-button-bar-div-${id}`);

    if (buttonStateSub[buttonId]) {
        if (!contentDiv) {
            contentDiv = document.createElement('div');
            contentDiv.id = `sub-more-button-bar-div-${id}`;
            contentDiv.style.marginBottom = '25px';
            var contents = functionCall();

            contentDiv.appendChild(contents);
            let contentsContainer = document.getElementById('button-bar-content');
            if(contentsContainer)
            {
                contentsContainer.innerHTML = '';
                contentsContainer.appendChild(contentDiv);
            }
            if (id === "4") {
                bouncyUpdate();
            }
            if (id === "5") {
                comboUpdate();
            }
        } else {
            contentDiv.style.display = '';
        }
    } else {
        if (contentDiv) {
            contentDiv.style.display = 'none';
        }
    }
}



const moreStyle = document.createElement('style');
moreStyle.textContent = `
  .sub-more-button-bar-button {
    min-width: 220px;
    min-height: 100px;
    font-size: 64px;
    font-weight: bold;
    padding: 20px 25px;
    border: 2px solid black;
    border-radius: 12px;
    background-color: #f0f0f0;
    margin: 5px;
    cursor: pointer;
    white-space: nowrap;
    flex-shrink: 0;
  }

#more-sub-button-bar{background-color:black!important;}


  @media (max-width: 600px) {
    .sub-more-button-bar-button {
      min-width: 180px;
      font-size: 44px;
      padding: 16px 20px;
    }
  }
`;
document.head.appendChild(moreStyle);

