const buttonStateSub = {
    'sub-buttonBar-button-1': false,
    'sub-buttonBar-button-2': false,
    'sub-buttonBar-button-3': false,
    'sub-buttonBar-button-4': false,
    'sub-buttonBar-button-5': false,

};

function addButtonsToButtonBar_sub() {

    makeButtonForButtonBar_sub("1", "Defined", add_trigger_defined);
    makeButtonForButtonBar_sub("2", "Group", add_trigger_groups);
    makeButtonForButtonBar_sub("3", "Uniques", add_trigger_uniques);
    makeButtonForButtonBar_sub("4", "Pattern", add_trigger_patterns);
    makeButtonForButtonBar_sub("5", "Custom", add_trigger_custom);
     injectSharedResponsiveStyles("sub-button-bar");
}
function clickFirstButton_sub() {
    // This function finds the first button and clicks it
    const firstButton = document.getElementById('sub-buttonBar-button-1');
    if (firstButton) {
        firstButton.click();
    }
}

function makeButtonForButtonBar_sub(id, title, functionCall) {
    const button = document.createElement('button');
    button.id = `sub-buttonBar-button-${id}`;
    button.textContent = title;
button.className = 'sub-button-bar-button';
    

    button.onclick = () => {
        untoggleButtonBarButtons(); 
        buttonBarContents_sub(id, functionCall); 
    };

    document.getElementById('sub-button-bar').appendChild(button);
    buttonStateSub[button.id] = false;
}


function toggleButton_sub(buttonId) {
    // Reset all buttons first
    resetOtherButtons_sub(buttonId);
    // Toggle the clicked button
    buttonStateSub[buttonId] = true;
    const button = document.getElementById(buttonId);
    button.style.backgroundColor = 'lightgreen';
}

function resetOtherButtons_sub(exceptId) {
    // Iterate over all button states and reset except the one that is clicked
    Object.keys(buttonStateSub).forEach(id => {
        if (id !== exceptId) {
            buttonStateSub[id] = false;
            const button = document.getElementById(id);
            button.style.backgroundColor = '';
        }
    });
}

function hideAllContentDivsExcept_sub(exceptId) {
    Object.keys(buttonStateSub).forEach(id => {
        let contentDiv = document.getElementById(`sub-button-bar-div-${id.slice(-1)}`);
        if (contentDiv && id !== `sub-buttonBar-button-${exceptId}`) {
            contentDiv.style.display = 'none';
        }
    });
}

function buttonBarContents_sub(id, functionCall) {

    const buttonId = `sub-buttonBar-button-${id}`;
    toggleButton_sub(buttonId);

    hideAllContentDivsExcept_sub(id);

    let contentDiv = document.getElementById(`sub-button-bar-div-${id}`);

    if (buttonStateSub[buttonId]) {
        if (!contentDiv) {
            contentDiv = document.createElement('div');
            contentDiv.id = `sub-button-bar-div-${id}`;
            contentDiv.style.marginBottom = '25px';
            var contents = functionCall();

            contentDiv.appendChild(contents);
            let contentsContainer = document.getElementById('button-bar-content');
            if(contentsContainer)
            {
                contentsContainer.innerHTML = '';
                contentsContainer.appendChild(contentDiv);
            }

        } else {
            contentDiv.style.display = '';
        }
    } else {
        if (contentDiv) {
            contentDiv.style.display = 'none';
        }
    }
}



const subStyle = document.createElement('style');
subStyle.textContent = `
  .sub-button-bar-button {
    min-width: 200px;
    min-height: 90px;
    font-size: 60px;
    font-weight: bold;
    padding: 20px 25px;
    border: 2px solid black;
    border-radius: 10px;
    background-color: #ddd;
    margin: 5px;
    cursor: pointer;
    white-space: nowrap;
    flex-shrink: 0;
  }
  
  #sub-button-bar{background-color:black!important;}

  @media (max-width: 600px) {
    .sub-button-bar-button {
      min-width: 160px;
      font-size: 42px;
      padding: 16px 20px;
    }
  }
`;
document.head.appendChild(subStyle);
