const buttonStateSubStats = {
    'stats-buttonBar-button-1': false,
    'stats-buttonBar-button-2': false,
    'stats-buttonBar-button-3': false,
    'stats-buttonBar-button-4': false,
    'stats-buttonBar-button-5': false,

};

function add_stats_bar() {

    make_stats_button_bar_button("1", "Evens", evens_page);
    make_stats_button_bar_button("2", "Dozens", dozens_page);
    make_stats_button_bar_button("3", "Combo", combo_page);
    make_stats_button_bar_button("4", "Streets", street_page);
    make_stats_button_bar_button("5", "Lines", line_page);

    injectSharedResponsiveStyles("stats-sub-button-bar");

    
}
function stats_first_click() {
    // This function finds the first button and clicks it
    const firstButton = document.getElementById('stats-buttonBar-button-1');
    if (firstButton) {
        firstButton.click();
    }
}

function make_stats_button_bar_button(id, title, functionCall) {
   const button = document.createElement('button');
    button.id = `stats-buttonBar-button-${id}`;
    button.textContent = title;
    button.className = 'stats-sub-button-bar-button';
    
    button.onclick = () => {
        
         
        untoggleButtonBarButtons(); 
        buttonBarContents_stats(id, functionCall); 

        if(id === "1")
        {
            calc_Evens();
            stats_checkboxes();

        }
        if(id === "2")
        {
            calc_Dozens();
            stats_checkboxes();

        }
        if(id === "3")
            {
                calc_Combo();
                stats_checkboxes();
                
            }

            if(id === "4")
                {
                    calc_Street();
                    stats_checkboxes();
                    
                }

                if(id === "5")
                    {
                        calc_Line();
                        stats_checkboxes();
                        
                    }

        
    }
    document.getElementById('stats-sub-button-bar').appendChild(button);
    // Initialize the button state as false
    buttonStateSubStats[button.id] = false;
}

function toggleButton_stats(buttonId) {
    // Reset all buttons first
    reset_other_button_stats(buttonId);
    // Toggle the clicked button
    buttonStateSubStats[buttonId] = true;
    const button = document.getElementById(buttonId);
    button.style.backgroundColor = 'lightgreen';
}

function reset_other_button_stats(exceptId) {
    // Iterate over all button states and reset except the one that is clicked
    Object.keys(buttonStateSubStats).forEach(id => {
        if (id !== exceptId) {
            buttonStateSubStats[id] = false;
            const button = document.getElementById(id);
            button.style.backgroundColor = '';
        }
    });
}

function hideAllContentDivsExcept_stats(exceptId) {
    Object.keys(buttonStateSubStats).forEach(id => {
        let contentDiv = document.getElementById(`sub-button-bar-div-${id.slice(-1)}`);
        if (contentDiv && id !== `stats-buttonBar-button-${exceptId}`) {
            contentDiv.style.display = 'none';
        }
    });
}

function buttonBarContents_stats(id, functionCall) {

    const buttonId = `stats-buttonBar-button-${id}`;
    toggleButton_stats(buttonId);

    hideAllContentDivsExcept_stats(id);

    let contentDiv = document.getElementById(`sub-button-bar-div-${id}`);

    if (buttonStateSubStats[buttonId]) {
        if (!contentDiv) {
            contentDiv = document.createElement('div');
            contentDiv.id = `sub-button-bar-div-${id}`;
            contentDiv.style.marginBottom = '25px';
            var contents = functionCall();

            contentDiv.appendChild(contents);
            let contentsContainer = document.getElementById('button-bar-content');
            if(contentsContainer)
            {
                contentsContainer.innerHTML = '';
                contentsContainer.appendChild(contentDiv);
            }

        } else {
            contentDiv.style.display = '';
        }
    } else {
        if (contentDiv) {
            contentDiv.style.display = 'none';
        }
    }


}










const statsSubButtonBar = document.getElementById('stats-sub-button-bar');
if (statsSubButtonBar) {
    statsSubButtonBar.style.display = 'flex';
    statsSubButtonBar.style.overflowX = 'auto';
    statsSubButtonBar.style.padding = '10px';
    statsSubButtonBar.style.gap = '10px'; // Optional spacing
    statsSubButtonBar.style.scrollbarWidth = 'thin'; // Firefox
    statsSubButtonBar.style.webkitOverflowScrolling = 'touch'; // Smooth iOS
}


const statsStyle = document.createElement('style');
statsStyle.textContent = `
  .stats-sub-button-bar-button {
    min-width: 220px;
    min-height: 90px;
    font-size: 64px;
    font-weight: bold;
    padding: 20px 25px;
    border: 2px solid black;
    border-radius: 12px;
    background-color: #f0f0f0;
    margin: 5px;
    cursor: pointer;
    white-space: nowrap;
    flex-shrink: 0;
  }

  @media (max-width: 600px) {
    .stats-sub-button-bar-button {
      min-width: 180px;
      font-size: 44px;
      padding: 16px 20px;
    }
  }
`;
document.head.appendChild(statsStyle);
