
function getTriggerList() {

	


	let container = createAndClearBlankDiv('trigger-results-triggers-container');
	container.style.fontSize = '30px';
	container.style.paddingLeft = '100px';

	const headerTitle = document.createElement('h2');
	headerTitle.textContent = 'Trigger List';
	container.appendChild(headerTitle);

	
	if(triggerListLoss.length>0)
	{

		let table = document.getElementById('triggerItems');

		if (!table) {
		
			let trigger_display_simple = triggerPanelCreateTriggerTable();
			
			
			container.appendChild(trigger_display_simple);
	
		
			table = trigger_display_simple;
		}
		

		for (let i = 0; i < triggerListLoss.length; i++) {
			const newRow = table.insertRow(-1); 
		
			// Create and style the first cell
			const cell0 = newRow.insertCell(0); 
			cell0.textContent = triggerListWinLoss[i];
			cell0.style.border = '1px solid black';
			cell0.style.textAlign = 'center';

			// Create and style the first cell
			const cell1 = newRow.insertCell(1); 
			cell1.textContent = triggerListLoss[i];
			cell1.style.border = '1px solid black';
			cell1.style.textAlign = 'center';
		
			// Create and style the second cell
			const cell2 = newRow.insertCell(2); 
			cell2.textContent = triggerListText[i];
			cell2.style.border = '1px solid black';
			cell2.style.textAlign = 'left';
		
			// Create and style the third cell
			const cell3 = newRow.insertCell(3); 
			const removeBtn = document.createElement('button');
			style_form_button(removeBtn);
			removeBtn.style.marginRight = '10px';
			removeBtn.textContent = 'Remove';
			removeBtn.addEventListener('click', () => {
				triggerPanelRemoveRow(newRow);
				setTriggerCode(); 
				displayTriggerPanel();
			});
			cell3.appendChild(removeBtn);
			cell3.style.border = '1px solid black';
			cell3.style.textAlign = 'center';
		}
		


		if(triggerListLoss.length>0)
		{
			setTriggerCode();	
		}

	}
	return container;
}


function triggerPanelRemoveRow(row) {
	var winLoss = row.cells[0].textContent;
    var triggerLoss = row.cells[1].textContent;
    const triggerOption = row.cells[2].textContent;
	
    
    if(triggerLoss !== "Pattern") {
        triggerLoss = parseInt(triggerLoss);
    }

    const index = triggerListLoss.findIndex((value, idx) => value === triggerLoss 
		&& triggerListText[idx] === triggerOption 
		&& triggerListWinLoss[idx]==winLoss);

    if (index !== -1) {
		triggerListWinLoss.splice(index, 1);
        triggerListLoss.splice(index, 1);
        triggerListItem.splice(index, 1);
        triggerListText.splice(index, 1);
    }

    // Remove the row from the table
    row.parentNode.removeChild(row);

    // Get the table
    let table = document.getElementById('triggerItems');
    // Check if the table has more than just the header row
    if (table.rows.length <= 1) {  // Header row is always present, so 1 means no data rows
        table.parentNode.removeChild(table);  // Remove the table if no data rows are left
    }
}


function triggerPanelCreateTriggerTable() {
    const table = document.createElement('table');
    table.id = 'triggerItems';
    table.style.width = '100%';  
    table.style.borderCollapse = 'separate';  // Ensures borders are not shared
    table.style.borderSpacing = '0';  // No spacing between cells
    table.style.border = '1px solid black';  // Border around the table
    const headerRow = table.insertRow();
    const headers = ['W/L','Count', 'Item', 'Bet'];
    headers.forEach(headerText => {
        let headerCell = document.createElement('th');
        headerCell.textContent = headerText;
        headerCell.style.border = '1px solid black';  // Apply border to header cells
        if (headerText === 'Item') {
            headerCell.style.width = '80%';
            headerCell.style.whiteSpace = 'normal';
            headerCell.style.overflowWrap = 'break-word';
        }
        headerRow.appendChild(headerCell);
    });

    return table;
}


