
function style_textbox_container(item)
{
	item.style.width = '100px';
    item.style.fontSize = '24px';
    item.style.fontWeight = '400';
    item.style.lineHeight = '1.7';
    item.style.color = '#212529';
    item.style.backgroundColor = '#fff';
    item.style.backgroundClip = 'padding-box';
    item.style.border = '1px solid #ced4da';
    item.style.appearance = 'none';
    item.style.borderRadius = '4px';
    item.style.transition = 'border-color .15s ease-in-out,box-shadow .15s ease-in-out';
    item.setAttribute('type', 'tel');
    item.setAttribute('pattern', '[0-9]*');
    item.setAttribute('inputmode', 'numeric');

    item.addEventListener('focus', function() {
        item.style.color = '#212529';
        item.style.backgroundColor = '#fff';
        item.style.borderColor = '#86b7fe';
        item.style.outline = '0';
        item.style.boxShadow = '0 0 0 0.25rem rgb(13 110 253 / 25%)';
    });
}

function style_trigger_groups(item)
{
	item.style.marginTop = '10px';
	item.style.marginBottom = '3px';
	item.style.marginRight = '5px';
	item.style.fontSize = '14px';
	item.style.width = '25px';
	item.style.lineHeight = 'normal';
}

function style_form_button(item)
{
	item.style.width = '200px';
	item.style.height = '50px';
	item.style.marginBottom = '5px';
	item.style.marginTop = '5px';
	item.style.marginLeft = '10px';
	item.style.fontSize = '30px';
}

function style_multi_textbox(item)
{
	item.style.width = '100%';
	item.style.height = '300px';
	item.style.fontSize = '24px';
	//;item.style.resize = 'none';
}

function style_drop_down(item)
{
	item.style.width = '300px';
	item.style.height = '50px';
	item.style.marginBottom = '5px';
	item.style.marginTop = '5px';
	item.style.marginLeft = '10px';
	item.style.fontSize = '30px';
}

// Function to style cells with alert-specific styling
function style_cell_alert(cell) {
    cell.style.backgroundColor = 'green';  // Alert color
    cell.style.color = 'white';  // Text color
    cell.style.padding = '10px';  // Padding
}

// Function to style normal cells
function style_cell_normal(cell) {
    cell.style.backgroundColor = '#d0d6ce';  // Normal background color
    cell.style.color = 'black';  // Text color
    cell.style.padding = '10px';  // Padding
    cell.style.border = '1px solid black';
}

// Function to style header cells
function style_cell_header(cell) {
    cell.style.backgroundColor = 'navy';  // Header background color
    cell.style.color = 'white';  // Header text color
    cell.style.padding = '15px';  // Header padding
    cell.style.textAlign = 'left';  // Text alignment
}

function style_trigger_table(table) {
    table.style.width = '100%';  
    table.style.borderCollapse = 'separate';  // Change to 'separate' to see if it helps
    table.style.borderSpacing = '0';  // Ensure there's no spacing between cells
    table.style.border = '1px solid black'; // Applies border around the table

    const rows = table.rows;
    for (let i = 0; i < rows.length; i++) {
        const cells = rows[i].cells;
        for (let j = 0; j < cells.length; j++) {
            applyCellStyles(cells[j]);

            // Styling based on cell content and row position
            if (i === 0) {  // First row (header)
                style_cell_header(cells[j]);
            } else {
                if (cells[j].textContent === 'Alert') {
                    style_cell_alert(cells[j]);
                } else {
                    style_cell_normal(cells[j]);
                }
            }
        }

        // Emphasize row separation by adjusting borders
        if (i > 0) {  // Not the first row
            rows[i].style.borderTop = '2px solid black'; // Emphasize the start of a new row
        }
    }
}
// Ensure to call this function when adding new rows too
function applyCellStyles(cell) {
    cell.style.border = '1px solid black';  // Apply border to each cell
    // Additional cell styles can be applied here
}

// Alert
function alert_style_trigger_table(table) {
    table.style.width = '100%';  
    table.style.borderCollapse = 'separate';  // Set to 'separate' for cell borders
    table.style.borderSpacing = '0';  // No spacing between cells
    table.style.border = '1px solid black'; // Border around the table

    const rows = table.rows;
    for (let i = 0; i < rows.length; i++) {
        const cells = rows[i].cells;
        for (let j = 0; j < cells.length; j++) {
            alert_applyCellStyles(cells[j], table); // Pass table to applyCellStyles for contextual styling

            // Styling based on cell content and row position
            if (i === 0) {  // First row (header)
                alert_style_cell_header(cells[j]);
            } else {
                if (cells[j].textContent.includes('Alert')) {
                    alert_style_cell_alert(cells[j]);
                } else {
                    alert_style_cell_normal(cells[j]);
                }
            }
        }

        // Emphasize row separation by adjusting borders
        if (i > 0) {  // Not the first row
            rows[i].style.borderTop = '2px solid black'; // Emphasize the start of a new row
        }
    }
}

function alert_applyCellStyles(cell, table) {
    // Apply styles based on the table class
    if (table.classList.contains('trigger-watch-table')) {
        cell.style.textAlign = 'left';
        cell.style.border = '1px solid #ddd';
    } else if (table.classList.contains('trigger-alert-table')) {
        cell.style.textAlign = 'left';
        cell.style.border = '1px solid rgb(255, 254, 204)';
    }
}

function alert_style_cell_header(cell) {
    cell.style.fontWeight = 'bold';  // Bold font for header
}

function alert_style_cell_alert(cell) {
    cell.style.backgroundColor = 'rgb(255, 235, 238)';  // Light red background for alerts
}

function alert_style_cell_normal(cell) {
    cell.style.backgroundColor = 'white';  // Normal cells with white background
}
