function add_trigger_patterns(){

    let container = document.createElement('div');
	container.style.fontSize = '30px';
	container.style.paddingLeft = '10px';

   // Title container for stacking
var titleContainer = document.createElement('div');
titleContainer.style.textAlign = 'left';

// Main Title
var sectionTitle = document.createElement('h2');
sectionTitle.textContent = 'Add Pattern Trigger';
titleContainer.appendChild(sectionTitle);

// Subtitle
var subtitle = document.createElement('h2');
subtitle.textContent = "This tool looks at patterns forming like red, black, black, red in blocks then we bet on it ending which would be black, The tool tells you which to bet on, it's up to you to martingale accordingly - symmetrical patterns have to end.";
subtitle.style.fontWeight = 'normal';  // lighter than main title
subtitle.style.fontSize = '1.2em';     // smaller size
subtitle.style.marginTop = '0';
titleContainer.appendChild(subtitle);

container.appendChild(titleContainer);

let section_outside_bets = pattern_bet_section();
container.appendChild(section_outside_bets);

return container;
}

function pattern_bet_section() {
    let container = document.createElement('div');

    // Set container styles for vertical stacking and spacing
    container.style.display = 'flex';
    container.style.flexDirection = 'column';
    container.style.alignItems = 'center';
    container.style.gap = '25px';
    container.style.fontSize = '36px';
    container.style.padding = '20px';

    // Pattern Length input
    var patternLength = document.createElement('input');
    style_textbox_container(patternLength);
    patternLength.type = 'text';
    patternLength.id = "patternLength";
    patternLength.name = "patternLength";
    patternLength.value = "";
    patternLength.style.width = '140px';
    patternLength.style.height = '70px';
    patternLength.style.fontSize = '36px';
    patternLength.style.textAlign = 'center';
    patternLength.style.borderRadius = '12px';
    patternLength.style.border = '2px solid #ccc';
    container.appendChild(patternLength);

    // Label for Pattern Length
    var label_patternLength = document.createElement('label');
    label_patternLength.htmlFor = 'patternLength';
    label_patternLength.appendChild(document.createTextNode('Pattern Length'));
    label_patternLength.style.fontSize = '36px';
    container.appendChild(label_patternLength);

    // Pattern Multiplier input
    var patternMultiplier = document.createElement('input');
    style_textbox_container(patternMultiplier);
    patternMultiplier.id = "patternMultiplier";
    patternMultiplier.type = 'text';
    patternMultiplier.name = "patternMultiplier";
    patternMultiplier.value = "";
    patternMultiplier.style.width = '140px';
    patternMultiplier.style.height = '70px';
    patternMultiplier.style.fontSize = '36px';
    patternMultiplier.style.textAlign = 'center';
    patternMultiplier.style.borderRadius = '12px';
    patternMultiplier.style.border = '2px solid #ccc';
    container.appendChild(patternMultiplier);

    // Label for Pattern Multiplier
    var label_patternMultiplier = document.createElement('label');
    label_patternMultiplier.htmlFor = 'patternMultiplier';
    label_patternMultiplier.appendChild(document.createTextNode('Pattern repeats'));
    label_patternMultiplier.style.fontSize = '36px';
    container.appendChild(label_patternMultiplier);

    // Add Trigger button
    const pattern_trigger_button = document.createElement('button');
    style_form_button(pattern_trigger_button);
    pattern_trigger_button.id = "patternTriggerButton";
    pattern_trigger_button.innerText = "Add Trigger";
    pattern_trigger_button.style.fontSize = '36px';
    pattern_trigger_button.style.height = '70px';
    pattern_trigger_button.style.minWidth = '320px';
    pattern_trigger_button.style.padding = '0 40px';
    pattern_trigger_button.style.borderRadius = '12px';
    pattern_trigger_button.style.textAlign = 'center';
    pattern_trigger_button.style.cursor = 'pointer';
    pattern_trigger_button.style.boxSizing = 'border-box';
    pattern_trigger_button.style.whiteSpace = 'nowrap';
    pattern_trigger_button.addEventListener('click', function () {
        patternBetSelectionAddTrigger();
        displayTriggerPanel();
    });
    container.appendChild(pattern_trigger_button);

    return container;
}


function patternBetSelectionAddTrigger() {
	

	var losses = 'Pattern';

	var patternLength = parseInt(document.getElementById('patternLength').value);
	if (isNaN(patternLength) || patternLength < 1) {
		patternLength = 2;
		document.getElementById('patternLength').value = 2;
	}

	var patternMultiplier = parseInt(document.getElementById('patternMultiplier').value);
	if (isNaN(patternMultiplier) || patternMultiplier < 1) {
		patternMultiplier = 2;
		document.getElementById('patternMultiplier').value = 2;
	}

	var item = patternLength+" x "+patternMultiplier;

	const indexFound = triggerListLoss.findIndex((value, index) => value === losses && triggerListText[index] === item);


	const itemFound = indexFound !== -1;

	if (!itemFound) {
		addTriggerToTriggersList(losses, item, 'Pattern',"-");
	}
}