// -------------------------------------------------------------------------------
//  Helper Code
// -------------------------------------------------------------------------------

function displayTriggerPanel()
{
    untoggleButtonBarButtons();
    buttonBarContents("4", getTriggerList);
}



function addTriggerToTriggersList(triggerLoss, triggerText, triggerOption, triggerWinLoss){

	triggerListLoss.push(triggerLoss);
	triggerListItem.push(triggerOption);
	triggerListText.push(triggerText);
	triggerListWinLoss.push(triggerWinLoss);


}



function getPatternList(triggerLoss, triggerText, triggerOption, triggerWinLoss) {

	let container = createAndClearBlankDiv('trigger-results-triggers-container');

	triggerListLoss.push(triggerLoss);
	triggerListItem.push(triggerOption);
	triggerListText.push(triggerText);
	triggerListWinLoss.push(triggerWinLoss);

	let table = document.getElementById('triggerItems');

	if (!table) {

		const headerTitle = document.createElement('h2');
		headerTitle.textContent = 'Triggers List';
		let trigger_display_simple = triggerPanelCreateTriggerTable();
		container.appendChild(headerTitle);
		container.appendChild(trigger_display_simple);

		table = trigger_display_simple;
	}

	const newRow = table.insertRow();
	const cell1 = newRow.insertCell();
	const cell2 = newRow.insertCell();
	const cell3 = newRow.insertCell();

	cell1.textContent = triggerLoss;
	cell2.textContent = triggerText;

	const removeBtn = document.createElement('button');
	removeBtn.textContent = 'Remove';
	removeBtn.addEventListener('click', () =>
	{
		patternPanelRemoveRow(newRow);
		setTriggerCode();
		selectTabAndUpdateContent(1, getPatternList);
	} );
	cell3.appendChild(removeBtn);

	if(triggerListLoss.length>0)
	{
		setTriggerCode();
	}
	
	return container;

}





function getTriggers() {

	let array1 = [];
	let array2 = [];


	const table = document.getElementById('triggerItems');


	if (table) {

		for (let i = 0; i < table.rows.length; i++) {

			let row = table.rows[i];

			if (row.cells.length >= 2) {
				array1.push(row.cells[0].textContent || row.cells[0].innerText);
				array2.push(row.cells[1].textContent || row.cells[1].innerText);
			}
		}
	}

}
