function add_trigger_groups(){

    let container = document.createElement('div');
	container.style.fontSize = '30px';
	container.style.paddingLeft = '25px';
	













   // Title container for stacking
var titleContainer = document.createElement('div');
titleContainer.style.textAlign = 'left';

// Main Title
var sectionTitle = document.createElement('h2');
sectionTitle.textContent = 'Add Groups Trigger';
titleContainer.appendChild(sectionTitle);

// Subtitle
var subtitle = document.createElement('h2');
subtitle.textContent = 'Track any groups of numbers like in the text box below with a dash - to separate the group triggers';
subtitle.style.fontWeight = 'normal';  // lighter than main title
subtitle.style.fontSize = '1.2em';     // smaller size
subtitle.style.marginTop = '0';        // tighten spacing
titleContainer.appendChild(subtitle);

container.appendChild(titleContainer);

let section_outside_bets = group_bet_section();
container.appendChild(section_outside_bets);

return container;
}













function group_bet_section() {
    let container = document.createElement('div');
    container.style.fontSize = '36px';  // base font size larger
    container.style.display = 'flex';
    container.style.flexDirection = 'column';
    container.style.alignItems = 'center';
    container.style.gap = '20px';
    container.style.padding = '20px';

    // Losses textbox
    var groupSpins = document.createElement('input');
    style_textbox_container(groupSpins);
    groupSpins.type = 'text';
    groupSpins.id = "triggerGroupsLosses";
    groupSpins.name = "triggerGroupsLosses";
    groupSpins.style.width = '160px';
    groupSpins.style.height = '60px';
    groupSpins.style.fontSize = '36px';
    groupSpins.style.textAlign = 'center';
    groupSpins.style.borderRadius = '10px';
    groupSpins.style.border = '2px solid #ccc';
    container.appendChild(groupSpins);

    // Wins / Losses dropdown
    var dropdown = document.createElement('select');
    style_drop_down(dropdown);
    dropdown.id = 'triggerGroupsLossesDropDown';
    dropdown.style.width = '200px';
    dropdown.style.height = '60px';
    dropdown.style.fontSize = '36px';
    dropdown.style.borderRadius = '10px';

    var lossesOption = document.createElement('option');
    lossesOption.value = 'L';
    lossesOption.text = 'Losses';
    dropdown.appendChild(lossesOption);

    var winsOption = document.createElement('option');
    winsOption.value = 'W';
    winsOption.text = 'Wins';
    dropdown.appendChild(winsOption);

    container.appendChild(dropdown);

    // Label "in a row"
    var label = document.createElement('label');
    label.htmlFor = 'triggerGroupsLosses';
    label.innerText = ' in a row';
    label.style.fontSize = '36px';
    container.appendChild(label);

   // Add Trigger button
const apply_trigger_button = document.createElement('button');
style_form_button(apply_trigger_button);
apply_trigger_button.id = "addUserDefinedTriggerBtn";
apply_trigger_button.innerText = "Add Trigger";
apply_trigger_button.style.fontSize = '36px';
apply_trigger_button.style.height = '70px';
apply_trigger_button.style.padding = '0 40px';
apply_trigger_button.style.borderRadius = '12px';
apply_trigger_button.style.textAlign = 'center';
apply_trigger_button.style.cursor = 'pointer';
apply_trigger_button.style.minWidth = '320px';  // Added
apply_trigger_button.style.boxSizing = 'border-box';  // Added
apply_trigger_button.style.whiteSpace = 'nowrap';  // Added
apply_trigger_button.onclick = function () {
    groupBetSelectionAddTrigger();
    displayTriggerPanel();
};
container.appendChild(apply_trigger_button);

    // Textarea for groups
    const groupNumbers = document.createElement('textarea');
    style_multi_textbox(groupNumbers);
    groupNumbers.id = "groupNumbers";
    groupNumbers.placeholder = "1,2,3 - 10,11,12 - 1,5,20 (separate groups with a -)";
    groupNumbers.value = "1,2,3 - 34,35,36";
    groupNumbers.style.width = '450px';
    groupNumbers.style.height = '250px';
    groupNumbers.style.fontSize = '32px';
    groupNumbers.style.borderRadius = '12px';
    groupNumbers.style.border = '2px solid #ccc';
    groupNumbers.style.padding = '15px';
    groupNumbers.style.resize = 'vertical';
    container.appendChild(groupNumbers);

   // Clear Textbox button
const clearGroupNumbersButton = document.createElement('button');
style_form_button(clearGroupNumbersButton);
clearGroupNumbersButton.id = "clearUserDefinedOptionsBtn";
clearGroupNumbersButton.innerText = "Clear Textbox";
clearGroupNumbersButton.style.fontSize = '36px';
clearGroupNumbersButton.style.height = '70px';
clearGroupNumbersButton.style.padding = '0 40px';
clearGroupNumbersButton.style.borderRadius = '12px';
clearGroupNumbersButton.style.textAlign = 'center';
clearGroupNumbersButton.style.cursor = 'pointer';
clearGroupNumbersButton.style.minWidth = '320px';  // Added
clearGroupNumbersButton.style.boxSizing = 'border-box';  // Added
clearGroupNumbersButton.style.whiteSpace = 'nowrap';  // Added
clearGroupNumbersButton.onclick = function () {
    var textarea = document.getElementById('groupNumbers');
    textarea.value = '';
};
container.appendChild(clearGroupNumbersButton);

    return container;
}






function groupBetSelectionAddTrigger() {

	var lossesElement = document.getElementById('triggerGroupsLosses');


	var losses = parseInt(lossesElement.value);



if (isNaN(losses)) {
    losses = 1;  
}


lossesElement.value = losses;

	var textarea = document.getElementById('groupNumbers');

	var value = textarea.value;

	value = processValue(value);

	if(value.length==0)
	{
		return;
	}

	var winLossIndicator = document.getElementById('triggerGroupsLossesDropDown').value;

	
	value.forEach(group => {

		var joinedGroup = group.join(", ");

		const indexFound = triggerListLoss.findIndex((value, index) => value === losses && triggerListText[index] === joinedGroup
		&& triggerListWinLoss[index] === winLossIndicator);

		const itemFound = indexFound !== -1;


		if (!itemFound) {

			addTriggerToTriggersList(losses, joinedGroup, 'Groups', winLossIndicator);
	
		}

	});

}