function add_trigger_custom(){

    let container = document.createElement('div');
	container.style.fontSize = '30px';
	container.style.paddingLeft = '25px';


    // Title container (optional if you want to group them)
var titleContainer = document.createElement('div');
titleContainer.style.textAlign = 'left';

// Main Title
var sectionTitle = document.createElement('h2');
sectionTitle.textContent = 'Add members custom triggers';
titleContainer.appendChild(sectionTitle);

// Subtitle
var subtitle = document.createElement('h2');
subtitle.textContent = 'Choose trigger, add to code box, press insert triggers button.';
subtitle.style.fontWeight = 'normal';  // lighter than main title
subtitle.style.fontSize = '1.2em';     // smaller size
subtitle.style.marginTop = '0';        // reduce top margin to tighten spacing
titleContainer.appendChild(subtitle);

// Append container to your main container
container.appendChild(titleContainer);

    
    

    let section_outside_bets = trigger_code_section();
    container.appendChild(section_outside_bets);

    return container;
}

function trigger_code_section() {
    let trigger_code_window = document.createElement('div');

    // Container styles for vertical stacking and spacing
    trigger_code_window.style.display = 'flex';
    trigger_code_window.style.flexDirection = 'column';
    trigger_code_window.style.alignItems = 'center';
    trigger_code_window.style.gap = '25px';
    trigger_code_window.style.fontSize = '36px';
    trigger_code_window.style.padding = '20px';

    trigger_code_window.setAttribute('id', 'trigger-code-window');

    let userOption = userTriggerOptions();
    trigger_code_window.appendChild(userOption);

    // Dropdown Options
    var made_triggers = document.createElement('select');
    style_drop_down(made_triggers);
    made_triggers.style.width = '450px';    // bigger width
    made_triggers.style.height = '70px';    // taller dropdown
    made_triggers.style.fontSize = '36px';  // bigger text
    made_triggers.style.borderRadius = '12px';
    made_triggers.style.border = '2px solid #ccc';
    made_triggers.style.textAlign = 'center';

    made_triggers.id = 'made_triggers_Dropdown';

    var defaultValue = 'Even';
    // Create and append options
    preMadeDropDown.forEach(function (option) {
        var optionElement = document.createElement('option');
        optionElement.value = option.value;
        optionElement.textContent = option.text;

        // Set the option as selected if it matches the defaultValue
        if (option.value === defaultValue) {
            optionElement.selected = true;
        }

        made_triggers.appendChild(optionElement);
    });
    trigger_code_window.appendChild(made_triggers);

    // Button
    const made_button = document.createElement('button');
    style_form_button(made_button);
    made_button.id = "patternTriggerButton";
    made_button.innerText = "Add code to box";
    made_button.style.width = '320px';       // wider button
    made_button.style.height = '70px';       // taller button
    made_button.style.fontSize = '36px';     // bigger text
    made_button.style.borderRadius = '12px';
    made_button.style.textAlign = 'center';
    made_button.style.cursor = 'pointer';
    made_button.style.padding = '0 30px';
    made_button.style.whiteSpace = 'nowrap';
    made_button.onclick = addPremade;
    trigger_code_window.appendChild(made_button);

    return trigger_code_window;
}






function codeBoxSelectionAddTrigger()
{
	
		var textareaValue = document.getElementById('trigger-code').value;

		var lines = textareaValue.split(';');
		

		lines.forEach(function(line) {
			if (line.trim()) { 

				var items = line.split(':');
				
				
			const indexFound = triggerListLoss.findIndex((value, index) => value === parseInt(items[1].trim()) && triggerListText[index] === items[2].trim()
			&& triggerListWinLoss[index] === items[0].trim());

			const itemFound = indexFound !== -1;
			if(!itemFound)
			{
			
				
				if(items[1].trim()=="Pattern")
				{
					
		

					const indexFound = triggerListLoss.findIndex((value, index) => value === 'Pattern' && triggerListText[index] === items[2].trim());
					const itemFound = indexFound !== -1;


					if (!itemFound) {
						
						addTriggerToTriggersList('Pattern', items[3].trim(), 'Pattern','-');
					}
				}
				else
				{
					
					const indexFound = triggerListLoss.findIndex((value, index) => value ===  parseInt(items[0].trim()) && triggerListText[index] === items[2].trim());


					const itemFound = indexFound !== -1;
					if (!itemFound) {

						addTriggerToTriggersList(parseInt(items[1].trim()),items[3].trim(),items[2].trim(),items[0].trim());
					}else {
						showMessageAtCursor("Item already added.");
			
					}

				}
				
			}	

				
			}
		});
		
}



function userTriggerOptions_old() {


	// Paste Tab Container
	let panelPasteNumbers = document.createElement('div');
    
	panelPasteNumbers.id = 'trigger-code-container';
	panelPasteNumbers.innerHTML = '';


	const buttonGroupContainer = document.createElement('div');
	buttonGroupContainer.id = 'trigger-options-user-button-container';


	// Apply Button
	const addNumbersButton = document.createElement('button');
    style_form_button(addNumbersButton);
	addNumbersButton.innerText = "Insert Triggers";
    addNumbersButton.style.width = '300px';
	addNumbersButton.addEventListener('click', function(){	
        codeBoxSelectionAddTrigger();
        displayTriggerPanel();
	});

	// Clear Button
	const clearButton = document.createElement('button');
    style_form_button(clearButton);
	clearButton.innerText = "Clear";
	clearButton.addEventListener('click', function () {
		var textarea = document.getElementById('trigger-code');
		textarea.value = '';
	});

	// Create button
	var copyButton = document.createElement('button');
    style_form_button(copyButton);
	copyButton.innerText = 'Clipboard';
	copyButton.addEventListener('click', function () {
		let data = document.getElementById('trigger-code').value;
		navigator.clipboard.writeText(data);
	});

	buttonGroupContainer.appendChild(addNumbersButton);
	buttonGroupContainer.appendChild(clearButton);
	buttonGroupContainer.appendChild(copyButton);

	// Enter Text Area
	const textarea = document.createElement('textarea');
    style_multi_textbox(textarea);
    textarea.id = 'trigger-code';
    textarea.style.width = '715px';
	textarea.innerHTML = triggerCode;

	// Add items to Paste Tab Container
	panelPasteNumbers.appendChild(buttonGroupContainer);
	panelPasteNumbers.appendChild(textarea);

	return panelPasteNumbers;
}

function userTriggerOptions() {

  // Paste Tab Container
  let panelPasteNumbers = document.createElement('div');
  panelPasteNumbers.id = 'trigger-code-container';
  panelPasteNumbers.innerHTML = '';

  const buttonGroupContainer = document.createElement('div');
  buttonGroupContainer.id = 'trigger-options-user-button-container';

  // Insert Triggers
  const addNumbersButton = document.createElement('button');
  style_form_button(addNumbersButton);
  addNumbersButton.innerText = "Insert Triggers";
  addNumbersButton.style.width = '300px';
  addNumbersButton.addEventListener('click', function(){	
    codeBoxSelectionAddTrigger();
    displayTriggerPanel();
  });

  // --- NEW: Import ---
  const importButton = document.createElement('button');
  style_form_button(importButton);
  importButton.innerText = "Import";

  // Hidden file input for Import
  const fileInput = document.createElement('input');
  fileInput.type = 'file';
  fileInput.accept = 'application/json,.json';
  fileInput.style.display = 'none';

  importButton.addEventListener('click', () => fileInput.click());

  fileInput.addEventListener('change', async (e) => {
    const file = e.target.files && e.target.files[0];
    if (!file) return;
    try {
      const text = await file.text();
      let valueToSet = text;

      // Try to parse as JSON; accept raw string or { trigger_code: "..." }
      try {
        const parsed = JSON.parse(text);
        if (typeof parsed === 'string') {
          valueToSet = parsed;
        } else if (parsed && typeof parsed === 'object' && typeof parsed.trigger_code === 'string') {
          valueToSet = parsed.trigger_code;
        }
      } catch (_) {
        // Not JSON — just use raw text
      }

      const textarea = document.getElementById('trigger-code');
      if (textarea) textarea.value = valueToSet;
    } catch (err) {
      console.error('Import failed:', err);
      // optional: toast or message function if you have one
    } finally {
      fileInput.value = ''; // allow re-selecting the same file later
    }
  });

  // --- NEW: Export ---
  const exportButton = document.createElement('button');
  style_form_button(exportButton);
  exportButton.innerText = "Export";

  exportButton.addEventListener('click', () => {
    const textarea = document.getElementById('trigger-code');
    const raw = (textarea && textarea.value) ? textarea.value : "";

    // If raw is valid JSON, save as-is; else wrap in { trigger_code: ... }
    let payload = raw;
    let isJson = false;
    try { JSON.parse(raw); isJson = true; } catch(_) {}

    if (!isJson) {
      payload = JSON.stringify({ trigger_code: raw }, null, 2);
    }

    //const blob = new Blob([payload], { type: 'application/json' });
    const blob = new Blob([raw], { type: 'application/json' });

	const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    const date = new Date().toISOString().slice(0, 10); // YYYY-MM-DD
    a.href = url;
    a.download = `triggers-${date}.json`;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
  });

  // Clear
  const clearButton = document.createElement('button');
  style_form_button(clearButton);
  clearButton.innerText = "Clear";
  clearButton.addEventListener('click', function () {
    const textarea = document.getElementById('trigger-code');
    if (textarea) textarea.value = '';
  });

  // Clipboard
  const copyButton = document.createElement('button');
  style_form_button(copyButton);
  copyButton.innerText = 'Clipboard';
  copyButton.addEventListener('click', function () {
    const data = (document.getElementById('trigger-code') || {}).value || '';
    navigator.clipboard.writeText(data).catch(err => console.error('Clipboard failed:', err));
  });

  // Order: Insert Triggers, Import, Export, Clear, Clipboard
  buttonGroupContainer.appendChild(addNumbersButton);

  buttonGroupContainer.appendChild(clearButton);
  buttonGroupContainer.appendChild(copyButton);
  buttonGroupContainer.appendChild(fileInput); // hidden input for Import

  // Textarea
  const textarea = document.createElement('textarea');
  style_multi_textbox(textarea);
  textarea.id = 'trigger-code';
  textarea.style.width = '715px';
  textarea.innerHTML = triggerCode;

  // Add to container
  panelPasteNumbers.appendChild(buttonGroupContainer);
  panelPasteNumbers.appendChild(textarea);
panelPasteNumbers.appendChild(document.createElement('br'));
    panelPasteNumbers.appendChild(importButton);
  panelPasteNumbers.appendChild(exportButton);

  return panelPasteNumbers;
}
