function trigger_alert_display() {

    
	let container = createAndClearBlankDiv('trigger-alert-title-container');
	let innerContainer = createAndClearBlankDiv('trigger-watch-title-inner-container');

	let indexedMap = alertCounter.map((value, index) => ({ value, index }));
	indexedMap.sort((a, b) => b.value - a.value);
	let sortedIndexes = indexedMap.map(item => item.index);
    

	sortedIndexes.forEach((value, index) => {


		let table = innerContainer.querySelector(`#watch-${CSS.escape(alertId[index])}`);
			
			if (!table) {
				table = createAlertTable(alertId[index],alertId[index]);
				innerContainer.appendChild(table);
			}
			

			const newRow = table.insertRow();
			const cell0 = newRow.insertCell();
			cell0.style.verticalAlign = "bottom";
			const cell1 = newRow.insertCell();
			cell1.style.verticalAlign = "bottom";
			const cell2 = newRow.insertCell();
			cell2.style.whiteSpace = "pre-line"; 
			const cell3 = newRow.insertCell();
			cell3.style.verticalAlign = "bottom";

			cell0.textContent = alertWinLoss[index];
			cell1.textContent = alertCounter[index];
			cell2.textContent = alertItem[index];
			cell3.textContent = alertItemDetail[index];
        });
    container.appendChild(innerContainer);
	return container;
}

function createAlertTable(id,tableTitle="FIX") {



	// Create table
	const table = document.createElement('table');
	table.setAttribute('id', `watch-`+id);
	table.classList.add('trigger-watch-table');
	table.classList.add('trigger-alert-table');

	// Table Title
	const headerTitle = table.insertRow();
	const headerCell = document.createElement('th');
	headerCell.textContent = `Alert  -   `+tableTitle;
	headerCell.colSpan = 3; 
	headerCell.style.textAlign = 'center';
	headerCell.style.color = 'brown';
	headerTitle.appendChild(headerCell);

	// Create header row
	const headerRow = table.insertRow();
	const headers =  ['W/L','Count', 'Item', 'Bet'];
	headers.forEach(headerText => {
		let headerCell = document.createElement('th');
		headerCell.textContent = headerText;
		headerRow.appendChild(headerCell);
	});

	
	return table;

}


function table_alert_locations(){
	unHighLightAllNumbers();

	alertItem.forEach((alert, index) => {
		if (alertHighLightStack[index] === highlight_number_groups
			|| alertHighLightStack[index] === highlight_straight_numbers
			|| alertHighLightStack[index] === highlight_uniques)
		 {

			alertItemDetail[index].forEach(spinitem => {

				alertHighLightStack[index](parseInt(spinitem));
			});



		} else {

			alertHighLightStack[index]();
		}

		
		// Splits Down
		if (alertHighLightStack[index] === highlight_split_across
			|| alertHighLightStack[index] === highlight_split_down
			|| alertHighLightStack[index] === highlight_quad
			|| alertHighLightStack[index] === highlight_street
			|| alertHighLightStack[index] === highlight_double_street) {

			   var stringId = alertItemDetail[index].join(`, `);
			   alertHighLightStack[index](stringId);
		   }
	});
}