const q_styles = {
    
    mainContainer: {
        
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'left', // Centers items horizontally
      justifyContent: 'flex-start', // Aligns items to the start of the flex direction
      width: '100%',
      paddingTop: '10px',
      paddingBottom: '10px',
      paddingRight: '10px',
     

    },
    vnumberContainer: {
      display: 'flex',       /* Aligns children (number divs) in a row */
      overflowX: 'auto',
      whiteSpace: 'nowrap',  /* Ensures no line breaks within the container */
      width: '95%',         /* Takes full width of its parent */
      border: '0px solid black', /* Visible border for clarity */
      padding: '10px',       /* Some padding around the numbers */
      paddingTop: '0px',
      boxSizing: 'border-box', /* Includes padding and border in the width */
      marginBottom: '15px',
      marginLeft: '25px',
      marginRight: '25px',
      fontSize: '60px',      /* Size of the text */
      fontWeight: 'bold',    /* Weight of the font */
      //letterSpacing: '3px',  /* Space between characters, useful if numbers are a single string */
      //justifyContent: 'space-evenly' /* Distributes space evenly between items */
        
  },
    
    sidebar: {
        width: '150px',
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'left',
        paddingTop: '0px',
        paddingLeft: '20px', 
        height: 'auto',
        marginTop: '50px',

    },

    redNum: {
        background: '#eb3838',
        color: '#fff'
    },
    blackNum: {
        background: '#2e2c2b',
        color: '#fff'
    },
    number_0: {
     
      width: '125px',
      border: '1px solid',
      textAlign: 'center',
      padding: '25px 0px',
      margin: '0 1px', 
      border: '1px solid white',
        backgroundColor: '#077736',
        color: 'white',
        backgroundColor: '#2c3e50',
      
    },
    number_block: {
        width: '125px',
        border: '1px solid',
        textAlign: 'center',
        padding: '25px 0px',
        margin: '0 1px', 
        border: '1px solid white'
    },

 rows_block: {
  textAlign: 'center',  
  fontWeight: 'bold',
  fontSize: '35px',
  whiteSpace: 'nowrap',
  paddingLeft: '5px',
  paddingRight: '5px', 
  backgroundColor: '#2c3e50',  // Updated
  border: '2px solid white',
  color: 'white',
},

    dozens_block: {
      textAlign: 'center',  
      fontWeight: 'bold',
      fontSize: '24px',
      whiteSpace: 'nowrap',
      paddingLeft: '5px',
      paddingRight: '5px',
      border: '2px solid white',
      backgroundColor: '#077736',
      color: 'white',
      backgroundColor: '#2c3e50',
    },


    evens_block: {
        
        textAlign: 'center',  
        fontWeight: 'bold',
        fontSize: '24px',
        whiteSpace: 'nowrap',
        paddingLeft: '5px',
        paddingRight: '5px', 
        border: '2px solid white',
         backgroundColor: '#077736',
        color: 'white',
        backgroundColor: '#2c3e50'

    }
    
    
 
};



function q_rouletteTable() {
  let mainContainer = document.createElement('div');
  mainContainer.id = 'quick-table';
  mainContainer.style.touchAction = 'manipulation';
  applyStyles(mainContainer, q_styles.mainContainer);


  // Create input/buttons container (flex row)
  let inputButtonContainer = document.createElement('div');
  inputButtonContainer.style.display = 'flex';
  inputButtonContainer.style.flexWrap = 'wrap';
  inputButtonContainer.style.alignItems = 'center';
  inputButtonContainer.style.justifyContent = 'center';
  inputButtonContainer.style.gap = '10px';
  inputButtonContainer.style.padding = '10px';
  inputButtonContainer.style.width = '100%';

  const countSpan = document.createElement('span');
  countSpan.id = 'numbers-count';
  countSpan.textContent = `Count: ${numbers.length}`;
  countSpan.style.fontSize = '35px';
  countSpan.style.fontWeight = 'bold';
  countSpan.style.marginRight = '10px';
  countSpan.style.color = 'black';

  let qInput = q_inputBox();
  let qButton = q_input_button();
  let qButtonUndo = q_input_button_undo();
  let qButtonRandom = q_random_button();

   inputButtonContainer.appendChild(countSpan);
  inputButtonContainer.appendChild(qInput);
  inputButtonContainer.appendChild(qButton);
  inputButtonContainer.appendChild(qButtonUndo);
  inputButtonContainer.appendChild(qButtonRandom);

  // Create number display below buttons
  let numberContainer = v_number_container();

  mainContainer.appendChild(inputButtonContainer);  // Buttons first
  mainContainer.appendChild(numberContainer);       // Numbers below

  return mainContainer;
}

function v_number_container() {
  const container = document.createElement('div');
  container.id = 'vnumberContainer';
  applyStyles(container, q_styles.vnumberContainer); 
  return container;
}

function v_number_container_update() {
  let container = document.getElementById('vnumberContainer');
  if (container) {
      container.innerText = '';  // Clear existing content
      for (var x = numbers.length-1; x >= 0; x--) {
          let item = document.createElement('div');
          item.style.display = 'inline-block'; // Ensures it stays in line
          var colourClass = numRed.includes(numbers[x]) ? 'historyRed' : 'historyBlack';
          if (numbers[x] == 0) colourClass = 'historyGreen';
          
          item.className = 'nbHistory ' + colourClass; // Apply classes for styling
          if (x > 0) {
              // Use innerHTML and add non-breaking spaces or HTML entity for a space
              item.innerHTML = numbers[x] + ',&nbsp;'; // Adds a comma and two non-breaking spaces
          }
          else
          {
            item.innerHTML = numbers[x]
          }

          container.appendChild(item);
      }
  }
}

function q_inputBox() {
  // Create the input element
  const inputField = document.createElement('input');
  inputField.style.fontSize = '37px';
  inputField.style.width = '225px';
  inputField.setAttribute('type', 'tel');
  inputField.setAttribute('id', 'q_num');
  inputField.setAttribute('pattern', '[0-9]*');
  inputField.setAttribute('inputmode', 'numeric');
  inputField.setAttribute('placeholder', '#');
  inputField.style.display = 'none';

  // Add focus event listener to clear the input when it receives focus
  inputField.addEventListener('focus', function() {
      this.value = ''; // Clear the input field
  });

  // Add keyup event listener to process the input when Enter is pressed
  inputField.addEventListener('keyup', function(event) {
      if (event.key === 'Enter' || event.keyCode === 13) {
          // The Enter key was pressed
          let n = ensureRouletteNumber(this.value); // Make sure to use 'this.value'
          pushHistory(n);

          // Optionally clear the input if needed
          this.value = ''; // Clear the input field using 'this.value'
      }

      
  });
      // Handle focus loss which might indicate 'Done' being pressed
      inputField.addEventListener('blur', function() {
          // The Enter key was pressed
          let n = ensureRouletteNumber(this.value); // Make sure to use 'this.value'
          pushHistory(n);

          // Optionally clear the input if needed
          this.value = ''; // Clear the input field using 'this.value'
    });
/*
    // Handle change event which can indicate completion
    inputField.addEventListener('change', function() {
          // The Enter key was pressed
          let n = ensureRouletteNumber(this.value); // Make sure to use 'this.value'
          pushHistory(n);

          // Optionally clear the input if needed
          this.value = ''; // Clear the input field using 'this.value'
    });
*/
  return inputField;
}

function q_random_button() {
 const button = document.createElement('button');
button.style.minWidth = '200px';
button.style.height = '70px';
button.style.margin = '5px 0 5px 10px';
button.style.fontSize = '58px';
button.style.padding = '0 30px'; // Left-right padding

button.style.borderRadius = '10px';
button.style.backgroundColor = '#eee';
button.style.cursor = 'pointer';
button.textContent = 'Spin';

// Flexbox centering instead of line-height:
button.style.display = 'flex';
button.style.justifyContent = 'center';  // horizontal center
button.style.alignItems = 'center';      // vertical center


  button.onclick = function () {
    oneRandomNumber();
  };

  return button;
}



function q_input_button_undo(){
const button = document.createElement('button');
button.style.width = '155px';
button.style.height = '70px';
button.style.marginBottom = '5px';
button.style.marginTop = '5px';
button.style.marginLeft = '10px';
button.style.fontSize = '40px';
button.textContent = 'Undo';
button.style.display = 'flex';
button.style.justifyContent = 'center';
button.style.alignItems = 'center';
button.onclick = function() { undo(); };

  
  return button;
}

function q_input_button(){
  
  const button = document.createElement('button');
  button.style.width = '150px';
  button.style.height = '50px';
  button.style.marginBottom = '5px';
  button.style.marginTop = '5px';
  button.style.marginLeft = '10px';
  button.style.fontSize = '30px';;
  button.id = `quick-add`;
  button.textContent = 'Add';
  button.onclick = function() {  };//q_add_number();
  button.style.display = 'none';
  return button;
}

function q_add_number(){
  let item = document.getElementById('q_num');
  if(item){

    let n = item.value;
    n = ensureRouletteNumber(n);
    pushHistory(n);
  }

}



function q_getRouletteTable() {
    let ids = [
      
      'q_table_1', 'q_table_2', 'q_table_3',
      'q_table_4', 'q_table_5', 'q_table_6',
      'q_table_7', 'q_table_8', 'q_table_9',
      'q_table_10', 'q_table_11', 'q_table_12',
      'q_table_13', 'q_table_14', 'q_table_15',
      'q_table_16', 'q_table_17', 'q_table_18',
      'q_table_19', 'q_table_20', 'q_table_21',
      'q_table_22', 'q_table_23', 'q_table_24',
      'q_table_25', 'q_table_26', 'q_table_27',
      'q_table_28', 'q_table_29', 'q_table_30',
      'q_table_31', 'q_table_32', 'q_table_33',
      'q_table_34', 'q_table_35', 'q_table_36',
      'q_table_0','q_null','q_table_blank','q_last_number'
    ]
    let table = document.createElement('table');
    table.id = 'q-rouletteTable';

    table.style.borderCollapse = 'collapse';
    table.style.textAlign = 'center';
    table.style.fontSize = '50px';


    let index = 0;
    let cols = 5;

    
    for (let i = 0; i < ids.length / cols; i++) {
      let row = table.insertRow();
      for (let j = 0; j < cols; j++) {
        let cell = row.insertCell();
        cell.innerHTML = ids[index];
        cell.id = ids[index++];
        cell.style.border = '1px solid black';
      }
    }

    document.body.appendChild(table);

    q_updateTableElements();
  
    let myTable = document.getElementById('q-rouletteTable');
    
  
    return myTable;
    

  }

  function q_update_last_number()
  {
    var cell = document.getElementById('q_last_number');
    var n = numbers.length > 0 ? numbers[numbers.length - 1] : -1;
    cell.innerHTML = '';

    if (n >= 0) {
      let item = getStyledNumbed(numbers[numbers.length - 1]);
      item.style.fontSize = '50px';
      cell.appendChild(item);
    }
  }

  function q_updateTableElements() {
    var cell = document.getElementById('q_table_blank');
    cell.innerHTML = '';
    const button = document.createElement('button');
    button.style.width = '85px';
    button.style.height = '80px';
    button.id = `quick-undo`;
    button.textContent = 'Undo';
    button.style.fontSize = '30px';
    cell.append(button);
    cell.style.borderRight = '1px solid black';
    cell.onclick = function() { undo(); };

    
    var cell = document.getElementById('q_null');
    cell.innerHTML = '';

    var cell = document.getElementById('q_last_number');
    cell.innerHTML = '';

    

    var cell = document.getElementById('q_table_0');
    
    cell.innerHTML = '0';
    cell.onclick = function() { pushHistory(0); };
    var cell = document.getElementById('q_table_1');
    
    cell.innerHTML = '1';
    cell.onclick = function() { pushHistory(1); };
    var cell = document.getElementById('q_table_2');
    
    cell.innerHTML = '2';
    cell.onclick = function() { pushHistory(2); };
    var cell = document.getElementById('q_table_3');
    
    cell.innerHTML = '3';
    cell.onclick = function() { pushHistory(3); };


    var cell = document.getElementById('q_table_4');
    
    cell.innerHTML = '4';
    cell.onclick = function() { pushHistory(4); };
    var cell = document.getElementById('q_table_5');
    
    cell.innerHTML = '5';
    cell.onclick = function() { pushHistory(5); };
    var cell = document.getElementById('q_table_6');
    
    cell.innerHTML = '6';
    cell.onclick = function() { pushHistory(6); };


    var cell = document.getElementById('q_table_7');
    
    cell.innerHTML = '7';
    cell.onclick = function() { pushHistory(7); };
    var cell = document.getElementById('q_table_8');
    
    cell.innerHTML = '8';
    cell.onclick = function() { pushHistory(8); };
    var cell = document.getElementById('q_table_9');
    
    cell.innerHTML = '9';
    cell.onclick = function() { pushHistory(9); };

  
    var cell = document.getElementById('q_table_10');
    
    cell.innerHTML = '10';
    cell.onclick = function() { pushHistory(10); };
    var cell = document.getElementById('q_table_11');
    
    cell.innerHTML = '11';
    cell.onclick = function() { pushHistory(11); };
    var cell = document.getElementById('q_table_12');
    
    cell.innerHTML = '12';
    cell.onclick = function() { pushHistory(12); };


    var cell = document.getElementById('q_table_13');
    
    cell.innerHTML = '13';
    cell.onclick = function() { pushHistory(13); };
    var cell = document.getElementById('q_table_14');
    
    cell.innerHTML = '14';
    cell.onclick = function() { pushHistory(14); };
    var cell = document.getElementById('q_table_15');
    
    cell.innerHTML = '15';
    cell.onclick = function() { pushHistory(15); };


    var cell = document.getElementById('q_table_16');
    
    cell.innerHTML = '16';
    cell.onclick = function() { pushHistory(16); };
    var cell = document.getElementById('q_table_17');
    
    cell.innerHTML = '17';
    cell.onclick = function() { pushHistory(17); };
    var cell = document.getElementById('q_table_18');
    
    cell.innerHTML = '18';
    cell.onclick = function() { pushHistory(18); };


    var cell = document.getElementById('q_table_19');
    
    cell.innerHTML = '19';
    cell.onclick = function() { pushHistory(19); };
    var cell = document.getElementById('q_table_20');
    
    cell.innerHTML = '20';
    cell.onclick = function() { pushHistory(20); };
    var cell = document.getElementById('q_table_21');
    
    cell.innerHTML = '21';
    cell.onclick = function() { pushHistory(21); };


    var cell = document.getElementById('q_table_22');
    
    cell.innerHTML = '22';
    cell.onclick = function() { pushHistory(22); };
    var cell = document.getElementById('q_table_23');
    
    cell.innerHTML = '23';
    cell.onclick = function() { pushHistory(23); };
    var cell = document.getElementById('q_table_24');
    
    cell.innerHTML = '24';
    cell.onclick = function() { pushHistory(24); };


    var cell = document.getElementById('q_table_25');
    
    cell.innerHTML = '25';
    cell.onclick = function() { pushHistory(25); };
    var cell = document.getElementById('q_table_26');
    
    cell.innerHTML = '26';
    cell.onclick = function() { pushHistory(26); };
    var cell = document.getElementById('q_table_27');
    
    cell.innerHTML = '27';
    cell.onclick = function() { pushHistory(27); };


    var cell = document.getElementById('q_table_28');
    
    cell.innerHTML = '28';
    cell.onclick = function() { pushHistory(28); };
    var cell = document.getElementById('q_table_29');
    
    cell.innerHTML = '29';
    cell.onclick = function() { pushHistory(29); };
    var cell = document.getElementById('q_table_30');
    
    cell.innerHTML = '30';
    cell.onclick = function() { pushHistory(30); };


    var cell = document.getElementById('q_table_31');
    
    cell.innerHTML = '31';
    cell.onclick = function() { pushHistory(31); };
    var cell = document.getElementById('q_table_32');
    
    cell.innerHTML = '32';
    cell.onclick = function() { pushHistory(32); };
    var cell = document.getElementById('q_table_33');
    
    cell.innerHTML = '33';
    cell.onclick = function() { pushHistory(33); };


    var cell = document.getElementById('q_table_34');
    
    cell.innerHTML = '34';
    cell.onclick = function() { pushHistory(34); };
    var cell = document.getElementById('q_table_35');
    
    cell.innerHTML = '35';
    cell.onclick = function() { pushHistory(35); };
    var cell = document.getElementById('q_table_36');
    
    cell.innerHTML = '36';
    cell.onclick = function() { pushHistory(36); };


    // Apply Styles 0
    var cell = document.getElementById('q_table_0');
    applyStyles(cell, q_styles['number_0']);

    // Apply styles 1-36
    for(var x=1; x<37;x++)
    {
      var cell = document.getElementById('q_table_'+x);
      applyStyles(cell, q_styles['number_block']);
      if(isRed(x))
      {
        
        applyStyles(cell, q_styles['redNum']);
      }else
      {
        applyStyles(cell, q_styles['blackNum']);
      }

    }

   

  }
 

  function isRed(num) {
    const redNumbers = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
    return redNumbers.includes(num);
}
