

function buildNumberHistory() {
	let historyContainer = document.createElement('div');
	historyContainer.setAttribute('id', 'historyContainer');

	let numberUpDisplay = document.createElement('span');
	numberUpDisplay.setAttribute('id', 'trigger-results-numberUp-container');

	let historyBoard = document.createElement('div');
	historyBoard.setAttribute('id', 'history');

	let button = document.createElement('button');
	button.id = 'undoButton';
	button.className = 'button-history';
	button.setAttribute('role', 'button');
	button.innerText = 'Undo';
	button.style.width = 'auto';
    button.style.height = '50px';
    button.style.marginBottom = '5px';
    button.style.marginTop = '5px';
    button.style.marginLeft = '10px';
    button.style.fontSize = '30px';
	button.onclick = undo;

	let label = document.createElement('span');
	label.id = 'spins';
	label.style.fontSize = '30px';
	label.style.marginLeft = '10px';
	label.innerText = numbers.length; 
	let spinDiv = document.createElement('div');
	spinDiv.appendChild(label);

	
	historyContainer.appendChild(spinDiv);
	historyContainer.appendChild(button);
	historyContainer.appendChild(historyBoard);
	historyContainer.appendChild(numberUpDisplay);
	return historyContainer;
}

function undo() {

	numberHistory.pop();
	numbers.pop();
	runAfterUpdates();
	

}

function oneRandomNumber() {
    var randomNumber = Math.floor(Math.random() * 37); // Generates a number from 0 to 36
    pushHistory(randomNumber);
}

function pushHistory(n) {

	numberHistory.push(n);
	numbers.push(n);
	runAfterUpdates();

}

function popHistory() {
	if (historyBankValue.length > 0) {
		historyBankValue.pop();
		historyCurrentBet.pop();
		historyWager.pop();
		historyLastWager.pop();
		historBet.pop();
		historyNumbersBet.pop();
		historyPreviousNumbers.pop();

		bankValue = historyBankValue[historyBankValue.length - 1];
		
		currentBet = historyCurrentBet[historyCurrentBet.length - 1];

		if (isNaN(bankValue)) bankValue = 1000;
		if (isNaN(currentBet)) currentBet = 0;

		document.getElementById('bankSpan').innerText = '' + bankValue.toLocaleString("en-GB") + '';
		document.getElementById('betSpan').innerText = '' + currentBet.toLocaleString("en-GB") + '';


	}



}

function showHistoryBoard() {

	let historyContainer = document.getElementById('history');
	if(historyContainer){
		historyContainer.innerText = '';
		for (var x = numberHistory.length-1; x >=0; x--) {
			let item = document.createElement('div');
			var colourClass = (numRed.includes(numberHistory[x])) ? ' historyRed' : ' historyBlack';
			if (numberHistory[x] == 0) colourClass = ' historyGreen';
	
			item.setAttribute('class', 'nbnHistory' + colourClass);
			item.innerText = numberHistory[x];
	
			historyContainer.append(item);
		}
	
		
	
		let spins = document.getElementById('spins');
		spins.innerHTML = numberHistory.length;
	}

}



