function legend() {
    // Create container div
    let container = document.createElement('div');
    container.style.fontSize = '30px';
    container.style.marginLeft = '100px';

    const headerTitle = document.createElement('h2');
    headerTitle.textContent = 'Color Legend';
    container.appendChild(headerTitle);

    // Create table element
    const table = document.createElement('table');
    table.id = 'legendTable';
table.style.borderCollapse = 'collapse';
table.style.width = 'auto';
table.style.maxWidth = '100%';
table.style.tableLayout = 'auto';
table.style.marginTop = '10px';

    // Create header row
    const headerRow = document.createElement('tr');
    const headerCell1 = document.createElement('th');
    headerCell1.textContent = 'Shape';
    headerCell1.style.textAlign = 'left';
    headerCell1.style.padding = '10px';
    const headerCell2 = document.createElement('th');
    headerCell2.textContent = 'Description';
    headerCell2.style.textAlign = 'left';
    headerCell2.style.padding = '10px';
    headerRow.appendChild(headerCell1);
    headerRow.appendChild(headerCell2);
    headerRow.style.borderBottom = '2px solid black';

    // Append header row to table
    table.appendChild(headerRow);

    // Styles and descriptions
    const styles = [
        { class: 'legend-hilight-outside-defined', description: 'Outside' },
        { class: 'legend-hilight-straight-defined', description: 'Straight' },
        { class: 'legend-hilight-unique-defined', description: 'Unique' },
        { class: 'legend-hilight-group-defined', description: 'Group' },
        { class: 'legend-hilight-split-down-defined', description: 'Split' },
        { class: 'legend-hilight-quad-defined', description: 'Quads' },
        { class: 'legend-hilight-street-defined', description: 'Street' },
        { class: 'legend-hilight-line-defined', description: 'Line' },
        { class: 'legend-sleeper-highlights', description: 'Sleepers' },
         { class: 'legend-hilight-outside-pattern', description: 'Pattern Break' },
        
    ];

    styles.forEach(style => {
        const row = document.createElement('tr');

        // First column: Shape
        const shapeCell = document.createElement('td');
        const shapeDiv = document.createElement('div');
        shapeDiv.classList.add(style.class);
        shapeDiv.classList.add('legend-shape'); // Apply the legend-shape class to the shape div
        shapeCell.appendChild(shapeDiv);
        shapeCell.style.padding = '10px';
        shapeCell.style.backgroundColor = 'darkslategrey';

        // Second column: Description
        const descriptionCell = document.createElement('td');
        descriptionCell.textContent = style.description;
        descriptionCell.style.textAlign = 'left';
descriptionCell.style.padding = '10px';
descriptionCell.style.whiteSpace = 'nowrap'; 

        // Append cells to row
        row.appendChild(shapeCell);
        row.appendChild(descriptionCell);
        row.style.borderBottom = '1px solid #ddd';

        // Append row to table
        table.appendChild(row);
    });

    // Append table to container
    container.appendChild(table);

     // Append table to container
    container.appendChild(table);

    // ---- Zoom Buttons ----
    const zoomDiv = document.createElement('div');
    zoomDiv.style.margin = '10px';

    const zoomInButton = document.createElement('button');
    zoomInButton.textContent = 'Zoom 50%';
    zoomInButton.onclick = () => document.body.style.zoom = '50%';
    Object.assign(zoomInButton.style, {
        width: 'auto',
        height: '50px',
        margin: '5px 10px',
        fontSize: '30px'
    });

    const zoomOutButton = document.createElement('button');
    zoomOutButton.textContent = 'Zoom 100%';
    zoomOutButton.onclick = () => document.body.style.zoom = '100%';
    Object.assign(zoomOutButton.style, {
        width: 'auto',
        height: '50px',
        margin: '5px 10px',
        fontSize: '30px'
    });

    zoomDiv.appendChild(zoomInButton);
    zoomDiv.appendChild(zoomOutButton);
    container.appendChild(zoomDiv);

    // ---- Color Picker ----
    const colorDiv = document.createElement('div');
    colorDiv.style.margin = '10px';

    const colorLabel = document.createElement('label');
    colorLabel.textContent = 'Background Color:';
    colorLabel.style.fontSize = '30px';
    colorLabel.setAttribute('for', 'colorPicker');

    const colorInput = document.createElement('input');
    colorInput.type = 'color';
    colorInput.id = 'colorPicker';
    Object.assign(colorInput.style, {
        width: '100px',
        height: '50px',
        marginLeft: '10px'
    });

    colorInput.addEventListener('input', () => {
        document.body.style.backgroundColor = colorInput.value;
    });

    colorDiv.appendChild(colorLabel);
    colorDiv.appendChild(colorInput);
    container.appendChild(colorDiv);

    // ---- Desktop Note ----
    const desktopNote = document.createElement('div');
    desktopNote.style.margin = '10px';

    const noteSpan = document.createElement('span');
    noteSpan.textContent = ' - Note: Press single 0 for double 00 tables, and zoom out 50% if you want to make window smaller on desktop to go side by side with your casino.';
    noteSpan.style.fontSize = '24px';

    desktopNote.appendChild(noteSpan);
    container.appendChild(desktopNote);

    return container;
}
