
let bounceNumber = 2;
let nBounce = [];
let d1d2 = [];
let d1d3 = [];
let d2d1 = [];
let d2d3 = [];
let d3d1 = [];
let d3d2 = [];
let helpBouncy = false;
let bouncyDisplay = false;

function bounce() {

    let container = document.createElement('div');
    container.style.marginLeft = '25px';
    container.style.marginBottom = '15px';
    container.style.fontSize = '30px';



    let titleDiv = document.createElement('div');
    titleDiv.style.display = 'flex'; 
    titleDiv.style.alignItems = 'center';
    titleDiv.style.marginLeft = '25px';

    
    // Create the title span
    let titleSpan = document.createElement('span');
    titleSpan.innerHTML = '<h2>Bouncy Dozen</h2>';
    titleSpan.style.marginRight = '10px'; 
    
    // Create the help button
    const button = document.createElement('button');
    button.id = 'how-to-bouncy';
    button.textContent = "How to";
    button.style.padding = '5px';
    button.style.marginRight = '5px';
    button.style = 'width: auto; height: 50px; margin: 5px 10px 5px 10px; font-size: 30px;';
    button.onclick = toggleButtonHelpBouncy;
    

    var bouncyCheckbox = document.createElement('input');
	bouncyCheckbox.type = 'checkbox';
	bouncyCheckbox.id = "bouncy-display";
	bouncyCheckbox.name = "bouncyDisplay";
	bouncyCheckbox.placeholder = "";
    bouncyCheckbox.checked = bouncyDisplay;
    
    bouncyCheckbox.style.marginTop = '-30px';
    bouncyCheckbox.style.marginLeft = '10px';
    bouncyCheckbox.style.transform = 'scale(4)';
    bouncyCheckbox.style.transformOrigin = 'top left';
    bouncyCheckbox.style.marginRight = '35px';

    bouncyCheckbox.addEventListener('change', function() {
        bouncyDisplay = this.checked;
        appendOrRemoveAlert();
        clickFirstButton();
    });


	// Group Label
	var bouncyCheckboxLabel = document.createElement('label');
	bouncyCheckboxLabel.htmlFor = 'bouncy-display';
    bouncyCheckboxLabel.style.marginLeft = '15px';
    bouncyCheckboxLabel.style.fontSize = '35px';
    bouncyCheckboxLabel.style.marginLeft = '10px';
	bouncyCheckboxLabel.appendChild(document.createTextNode('Show on board tab.'));


    // Append the title span and button to the title div
    titleDiv.appendChild(titleSpan);
    titleDiv.appendChild(button);
    titleDiv.appendChild(bouncyCheckbox);
    titleDiv.appendChild(bouncyCheckboxLabel);
    


    const numberInput = document.createElement('input');
    style_textbox_container(numberInput);
    numberInput.type = 'number';
    numberInput.id = 'number-input-bouncy';
    numberInput.value = bounceNumber

// Add event listener for the input event
//numberInput.addEventListener('input', bouncyUpdate);
    // Button 1
    let LookBackButton = document.createElement('button');
    LookBackButton.id = 'update-bouncy-button';
    LookBackButton.textContent = 'Update';
    LookBackButton.style = 'width: auto; height: 50px; margin: 5px 10px 5px 10px; font-size: 30px;';
    if (LookBackButton) { LookBackButton.onclick = bouncyUpdate; }

// Create the alert div
let alert = document.createElement('div');
alert.id = 'bounce-alert';
alert.style.border = '5px solid yellow'; 
alert.style.padding = '5px'; 
alert.style.display = 'none';


// Create a container to hold both elements
const containerInput = document.createElement('div');
containerInput.id = 'input-alert-container';
containerInput.style.marginLeft = '25px';
containerInput.style.marginBottom = '10px';
containerInput.appendChild(numberInput);
containerInput.appendChild(LookBackButton);
containerInput.appendChild(alert);

// Apply styles using JavaScript
containerInput.style.display = 'flex';
containerInput.style.alignItems = 'center';
containerInput.style.gap = '10px'; 

    
let helpDiv = document.createElement('div');
helpDiv.id = 'help-bouncy';
helpDiv.style.marginLeft = '25px';
helpDiv.style.marginBottom = '15px';



    let contentDiv = document.createElement('div');
    contentDiv.id = 'bounceDiv';
    contentDiv.style.marginLeft = '25px';
    contentDiv.style.marginBottom = '15px';

    let newLine = document.createElement('br');

    
    container.appendChild(titleDiv);
    container.appendChild(helpDiv);
    container.appendChild(containerInput);
    container.appendChild(newLine);
    container.appendChild(contentDiv);
    container.appendChild(newLine);
    container.appendChild(newLine);
    

    return container;

}
function bouncyUpdate(event) {
    handleInputChangeBounce(event);
    handleWinCondition(event);
    appendOrRemoveAlert();
}

function detectDozenBounce() {
    const bounceCount = parseInt(document.getElementById('bounceCount').value);
    const bounceType = document.getElementById('bounceType').value.split(' - ');

    let streak = [];
    let dozenStreak = [];

    for (number in numbers) {
        const dozen = getDozen(number);
        if (dozen !== '0') {
            if (streak.length < 2) {
                streak.push(dozen);
            } else {
                if (dozen !== streak[streak.length - 1]) {
                    if (streak.length > 1 && dozen === streak[streak.length - 2]) {
                        streak.push(dozen);
                        dozenStreak.push(number);
                        if (streak.length === bounceCount + 1 && streak[0] === bounceType[0] && streak[1] === bounceType[1]) {
                            alertDiv.textContent = `Dozen bounce detected: ${streak.slice(-bounceCount).join(' - ')} (${dozenStreak.slice(-bounceCount).join(', ')})`;
                            alertDiv.style.display = 'block';
                            streak = [];
                            dozenStreak = [];
                        }
                    } else {
                        streak = [streak[streak.length - 1], dozen];
                        dozenStreak = [dozenStreak[dozenStreak.length - 1], number];
                    }
                } else {
                    streak = [streak[streak.length - 1]];
                    dozenStreak = [dozenStreak[dozenStreak.length - 1]];
                }
            }
        }
    }
}
function getColor(number) {
    if (number === 0) return 'green';
    return red.includes(number) ? 'red' : 'black';
}

function getDozen(number) {
    if (number >= 1 && number <= 12) return 1;
    if (number >= 13 && number <= 24) return 2;
    if (number >= 25 && number <= 36) return 3;
    return 0;
}

function calculateBounce() {
    let container = document.createElement('div');
    container.style.fontSize = '30px';

var displayTable = "<table border=1>";
/*
displayTable += "<tr>";
displayTable += "<th colspan=4 style='padding: 8px;'> " + bounceNumber + "</th>";
displayTable += "</tr>";
displayTable += "<tr>";
displayTable += "<th style='padding: 8px;'> Spots </th>";
displayTable += "<th style='padding: 8px;'> Bet </th>";
displayTable += "<th style='padding: 8px;'> Profit </th>";
displayTable += "<th style='padding: 8px;'> Cost </th>";
displayTable += "</tr>";
*/
let bounceLength = (bounceNumber*2)-1;
let numbersLength =  (bounceNumber*2)-1;
if(numbers.length<numbersLength)
    {
        numbersLength = numbers.length;
    }



d1d2 = [];
d1d3 = [];
d2d1 = [];
d2d3 = [];
d3d1 = [];
d3d2 = [];
nBounce = [];

for(var x=numbersLength; x>0; x--)
{

        nBounce.push(getDozen(numbers[numbers.length-x]));
 
    
}

for(var x=0; x<bounceLength; x++)
{
    d1d2.push(x % 2 === 0 ? 1 : 2);
    d1d3.push(x % 2 === 0 ? 1 : 3);
    d2d1.push(x % 2 === 0 ? 2 : 1);
    d2d3.push(x % 2 === 0 ? 2 : 3);
    d3d1.push(x % 2 === 0 ? 3 : 1);
    d3d2.push(x % 2 === 0 ? 3 : 2);
}

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>Numbers</td>";

for(var x=numbersLength; x>0; x--)
    {
        displayTable += "<td style='padding: 8px;'>"+numbers[numbers.length-x]+"</td>";
    }
    displayTable += "</tr>";



displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D1 D2</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(2,"D2",x);
    }
    else
    {
        displayTable += getBackground(1,"D1",x);
    }
    
}
displayTable += "</tr>";

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D1 D3</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(3,"D3",x);
    }
    else
    {
        displayTable += getBackground(1,"D1",x);
    }
    
}
displayTable += "</tr>";

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D2 D1</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(1,"D1",x);
    }
    else
    {
        displayTable += getBackground(2,"D2",x);
    }
    
}
displayTable += "</tr>";

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D2 D3</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(3,"D3",x);
    }
    else
    {
        displayTable += getBackground(2,"D2",x);
    }
    
}
displayTable += "</tr>";

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D3 D1</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(1,"D1",x);
    }
    else
    {
        displayTable += getBackground(3,"D3",x);
    }
    
}
displayTable += "</tr>";

displayTable += "<tr>";
displayTable += "<td style='padding: 8px;'>D3 D2</td>"; 
for(var x=0; x<bounceLength; x++)
{
    if(x%2==1)
    {
        displayTable += getBackground(2,"D2",x);
    }
    else
    {
        displayTable += getBackground(3,"D3",x);
    }
    
}
displayTable += "</tr>";

displayTable += "</table>";

    let tableDiv = document.createElement('div');
    tableDiv.innerHTML = displayTable;
    container.appendChild(tableDiv);
    return container;
}
function handleInputChangeBounce() {
  
    let bouncyNumber = document.getElementById('number-input-bouncy');
    if(bouncyNumber)
    {
        if ( isNaN(bouncyNumber.value) || bouncyNumber.value < 2)
            {
                bouncyNumber.value = 2;
            }
            if (bouncyNumber.value) {
                bounceNumber = bouncyNumber.value;
               
            } else {
                bounceNumber = 2;
            }
        
                let content = calculateBounce();
         
                let contentFromButtonClick = document.getElementById('bounceDiv');
                if(contentFromButtonClick)
                {
                    contentFromButtonClick.innerHTML = ''; 
                    contentFromButtonClick.appendChild(content); 
                }
    }


}
function handleWinCondition()
{
    let alertBox = document.getElementById('bounce-alert');
    
    if(alertBox)
    {
        alertBox.style.display = 'none';
        alertBox.innerHTML = '';
        if(arraysEqual(d1d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 3";
        if(arraysEqual(d1d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 2";
        if(arraysEqual(d2d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2 <br/>Bet Dozen 3";
        if(arraysEqual(d2d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 2";
        if(arraysEqual(d3d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2 <br/>Bet Dozen 3";
        if(arraysEqual(d3d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 3";

        if(!(alertBox.innerHTML ===''))
        {
            alertBox.style.display = 'block';
        }
    }

    //Show alert above Board

    return;
}
function getBackground(dozenNumber,dozenText,x)
{
    let displayTable = '';
    if(nBounce.length>0)
    {
        if(nBounce[x]==dozenNumber && dozenNumber>0)
        {
            displayTable = "<td style='padding: 8px; background-color: yellow'>"+dozenText+"</td>";
        }
        else
        {
            displayTable = "<td style='padding: 8px;'>"+dozenText+"</td>"; 
        }
    }
    return displayTable;
}

function arraysEqual(A, B) {
    if (A.length !== B.length) return false;
    return A.every((value, index) => value === B[index]);
}

function toggleButtonHelpBouncy() {
    const button = document.getElementById(`how-to-bouncy`);
    if(button)
    {
        helpBouncy = !helpBouncy; 
        button.style.backgroundColor = helpBouncy ? 'lightgreen' : ''; 
        
        let helpDiv = document.getElementById('help-bouncy');
        helpDiv.innerHTML = ''; 
        
        if (helpBouncy) {
            const img = document.createElement('img');
            img.src = 'items/bouncyHelp.png';
            img.alt = 'Help Image'; 

            img.onerror = function() {
                console.error('Failed to load image: ' + img.src);
                // Additional diagnostic information
                console.log('Current directory: ' + window.location.href);
            };
            helpDiv.appendChild(img); 
        }
    }

}

function appendOrRemoveAlert_old() {
    var timerDiv = document.getElementById('bouncy-display-top');
    var bounceAlertDiv = document.getElementById('bounce-alert-top');

    if(timerDiv)
    {
        
        if(bouncyDisplay && !bounceAlertDiv)
        {
           
            var alertBox = document.createElement('div');
            alertBox.id = 'bouncy-alert-sticky';
            alertBox.style.border = '5px solid yellow'; 
            alertBox.style.padding = '10px'; 
            alertBox.style.paddingRight = '15px'; 
            alertBox.style.display = 'inline-flex'; // Use inline-flex to shrink to fit content
            alertBox.style.flex = '0'; // Ensure it doesn't stretch
            alertBox.style.whiteSpace = 'nowrap';
            alertBox.style.marginRight = '5px';
            alertBox.style.marginLeft = '5px';


            alertBox.innerHTML = '';
            if(arraysEqual(d1d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 3";
            if(arraysEqual(d1d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d2d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d2d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d3d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d3d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 3";
            if(alertBox.innerHTML === '')  alertBox.style.display = 'none';
        
            bottomStickyBox.appendChild(alertBox);
        }
        else {
          
            if(bouncyDisplay && bounceAlertDiv)
            {
                
                bounceAlertDiv.innerHTML = '';
                if(arraysEqual(d1d2, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 3";
                if(arraysEqual(d1d3, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 2";
                if(arraysEqual(d2d1, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 2 <br/>Bet Dozen 3";
                if(arraysEqual(d2d3, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 2";
                if(arraysEqual(d3d1, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 2 <br/>Bet Dozen 3";
                if(arraysEqual(d3d2, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1 <br/>Bet Dozen 3";
                bounceAlertDiv.style.display = 'block';
                if(bounceAlertDiv.innerHTML === '')  bounceAlertDiv.style.display = 'none';

            }else
            {
                
                if(bounceAlertDiv)
                {
                    
                    bounceAlertDiv.style.display = 'none';
                }
            }
        };
        
    }
   
}

function appendOrRemoveAlert() {
   
    let bounceAlertDiv = document.getElementById('bounce-alert');

    var bottomStickyBox = document.getElementById('sticky-bottom-alert');
    var bouncyAlertSticky = document.getElementById('bouncy-alert-sticky');
    if (bouncyAlertSticky) {
        bottomStickyBox.removeChild(bouncyAlertSticky);
    }


        
        if(bouncyDisplay)
        {
           
            var alertBox = document.createElement('div');
            alertBox.id = 'bouncy-alert-sticky';
            alertBox.style.border = '5px solid yellow'; 
            alertBox.style.color = 'black';
            alertBox.style.padding = '10px'; 
            alertBox.style.paddingRight = '15px'; 
            alertBox.style.display = 'inline-flex'; // Use inline-flex to shrink to fit content
            alertBox.style.flex = '1'; // Ensure it doesn't stretch
            //alertBox.style.whiteSpace = 'nowrap';
            alertBox.style.marginRight = '5px';
            alertBox.style.marginLeft = '5px';
            alertBox.style.fontSize = '50px';
            alertBox.style.fontWeight = 'bold';


            alertBox.innerHTML = '';
            if(arraysEqual(d1d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 3";
            if(arraysEqual(d1d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d2d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d2d3, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d3d1, nBounce)) alertBox.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d3d2, nBounce)) alertBox.innerHTML = "Bet Dozen 1, 3";
            if(alertBox.innerHTML === '')  alertBox.style.display = 'none';
        
            bottomStickyBox.appendChild(alertBox);
        }
        if(bounceAlertDiv)
        {
            
            bounceAlertDiv.innerHTML = '';
            if(arraysEqual(d1d2, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1, 3";
            if(arraysEqual(d1d3, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d2d1, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d2d3, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1, 2";
            if(arraysEqual(d3d1, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 2, 3";
            if(arraysEqual(d3d2, nBounce)) bounceAlertDiv.innerHTML = "Bet Dozen 1, 3";
            bounceAlertDiv.style.display = 'block';
            bounceAlertDiv.style.whiteSpace = 'nowrap';
            bounceAlertDiv.style.paddingRight = '15px';
            if(bounceAlertDiv.innerHTML === '')  bounceAlertDiv.style.display = 'none';

        }
  
        
 }