function update_roulette_table() {
  let content = document.getElementById('roulette-table-container');
  if (content) {
      content.innerHTML = '';
      let item = rouletteTable();
      content.appendChild(item);

  }
}
function rouletteTable(){
  let mainContainer = document.createElement('div');
  mainContainer.id = 'roulette-table-container';



  let bettingBoard = document.createElement('div');


  


  //document.createElement('sticky-bottom').hidden = 'true';

  let numberBoard = getRouletteTable();
  bettingBoard.appendChild(numberBoard);



  mainContainer.appendChild(bettingBoard);

  if(bouncyDisplay)
  {
    console.log("BOUNCE BOARD");
    let bouncy = bounce();
    mainContainer.appendChild(bouncy);
    bouncyUpdate();
  }
  if(highLightChecked)
  {
    let frequencyChart = showSleeperChart();
    mainContainer.appendChild(frequencyChart);
   

  }

  if(even_checkbox)
  {
    let itemEvenContainer = document.createElement('div');
    itemEvenContainer.id = 'board_stats_even';
    let item = evens_page();
    itemEvenContainer.appendChild(item);
    mainContainer.appendChild(itemEvenContainer);
  }

  if(dozen_checkbox)
    {
      let itemEvenContainer = document.createElement('div');
      itemEvenContainer.id = 'board_stats_dozen';
      let item = dozens_page();
      itemEvenContainer.appendChild(item);
      mainContainer.appendChild(itemEvenContainer);
    }

    if(combo_checkbox)
      {
        let itemEvenContainer = document.createElement('div');
        itemEvenContainer.id = 'board_stats_combo';
        let item = combo_page();
        itemEvenContainer.appendChild(item);
        mainContainer.appendChild(itemEvenContainer);
      }
      if(street_checkbox)
        {
          let itemEvenContainer = document.createElement('div');
          itemEvenContainer.id = 'board_stats_street';
          let item = street_page();
          itemEvenContainer.appendChild(item);
          mainContainer.appendChild(itemEvenContainer);
        }

        if(line_checkbox)
          {
            let itemEvenContainer = document.createElement('div');
            itemEvenContainer.id = 'board_stats_line';
            let item = line_page();
            itemEvenContainer.appendChild(item);
            mainContainer.appendChild(itemEvenContainer);
          }

  let boardWatchAlert = document.createElement('div');
  boardWatchAlert.id = 'board-watch-alert';
  let watchAlert = display_alerts();
  boardWatchAlert.appendChild(watchAlert);
  mainContainer.appendChild(boardWatchAlert);

  requestAnimationFrame(runAfterUpdates);

  return mainContainer
}
function getRouletteTable() {
  const container = document.createElement('div');
  container.style.fontSize = '37px';
  container.style.paddingTop = '10px';
  const table = document.createElement('div');
  table.id = 'gridContainer';

  const backgroundColorRed = '#eb3838';
  const backgroundColorBlack = '#2e2c2b';
  const numberColor = 'rgb(255, 255, 255';

  const redNumbers = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
  const blackNumbers = [26, 35, 28, 29, 22, 31, 20, 33, 24, 10, 8, 11, 13, 6, 17, 2, 4, 15];

  if(highLightChecked)
  {
   // let messageDiv = document.createElement('div');
   // messageDiv.id = 'messageDiv';
    //let count = getSleeperCount();
   // messageDiv.appendChild(count);
   // container.appendChild(messageDiv);
    
  }

  //-----------------------------------------------------------------------------
  // Row 1
  //------------------------------------------------------------------------------

  // Row 1 - Blank
  var cell = makeCell('1_1');
  cell.style.backgroundColor = 'transparent'; // Optional: set background to transparent
  cell.style.border = 'none';
  table.appendChild(cell);

  // Row 1 - Blank
  var cell = makeCell('1_2');
  cell.style.backgroundColor = 'transparent'; // Optional: set background to transparent
  cell.style.border = 'none';
  table.appendChild(cell);

  // Row 1 - Zero
  var cell = makeCell('0');
  cell.style.gridColumn = '3 / span 3'; // Spanning 3 columns starting from column 3
  var textSpan = document.createElement('span');
  textSpan.innerText = '0';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 1: 4,5 Not needed

  // Row 1:6
  var cell = document.createElement('div');
  cell.classList.add('grid-cell');
  cell.id = `spinContainer`;
  cell.style.gridColumn = '6'; 
  cell.style.gridRow = '1 / span 14'; 
  cell.style.display = 'flex';
  cell.style.flexDirection = 'column';
  cell.style.alignItems = 'flex-start'; 
  cell.style.justifyContent = 'flex-start';
  cell.style.paddingLeft = '5px';
  cell.style.paddingRight = '5px';

  let numberHistory = buildNumberHistory();
  cell.appendChild(numberHistory);

  table.appendChild(cell);

  //-----------------------------------------------------------------------------
  // Row 2
  //-----------------------------------------------------------------------------

  // Row 2:1 (1-18)
  var cell = makeCell('Low');
  cell.style.gridColumn = '1'; // Ensure it's in the 1st column
  cell.style.gridRow = '2 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = '1 - 18';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 2:2 (Doz1)
  var cell = makeCell('Dozen1');
  cell.style.gridColumn = '2'; // Ensure it's in the 6th column
  cell.style.gridRow = '2 / span 4'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center';
  var textSpan = document.createElement('span');
  textSpan.innerText = '1st 12';
  textSpan.style.display = 'inline-block';
  textSpan.style.transform = 'rotate(90deg)';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 2:3 
  var cell = makeCell('1');
  table.appendChild(cell);

  // Row 2:4 
  var cell = makeCell('2');
  table.appendChild(cell);

  // Row 2:5 
  var cell = makeCell('3');
  table.appendChild(cell);

  // Row 2:6- not used, spanned spinContainer


  //-----------------------------------------------------------------------------
  // Row 3
  //-----------------------------------------------------------------------------

  // Row 3:1 (1-18) - spanned not used

  // Row 3:2 (Doz1)  - spanned not used

  // Row 3:3 
  var cell = makeCell('4');
  table.appendChild(cell);

  // Row 3:4 
  var cell = makeCell('5');
  table.appendChild(cell);

  // Row 3:5 
  var cell = makeCell('6');
  table.appendChild(cell);

  // Row 3:6- not used, spanned spinContainer


  //-----------------------------------------------------------------------------
  // Row 4
  //-----------------------------------------------------------------------------

  // Row 4:1 Even
  var cell = makeCell('Even');
  cell.style.gridColumn = '1'; // Ensure it's in the 6th column
  cell.style.gridRow = '4 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Even';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 4:2 (Doz1)  - spanned not used

  // Row 4:3 
  var cell = makeCell('7');
  table.appendChild(cell);

  // Row 4:4 
  var cell = makeCell('8');
  table.appendChild(cell);

  // Row 4:5 
  var cell = makeCell('9');
  table.appendChild(cell);

  // Row 4:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 5
  //-----------------------------------------------------------------------------

  // Row 5:1 Even - spanned not used

  // Row 5:2 (Doz1)  - spanned not used

  // Row 5:3 
  var cell = makeCell('10');
  table.appendChild(cell);

  // Row 5:4 
  var cell = makeCell('11');
  table.appendChild(cell);

  // Row 5:5 
  var cell = makeCell('12');
  table.appendChild(cell);

  // Row 5:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 6
  //-----------------------------------------------------------------------------

  // Row 6:1 (Red)
  var cell = makeCell('Red');
  cell.style.gridColumn = '1'; // Ensure it's in the 6th column
  cell.style.gridRow = '6 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'Red';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Red';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 6:2 (Doz2)
  var cell = makeCell('Dozen2');
  cell.style.gridColumn = '2'; // Ensure it's in the 6th column
  cell.style.gridRow = '6 / span 4'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center';
  var textSpan = document.createElement('span');
  textSpan.innerText = '2nd 12';
  textSpan.style.display = 'inline-block';
  textSpan.style.transform = 'rotate(90deg)';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 6:3 
  var cell = makeCell('13');
  table.appendChild(cell);

  // Row 6:4 
  var cell = makeCell('14');
  table.appendChild(cell);

  // Row 6:5 
  var cell = makeCell('15');
  table.appendChild(cell);

  // Row 6:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 7
  //-----------------------------------------------------------------------------

  // Row 7:1 (Red) - spanned not used

  // Row 7:2 (Doz2)  - spanned not used

  // Row 7:3 
  var cell = makeCell('16');
  table.appendChild(cell);

  // Row 7:4 
  var cell = makeCell('17');
  table.appendChild(cell);

  // Row 7:5 
  var cell = makeCell('18');
  table.appendChild(cell);

  // Row 7:6- not used, spanned spinContainer


  //-----------------------------------------------------------------------------
  // Row 8
  //-----------------------------------------------------------------------------

  // Row 8:1 Black
  var cell = makeCell('Black');
  cell.style.gridColumn = '1'; // Ensure it's in the 6th column
  cell.style.gridRow = '8 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'black';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Black';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 8:2 (Doz2)  - spanned not used

  // Row 8:3 - 1
  var cell = makeCell('19');
  table.appendChild(cell);

  // Row 8:4 - 2
  var cell = makeCell('20');
  table.appendChild(cell);

  // Row 8:5 - 3
  var cell = makeCell('21');
  table.appendChild(cell);

  // Row 8:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 9
  //-----------------------------------------------------------------------------

  // Row 9:1 Black - spanned not used

  // Row 9:2 (Doz2)  - spanned not used

  // Row 9:3 - 1
  var cell = makeCell('22');
  table.appendChild(cell);

  // Row 9:4 - 2
  var cell = makeCell('23');
  table.appendChild(cell);

  // Row 9:5 - 3
  var cell = makeCell('24');
  table.appendChild(cell);

  // Row 9:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 10
  //-----------------------------------------------------------------------------

  // Row 10:1 (Odd)
  var cell = makeCell('Odd');
  cell.style.gridColumn = '1'; // Ensure it's in the 6th column
  cell.style.gridRow = '10 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Odd';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 10:2 (Doz3)
  var cell = makeCell('Dozen3');
  cell.style.gridColumn = '2';
  cell.style.gridRow = '10 / span 4';
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center';
  var textSpan = document.createElement('span');
  textSpan.innerText = '3rd 12';
  textSpan.style.display = 'inline-block';
  textSpan.style.transform = 'rotate(90deg)';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 10:3 
  var cell = makeCell('25');
  table.appendChild(cell);

  // Row 10:4 
  var cell = makeCell('26');
  table.appendChild(cell);

  // Row 10:5 
  var cell = makeCell('27');
  table.appendChild(cell);

  // Row 10:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 11
  //-----------------------------------------------------------------------------

  // Row 11:1 (Odd) - spanned not used

  // Row 11:2 (Doz3)  - spanned not used

  // Row 11:3 
  var cell = makeCell('28');
  table.appendChild(cell);

  // Row 11:4 
  var cell = makeCell('29');
  table.appendChild(cell);

  // Row 11:5 
  var cell = makeCell('30');
  table.appendChild(cell);

  // Row 11:6- not used, spanned spinContainer


  //-----------------------------------------------------------------------------
  // Row 12
  //-----------------------------------------------------------------------------

  // Row 12:1 (19-36)
  var cell = makeCell('High');
  cell.style.gridColumn = '1'; // Ensure it's in the 6th column
  cell.style.gridRow = '12 / span 2'; // Starts at row 2 and spans 2 rows
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = '19 - 36';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 12:2 (Doz3)  - spanned not used

  // Row 12:3 
  var cell = makeCell('31');
  table.appendChild(cell);

  // Row 12:4 
  var cell = makeCell('32');
  table.appendChild(cell);

  // Row 12:5 
  var cell = makeCell('33');
  table.appendChild(cell);

  // Row 12:6- not used, spanned spinContainer

  //-----------------------------------------------------------------------------
  // Row 13
  //-----------------------------------------------------------------------------

  // Row 13:1 (19-36) - spanned not used

  // Row 13:2 (Doz3)   - spanned not used

  // Row 13:3 - 1
  var cell = makeCell('34');
  table.appendChild(cell);

  // Row 13:4 - 2
  var cell = makeCell('35');
  table.appendChild(cell);

  // Row 13:5 - 3
  var cell = makeCell('36');
  table.appendChild(cell);

  // Row 13:6- not used, spanned spinContainer

    //-----------------------------------------------------------------------------
  // Row 14
  //-----------------------------------------------------------------------------

 // Row 14 - Blank
 var cell = makeCell('1_1');
 cell.style.backgroundColor = 'transparent'; // Optional: set background to transparent
 cell.style.border = 'none';
 table.appendChild(cell);

 // Row 14 - Blank
 var cell = makeCell('1_2');
 cell.style.backgroundColor = 'transparent'; // Optional: set background to transparent
 cell.style.border = 'none';
 table.appendChild(cell);

  // Row 13: - 3
  var cell = makeCell('Row1');
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Row 1';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 13: - 4
  var cell = makeCell('Row2');
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Row 2';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 14: - 5
  var cell = makeCell('Row3');
  cell.style.backgroundColor = 'green';
  cell.style.textAlign = 'center'; // Use 'center' for text alignment
  var textSpan = document.createElement('span');
  textSpan.innerText = 'Row 3';
  textSpan.style.display = 'inline-block';
  textSpan.style.transformOrigin = 'center';
  cell.appendChild(textSpan);
  table.appendChild(cell);

  // Row 14:6- not used, spanned spinContainer

  table.appendChild(cell);

  container.appendChild(table);

  requestAnimationFrame(set_dataValues_line);
  requestAnimationFrame(set_dataValues_street);
  requestAnimationFrame(set_dataValues_split_row);
  requestAnimationFrame(set_dataValues_split_col);
  requestAnimationFrame(set_dataValues_quad);

  return container;
}


function makeCell(id) {
  const cell = document.createElement('div');
  cell.classList.add('grid-cell');
  cell.id = `cell_` + id;
  cell.style.backgroundColor = 'green';

  if(id === '1_1' || id === '1_2')
    {
      return cell;
    }


    if (redNumbers.includes(parseInt(id))) {
      cell.style.backgroundColor = backgroundColorRed;

      const textNode = document.createTextNode(id);
      
      // Clear existing content
      cell.innerHTML = '';

      // Apply the single-digit class if necessary
      if (id > 0 && id < 10) {
          const span = document.createElement('span');
          span.className = 'single-digit';
          span.appendChild(textNode);
          cell.appendChild(span);
      } else {
          cell.appendChild(textNode);
      }
  }

  if (blackNumbers.includes(parseInt(id))) {
      cell.style.backgroundColor = backgroundColorBlack;
     const textNode = document.createTextNode(id);
      
      // Clear existing content
      cell.innerHTML = '';

      // Apply the single-digit class if necessary
      if (id > 0 && id < 10) {
          const span = document.createElement('span');
          span.className = 'single-digit';
          span.appendChild(textNode);
          cell.appendChild(span);
      } else {
          
            
            cell.appendChild(textNode);
          
      }
  }

  // Create overlays and other divs inside each cell
  const cellStraight = document.createElement('div');
  const cellQuad = document.createElement('div');
  const cellSplitAcross = document.createElement('div');
  const cellSplitDown = document.createElement('div');
  const cellUnique = document.createElement('div');
  const cellUser = document.createElement('div');
  const cellSleeper = document.createElement('div');
  const cellStreet = document.createElement('div');
  const cellLine = document.createElement('div');
  const cellPattern = document.createElement('div');
  const cellClick = document.createElement('div');

  // Assign IDs
  cellStraight.id = `cellStraight_` + id;
  cellStraight.setAttribute('data-values', [id]);
  cellUnique.id = `cellUnique_` + id;
  cellUnique.setAttribute('data-values', [id]);
  cellUser.id = `cellUser_` + id;
  cellUser.setAttribute('data-values', [id]);
  cellSleeper.id = `cellSleeper_` + id;
  cellSleeper.setAttribute('data-values', [id]);
  cellPattern.id = `cellPattern_` + id;

  cellQuad.id = `cellQuad_` + id;
  cellSplitAcross.id = `cellSplitAcross_` + id;
  cellSplitDown.id = `cellSplitDown_` + id;
  cellStreet.id = `cellStreet_` + id;
  cellLine.id = `cellLine_` + id;

  cellClick.id = `cellClick_` + id;

  // Overlay to click on
  cellClick.classList.add('overlay');
  cellClick.onclick = handleCellClick;

  // Append elements to cell
  cell.appendChild(cellStraight);
  cell.appendChild(cellQuad);
  cell.appendChild(cellSplitAcross);
  cell.appendChild(cellSplitDown);
  cell.appendChild(cellUnique);
  cell.appendChild(cellUser);
  cell.appendChild(cellSleeper);
  cell.appendChild(cellStreet);
  cell.appendChild(cellLine);
  cell.appendChild(cellPattern);
  cell.appendChild(cellClick);

  

  return cell;
}

function handleCellClick(event) {

    // Get the ID of the clicked cell
    var cellId = event.target.id;

    // Use a regular expression to extract the number part
    var match = cellId.match(/cellClick_(\d+)/);
  
    if (match) {
      // If there's a match, convert the number part to an integer
      var number = parseInt(match[1], 10);
      pushHistory(number);
    } else {
      // If there's no number part, ignore the item

      
    }

/*
  let item = document.getElementById('q_num');
  if(item){

    let n = item.value;
    n = ensureRouletteNumber(n);
    pushHistory(n);
  }
*/
  // Additional actions can be performed based on the clicked cell
}



function set_dataValues_quad() { 
  const itemIds = quad_ids();
  const itemIdsDataValue = quad_dataset();

  applyDataValues(itemIds,itemIdsDataValue);
}

function set_dataValues_split_col() { 
  const itemIds = split_row_ids();

  const itemIdsDataValue = split_row_dataset();


  applyDataValues(itemIds,itemIdsDataValue);
}

function set_dataValues_split_row() { 
  const itemIds = split_col_ids();

  const itemIdsDataValue = split_col_dataset();


  applyDataValues(itemIds,itemIdsDataValue);
}

function set_dataValues_line() { 
  const itemIds = [
    "cellLine_1",
    "cellLine_7",
    "cellLine_13",
    "cellLine_19",
    "cellLine_25",
    "cellLine_31"
];
  const itemIdsDataValue = [
    "1, 2, 3, 4, 5, 6",
    "7, 8, 9, 10, 11, 12",
    "13, 14, 15, 16, 17, 18",
    "19, 20, 21, 22, 23, 24",
    "25, 26, 27, 28, 29, 30",
    "31, 32, 33, 34, 35, 36"
  ];

  applyDataValues(itemIds,itemIdsDataValue);
}
function set_dataValues_street() {
  const itemIds = [
      "cellStreet_1",
      "cellStreet_4",
      "cellStreet_7",
      "cellStreet_10",
      "cellStreet_13",
      "cellStreet_16",
      "cellStreet_19",
      "cellStreet_22",
      "cellStreet_25",
      "cellStreet_28",
      "cellStreet_31",
      "cellStreet_34"
  ];

  const itemIdsDataValue = [
      "1, 2, 3",
      "4, 5, 6",
      "7, 8, 9",
      "10, 11, 12",
      "13, 14, 15",
      "16, 17, 18",
      "19, 20, 21",
      "22, 23, 24",
      "25, 26, 27",
      "28, 29, 30",
      "31, 32, 33",
      "34, 35, 36"
  ];

  applyDataValues(itemIds,itemIdsDataValue);
}

function applyDataValues(itemIds,itemIdsDataValue)
{
    itemIds.forEach((itemId, index) => {
      const div = document.getElementById(itemId);
      if (div) {
          div.setAttribute('data-values', itemIdsDataValue[index]);
      }
    });
}


function split_row_dataset() {
  let splitIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3;  // Total columns for each row

  for (let row = 0; row < rows; row++) {
      for (let col = 0; col < cols - 1; col++) { // Iterate only up to the second last column of each row
          let leftNumber = row * cols + col + 1;
          let rightNumber = leftNumber + 1;

          // Generate the ID for the split between horizontally adjacent numbers
          let splitId = `${leftNumber}, ${rightNumber}`;
          splitIds.push(splitId);
      }
  }

  return splitIds;
}
function quad_dataset() {
  let quadIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3;  // Total columns

  for (let row = 1; row <= rows - 1; row++) { // Row boundary (not last row)
      for (let col = 1; col <= cols - 1; col++) { // Column boundary (not last column)
          // Calculate the numbers in the quad
          let topLeft = (row - 1) * cols + col;
          let topRight = topLeft + 1;
          let bottomLeft = topLeft + cols;
          let bottomRight = bottomLeft + 1;

          // Generate the ID using these numbers
          let quadId = `${topLeft}, ${topRight}, ${bottomLeft}, ${bottomRight}`;
          quadIds.push(quadId);
      }
  }

  return quadIds;
}

function split_col_dataset() {
  let splitIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3; // Total columns
  
  // Loop through each row, but only up to the last row to avoid non-existent splits
  for (let row = 0; row < rows - 1; row++) {
      // Loop over each column
      for (let col = 0; col < cols; col++) {
          let topNumber = row * cols + col + 1;
          
          // Generate the ID for the split between vertically adjacent numbers
          let bottomNumber = topNumber + cols; // Number directly below in the same column
          let splitId = `${topNumber}, ${bottomNumber}`;
          splitIds.push(splitId);
      }
  }
  
  return splitIds;
}

function split_row_ids() {
  let splitIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3;  // Total columns

  // Loop over each row
  for (let row = 0; row < rows; row++) {
      // Loop only up to the second last column to avoid creating non-existent splits
      for (let col = 0; col < cols - 1; col++) { 
          let leftNumber = row * cols + col + 1;
          let rightNumber = leftNumber + 1;

          // Generate the ID for the split between horizontally adjacent numbers
          let splitId = `cellSplitAcross_${leftNumber}`;
          splitIds.push(splitId);
      }
  }

  return splitIds;
}
function split_col_ids() {
  let splitIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3; // Total columns

  for (let row = 0; row < rows - 1; row++) {
      // Loop over each column
      for (let col = 0; col < cols; col++) {
          let topNumber = row * cols + col + 1;
          let splitId = `cellSplitDown_${topNumber}`;
          splitIds.push(splitId);
      }
  }
  
  return splitIds;
}

function quad_ids() {
  let quadIds = [];
  const rows = 12; // Total rows in standard roulette table layout
  const cols = 3;  // Total columns

  for (let row = 1; row <= rows - 1; row++) { // Row boundary (not last row)
      for (let col = 1; col <= cols - 1; col++) { // Column boundary (not last column)
          // Calculate the numbers in the quad
          let topLeft = (row - 1) * cols + col;
          let topRight = topLeft + 1;
          let bottomLeft = topLeft + cols;
          let bottomRight = bottomLeft + 1;

          // Generate the ID using these numbers
          let quadId = `cellQuad_${topLeft}`;
          quadIds.push(quadId);
      }
  }

  return quadIds;
}

