function board()
{
    let mainContainer = document.createElement('div');
    let dozen = layout_dozens();
    let numPad = layout_number_pad();
    
    mainContainer.appendChild(dozen);
    mainContainer.appendChild(numPad);
    
    return mainContainer;
}
function layout_dozens() {

    function setText(value) {
        const textContainer = document.createElement('div');
        textContainer.style.display = 'flex';
        textContainer.style.justifyContent = 'center'; // Center content horizontally
        textContainer.style.alignItems = 'center'; // Center content vertically
        textContainer.style.height = '100%'; // Ensure container fills parent
        textContainer.style.transform = 'rotate(90deg)'; // Rotate container 90 degrees
        textContainer.style.transformOrigin = 'center'; // Rotate from the center of the container
    
        const textSpan = document.createElement('span');
        textSpan.textContent = value;
        textSpan.style.display = 'inline-block'; // Ensure it's treated as a single line
        textSpan.style.whiteSpace = 'nowrap'; // Prevent automatic line breaks
    
        textContainer.appendChild(textSpan);
        return textContainer;
    }
    

    const outsideContainer = document.createElement('div');
    const container = document.createElement('div');
    container.style.position = 'relative'; // Changed to 'relative' to position children absolutely within it

    const d1 = document.createElement('div');
    d1.id = 'dozen1';
    d1.style.width = '25px';
    d1.style.height = '136px'; 
    d1.style.top = '0px';
    //d1.style.marginTop = '35px';
    d1.style.borderTop = '2px solid black';
    d1.style.borderLeft = '2px solid black';
    d1.style.borderBottom = 'none';
    d1.style.borderRight = '2px solid black';
    d1.appendChild(setText('1st 12'));

    const d2 = document.createElement('div');
    d2.id = 'dozen2';
    d2.style.width = '25px'; // Corrected property
    d2.style.height = '138px';
    d2.style.top = '25px'; // Position below d1
    d2.style.borderTop = '2px solid black';
    d2.style.borderLeft = '2px solid black';
    d2.style.borderBottom = 'none';
    d2.style.borderRight = '2px solid black';
    text = setText('2nd 12');
    d2.appendChild(text);


    const d3 = document.createElement('div');
    d3.id = 'dozen3';
    //d3.style.position = 'absolute';
    d3.style.width = '25px'; // Corrected property
    d3.style.height = '139px';
    d3.style.top = '50px'; // Position below d2
    d3.style.border = '2px solid black';
    text = setText('3rd 12');
    d3.appendChild(text);


    container.append(d1, d2, d3);

    outsideContainer.append(container);
    return outsideContainer;
}

function layout_number_pad() {

    const outsideContainer = document.createElement('div');
	const numberPadContainer = document.createElement('div');
	//numberPadContainer.style.position = 'absolute';
	//numberPadContainer.style.marginLeft = '1100px';
	numberPadContainer.style.display = 'flex';
	numberPadContainer.style.flexWrap = 'wrap';
	numberPadContainer.style.width = '158px';

	function createButton(number) {
	    
		const button = document.createElement('button');
		button.textContent = number;
		button.style.width = '50px';
		button.style.height = '35px';
        button.style.color = 'white';

		button.addEventListener('click', function () {
			numberPadSpin(number);
		});

        if(number == 0)
        {
            button.style.backgroundColor = 'rgb(146, 196, 150)';
        }
        if(numBlack.includes(parseInt(number))){
            button.style.backgroundColor = 'rgb(68, 60, 60)';
        }
       
        if(numRed.includes(parseInt(number))){
            button.style.backgroundColor = 'rgb(221, 82, 82)';
        }

		return button;
	}

	function createPlaceholder() {
		const placeholder = document.createElement('div');
		placeholder.style.width = '50px';
		placeholder.style.height = '35px';
		placeholder.style.visibility = 'hidden';
		return placeholder;
	}

	numberPadContainer.appendChild(createPlaceholder());
	numberPadContainer.appendChild(createButton('0'));
	numberPadContainer.appendChild(createPlaceholder());

	for (let i = 1; i <= 36; i++) {
		numberPadContainer.appendChild(createButton(i.toString()));
	}
    outsideContainer.append(numberPadContainer);
	return outsideContainer;

}



